<?php
/**
 * Social Share Shortcode
 */

function impeka_wpb_ext_social_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'social.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_social', 'impeka_wpb_ext_social_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_social_shortcode_params' ) ) {
	function impeka_wpb_ext_social_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Social Share", "impeka-wpb-extension" ),
			"description" => esc_html__( "Place your preferred social", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-social",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "E-mail", "impeka-wpb-extension" ),
						"param_name" => "social_email",
						"description" => esc_html__( "Share with E-mail", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show E-mail social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Facebook", "impeka-wpb-extension" ),
						"param_name" => "social_facebook",
						"description" => esc_html__( "Share in Facebook", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show Facebook social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Twitter", "impeka-wpb-extension" ),
						"param_name" => "social_twitter",
						"description" => esc_html__( "Share in Twitter", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show Twitter social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Linkedin", "impeka-wpb-extension" ),
						"param_name" => "social_linkedin",
						"description" => esc_html__( "Share in Linkedin", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show Linkedin social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "reddit", "impeka-wpb-extension" ),
						"param_name" => "social_reddit",
						"description" => esc_html__( "Submit in reddit", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show reddit social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Pinterest", "impeka-wpb-extension" ),
						"param_name" => "social_pinterest",
						"description" => esc_html__( "Submit in Pinterest (Featured Image is used as image)", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show Pinterest social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "Tumblr", "impeka-wpb-extension" ),
						"param_name" => "social_tumblr",
						"description" => esc_html__( "Submit in Tumblr", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show Tumblr social share", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => 'checkbox',
						"heading" => esc_html__( "(Greatives) Likes", "impeka-wpb-extension" ),
						"param_name" => "likes",
						"description" => esc_html__( "(Greatives) Likes", "impeka-wpb-extension" ),
						"value" => array( esc_html__( "Show (Greatives) Likes", "impeka-wpb-extension" ) => 'yes' ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon size", "impeka-wpb-extension" ),
						"param_name" => "icon_size",
						"value" => array(
							esc_html__( "Extra Large", "impeka-wpb-extension" ) => 'extra-large',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
							esc_html__( "Extra Small", "impeka-wpb-extension" ) => 'extra-small',
						),
						"std" => 'medium',
						"description" => '',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Item Spacing", "impeka-wpb-extension" ),
						"param_name" => "item_space",
						"value" => array( '0', '1', '5', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60' ),
						"std" => '15',
						"description" => esc_html__( "Set the space that will display on each side of your social items in px.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon Color", "impeka-wpb-extension" ),
						"param_name" => "icon_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'primary-1',
						"description" => esc_html__( "Color of the social icon.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Icon shape", "impeka-wpb-extension" ),
						"param_name" => "icon_shape",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'no-shape',
							esc_html__( "Square", "impeka-wpb-extension" ) => 'square',
							esc_html__( "Round", "impeka-wpb-extension" ) => 'round',
							esc_html__( "Circle", "impeka-wpb-extension" ) => 'circle',
						),
						"description" => '',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Shape type", "impeka-wpb-extension" ),
						"param_name" => "shape_type",
						"value" => array(
							esc_html__( "Simple", "impeka-wpb-extension" ) => 'simple',
							esc_html__( "Outline", "impeka-wpb-extension" ) => 'outline',
						),
						"description" => esc_html__( "Select shape type.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
					),					
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Shape Color", "impeka-wpb-extension" ),
						"param_name" => "shape_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'primary-1',
						"description" => esc_html__( "Color of the shape.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "icon_shape", 'value' => array( 'square', 'round', 'circle' ) ),
					),
					impeka_wpb_ext_add_inherit_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
					array(
						"type" => "el_id",
						"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
						'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
						"param_name" => "el_id",
						'settings' => array(
							'auto_generate' => true,
						),
					),
				),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_social', 'impeka_wpb_ext_social_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
