<?php
/**
 * Image Text Shortcode
 */

function impeka_split_content( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'split-content.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_split_content', 'impeka_split_content' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_split_content_shortcode_params' ) ) {
	function impeka_wpb_ext_split_content_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Split Content", "impeka-wpb-extension" ),
			"description" => esc_html__( "Combine image or video with text and button", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-split-content",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				array(
					//General Tab
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Title", "impeka-wpb-extension" ),
						"param_name" => "title",
						"value" => "",
						"description" => esc_html__( "Enter your title.", "impeka-wpb-extension" ),
						"admin_label" => true,
					),
					impeka_wpb_ext_get_heading_tag( "h3" ),
					impeka_wpb_ext_get_heading( "h3" ),
					impeka_wpb_ext_get_heading_increase(),
					impeka_wpb_ext_get_heading_increase_reset(),
					impeka_wpb_ext_get_custom_font_family(),
					impeka_wpb_ext_get_split_title(),
					impeka_wpb_ext_get_split_title_space(),
					array(
						"type" => "textarea",
						"heading" => esc_html__( "Text", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "",
						"description" => esc_html__( "Enter your text.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
						"param_name" => "text_style",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Leader", "impeka-wpb-extension" ) => 'leader-text',
							esc_html__( "Subtitle", "impeka-wpb-extension" ) => 'subtitle-text',
							esc_html__( "Page Description", "impeka-wpb-extension" ) => 'page-description',
						),
						"description" => esc_html__( "Select your text style", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						'edit_field_class' => 'vc_col-sm-6',
						"heading" => esc_html__( "Split Content Height", "impeka-wpb-extension" ),
						"param_name" => "split_content_height",
						"description" => esc_html__( "Select the height of your split content", "impeka-wpb-extension" ),
						"value" => array(
							esc_html__( "Fullscreen", "impeka-wpb-extension" ) => 'fullscreen',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						),
					),
					array(
						"type" => "textfield",
						'edit_field_class' => 'vc_col-sm-6',
						"heading" => esc_html__( "Split Content Min Height", "impeka-wpb-extension" ),
						"param_name" => "min_height",
						"value" => "300",
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Media Type", "impeka-wpb-extension" ),
						"param_name" => "media_type",
						'value' => array(
							esc_html__( 'Image', 'impeka-wpb-extension' ) => 'image',
							esc_html__( 'Slider', 'impeka-wpb-extension' ) => 'slider',
							esc_html__( 'Hosted Video', 'impeka-wpb-extension' ) => 'hosted_video',
							esc_html__( 'YouTube Video', 'impeka-wpb-extension' ) => 'video',
						),
						"std" => '',
						"description" => esc_html__( "Select your Media Type.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "YouTube link", "impeka-wpb-extension" ),
						"param_name" => "bg_video_url",
						'value' => 'https://www.youtube.com/watch?v=0s4_7BuszuQ',
						"description" => esc_html__( "Add YouTube link.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__("WebM File URL", 'impeka-wpb-extension'),
						"param_name" => "bg_video_webm",
						"description" => esc_html__( "Fill WebM and mp4 format for browser compatibility", 'impeka-wpb-extension' ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'hosted_video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "MP4 File URL", 'impeka-wpb-extension' ),
						"param_name" => "bg_video_mp4",
						"description" => esc_html__( "Fill mp4 format URL", 'impeka-wpb-extension' ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'hosted_video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "OGV File URL", 'impeka-wpb-extension' ),
						"param_name" => "bg_video_ogv",
						"description" => esc_html__( "Fill OGV format URL ( optional )", 'impeka-wpb-extension' ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'hosted_video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Allow on devices", 'impeka-wpb-extension' ),
						"param_name" => "bg_video_device",
						"value" => array(
							esc_html__( "No", 'impeka-wpb-extension' ) => 'no',
							esc_html__( "Yes", 'impeka-wpb-extension' ) => 'yes',

						),
						"std" => 'no',
						"dependency" => array( 'element' => "media_type", 'value' => array( 'hosted_video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
						"param_name" => "bg_image",
						"value" => '',
						"description" => esc_html__( "Select an image. Used also as fallback for video.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'hosted_video', 'video' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type"			=> "attach_images",
						"admin_label"	=> true,
						"class"			=> "",
						"heading"		=> esc_html__( "Attach Images", "impeka-wpb-extension" ),
						"param_name"	=> "ids",
						"value" => '',
						"description"	=> esc_html__( "Select your slider images.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
						"param_name" => "bg_image_size",
						'value' => array(
							esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Resize ( Extra Extra Large )', 'impeka-wpb-extension' ) => 'extra-extra-large',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
						),
						"std" => '',
						"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
						"param_name" => "loop",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
						"param_name" => "auto_play",
						"value" => array(
							esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
							esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
						"param_name" => "slideshow_speed",
						"value" => '3000',
						"description" => esc_html__( "Slideshow Speed in ms.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Transition", "impeka-wpb-extension" ),
						"param_name" => "transition",
						"value" => array(
							esc_html__( "Slide", "impeka-wpb-extension" ) => 'slide',
							esc_html__( "Fade", "impeka-wpb-extension" ) => 'fade',
						),
						"description" => esc_html__( "Transition Effect.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "media_type", 'value' => array( 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Background  Position", 'impeka-wpb-extension' ),
						"param_name" => "bg_position",
						"value" => array(
							esc_html__( 'Left Top', 'impeka-wpb-extension' ) => 'left-top',
							esc_html__( 'Left Center', 'impeka-wpb-extension' ) => 'left-center',
							esc_html__( 'Left Bottom', 'impeka-wpb-extension' ) => 'left-bottom',
							esc_html__( 'Center Top', 'impeka-wpb-extension' ) => 'center-top',
							esc_html__( 'Center Center', 'impeka-wpb-extension' ) => 'center-center',
							esc_html__( 'Center Bottom', 'impeka-wpb-extension' ) => 'center-bottom',
							esc_html__( 'Right Top', 'impeka-wpb-extension' ) => 'right-top',
							esc_html__( 'Right Center', 'impeka-wpb-extension' ) => 'right-center',
							esc_html__( 'Right Bottom', 'impeka-wpb-extension' ) => 'right-bottom',
						),
						"description" => esc_html__( "Select position for background image", 'impeka-wpb-extension' ),
						"std" => 'center-center',
						"dependency" => array( 'element' => "media_type", 'value' => array( 'image', 'slider' ) ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => 'dropdown',
						"heading" => esc_html__( "Media Position", "impeka-wpb-extension" ),
						"param_name" => "split_content_align",
						"description" => esc_html__( "Set the position of your media", "impeka-wpb-extension" ),
						"value" => array(
							esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
							esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Color overlay", "impeka-wpb-extension" ),
						"param_name" => "color_overlay",
						'edit_field_class' => 'vc_col-sm-6',
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"std" => 'black',
						"description" => esc_html__( "A color overlay for the background image.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Opacity overlay", "impeka-wpb-extension" ),
						"param_name" => "opacity_overlay",
						'edit_field_class' => 'vc_col-sm-6',
						"value" => array( '0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100' ),
						"std" => '70',
						"description" => esc_html__( "Choose the opacity for the overlay.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Overlapping Title Color", "impeka-wpb-extension" ),
						"param_name" => "overlapping_title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"description" => esc_html__( "Color of the overlapping title.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Media", "impeka-wpb-extension" ),
					),
				),
				//Button Tab
				impeka_wpb_ext_get_button_params( 'split-content' ),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_split_content', 'impeka_wpb_ext_split_content_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
