<?php
/**
 * Team Shortcode
 */

function impeka_wpb_ext_team_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'team.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_team', 'impeka_wpb_ext_team_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_team_shortcode_params' ) ) {
	function impeka_wpb_ext_team_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Team", "impeka-wpb-extension" ),
			"description" => esc_html__( "Show your team members", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-team",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Team Layout", "impeka-wpb-extension" ),
						"param_name" => "team_layout",
						"value" => array(
							esc_html__( "Layout 1", "impeka-wpb-extension" ) => 'layout-1',
							esc_html__( "Layout 2", "impeka-wpb-extension" ) => 'layout-2',
							esc_html__( "Layout 3", "impeka-wpb-extension" ) => 'layout-3',
							esc_html__( "Layout 4", "impeka-wpb-extension" ) => 'layout-4',
						),
						"description" => esc_html__( "Layout of the team.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Size", "impeka-wpb-extension" ),
						"param_name" => "image_size",
						'value' => apply_filters( 'impeka_wpb_ext_image_options', array(
							esc_html__( 'Full ( Custom )', 'impeka-wpb-extension' ) => '',
							esc_html__( 'Square Small Crop', 'impeka-wpb-extension' ) => 'square',
							esc_html__( 'Landscape Small Crop', 'impeka-wpb-extension' ) => 'landscape',
							esc_html__( 'Portrait Small Crop', 'impeka-wpb-extension' ) => 'portrait',
							esc_html__( 'Resize ( Large )', 'impeka-wpb-extension' ) => 'large',
							esc_html__( 'Resize ( Medium Large )', 'impeka-wpb-extension' ) => 'medium_large',
							esc_html__( 'Resize ( Medium )', 'impeka-wpb-extension' ) => 'medium',
						) ),
						"description" => esc_html__( "Select your Image Size.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
						"param_name" => "image",
						"value" => '',
						"description" => esc_html__( "Select an image.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "attach_image",
						"heading" => esc_html__( "Retina Image", "impeka-wpb-extension" ),
						"param_name" => "retina_image",
						"value" => '',
						"description" => esc_html__( "Select a 2x image.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "image_size", 'value' => array( '' ) ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Load Mode", "impeka-wpb-extension" ),
						"param_name" => "image_load_mode",
						'value' => array(
							esc_html__( "Inherit", "impeka-wpb-extension" ) => '',
							esc_html__( "Off", "impeka-wpb-extension" ) => 'off',
							esc_html__( "Native Lazyload", "impeka-wpb-extension" ) => 'native-lazyload',
							esc_html__( "Theme Lazyload", "impeka-wpb-extension" ) => 'lazyload',
						),
						"description" => esc_html__( "Enable Lazy load.", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Effect", "impeka-wpb-extension" ),
						"param_name" => "image_effect",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Grayscale Image", "impeka-wpb-extension" ) => 'grayscale-image',
							esc_html__( "Colored on Hover", "impeka-wpb-extension" ) => 'grayscale-image-hover',
						),
						"std" => '',
						"description" => esc_html__( "Choose the image effect.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Image Animation Effect", "impeka-wpb-extension" ),
						"param_name" => "image_animation_effect",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => '',
							esc_html__( "Mouse Move", "impeka-wpb-extension" ) => 'mouse-move',
						),
						"std" => 'mouse-move',
						"description" => esc_html__( "Choose the image animation effect.", "impeka-wpb-extension" ),
						'edit_field_class' => 'vc_col-sm-6',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Name", "impeka-wpb-extension" ),
						"param_name" => "name",
						"value" => "John Smith",
						"description" => esc_html__( "Enter your team name.", "impeka-wpb-extension" ),
						"save_always" => true,
						"admin_label" => true,
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Name Color", "impeka-wpb-extension" ),
						"param_name" => "name_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your name.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-3', 'layout-4' ) ),
					),
					impeka_wpb_ext_get_heading_tag( "h3" ),
					impeka_wpb_ext_get_heading( "h5" ),
					impeka_wpb_ext_get_custom_font_family(),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Identity", "impeka-wpb-extension" ),
						"param_name" => "identity",
						"value" => "",
						"description" => esc_html__( "Enter your team identity/profession e.g: Designer", "impeka-wpb-extension" ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Identity Color", "impeka-wpb-extension" ),
						"param_name" => "identity_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
						"description" => esc_html__( "Select the color of your identity.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-3', 'layout-4' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
						"param_name" => "shadow",
						"value" => array(
							esc_html__( "No", "impeka-wpb-extension" ) => '',
							esc_html__( "Small", "impeka-wpb-extension" ) => 'small-shadow',
							esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium-shadow',
							esc_html__( "Large", "impeka-wpb-extension" ) => 'large-shadow',
						),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
						"param_name" => "radius",
						"value" => array(
							esc_html__( "None", "impeka-wpb-extension" ) => 'none',
							esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
							esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
							esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
							esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
							esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
							esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
							esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
							esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
						),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Socials
				array(
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Facebook", "impeka-wpb-extension" ),
						"param_name" => "social_facebook",
						"value" => "",
						"description" => esc_html__( "Enter facebook URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Twitter", "impeka-wpb-extension" ),
						"param_name" => "social_twitter",
						"value" => "",
						"description" => esc_html__( "Enter Twitter URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Linkedin", "impeka-wpb-extension" ),
						"param_name" => "social_linkedin",
						"value" => "",
						"description" => esc_html__( "Enter Linkedin URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Xing", "impeka-wpb-extension" ),
						"param_name" => "social_xing",
						"value" => "",
						"description" => esc_html__( "Enter Xing URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Instagram", "impeka-wpb-extension" ),
						"param_name" => "social_instagram",
						"value" => "",
						"description" => esc_html__( "Enter Instagram URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "YouTube", "impeka-wpb-extension" ),
						"param_name" => "social_youtube",
						"value" => "",
						"description" => esc_html__( "Enter YouTube URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Vimeo", "impeka-wpb-extension" ),
						"param_name" => "social_vimeo",
						"value" => "",
						"description" => esc_html__( "Enter Vimeo URL. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Email", "impeka-wpb-extension" ),
						"param_name" => "email",
						"value" => "",
						"description" => esc_html__( "Enter your email. Clear input if you don't want to display.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Socials", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "team_layout", 'value' => array( 'layout-1', 'layout-2' ) ),
					),
					array(
						"type" => "vc_link",
						"heading" => esc_html__( "Link", "impeka-wpb-extension" ),
						"param_name" => "link",
						"value" => "",
						"description" => esc_html__( "Enter link.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Link", "impeka-wpb-extension" ),
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Link Class", "impeka-wpb-extension" ),
						"param_name" => "link_class",
						"value" => "",
						"description" => esc_html__( "Enter extra class name for your link.", "impeka-wpb-extension" ),
						"group" => esc_html__( "Link", "impeka-wpb-extension" ),
					),
				),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_team', 'impeka_wpb_ext_team_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
