<?php
/**
 * Testimonial Carousel Shortcode
 */

function impeka_wpb_ext_testimonial_carousel_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'testimonial-carousel.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_testimonial_carousel', 'impeka_wpb_ext_testimonial_carousel_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_testimonial_carousel_shortcode_params' ) ) {
	function impeka_wpb_ext_testimonial_carousel_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Testimonial Carousel", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a captivating testimonial carousel", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-testimonial-carousel",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Testimonial Syle", "impeka-wpb-extension" ),
					"param_name" => "style",
					"value" => array(
						esc_html__( "Style 1 ( Classic )", "impeka-wpb-extension" ) => 'style-1',
						esc_html__( "Style 2 ( Classic )", "impeka-wpb-extension" ) => 'style-2',
						esc_html__( "Style 3 ( Classic )", "impeka-wpb-extension" ) => 'style-3',
						esc_html__( "Style 4", "impeka-wpb-extension" ) => 'style-4',
						esc_html__( "Style 5", "impeka-wpb-extension" ) => 'style-5',
					),
					"description" => esc_html__( "Select your testimonial style.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Type", "impeka-wpb-extension" ),
					"param_name" => "type",
					"admin_label" => true,
					"value" => array(
						esc_html__( 'Classic', 'impeka-wpb-extension' ) => 'classic',
						esc_html__( 'Advanced', 'impeka-wpb-extension' ) => 'advanced',
					),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"description" => esc_html__( "Select your Carousel Type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "items_per_page",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"description" => esc_html__( "Number of items per page", "impeka-wpb-extension" ),
					"std" => '3',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Landscape", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_landscape",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"description" => esc_html__( "Select number of items on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Tablet Portrait", "impeka-wpb-extension" ),
					"param_name" => "items_tablet_portrait",
					"value" => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '3',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"description" => esc_html__( "Select number of items on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Items Mobile", "impeka-wpb-extension" ),
					"param_name" => "items_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
					),
					'edit_field_class' => 'vc_col-sm-6',
					"std" => '1',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"description" => esc_html__( "Select number of items on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items to show", "impeka-wpb-extension" ),
					"param_name" => "items_to_show",
					"value" => '20',
					"description" => esc_html__( "Maximum Testimonial Items to Show", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"dependency" => array(
						'element' => "style", 'value' => array( 'style-4', 'style-5' ),
						'element' => "type", 'value' => array( 'classic' )
					),
					"description" => esc_html__( "Add gutter among images.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '30',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				//Styles and Titles
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Item Title", "impeka-wpb-extension" ),
					"param_name" => "show_title",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => 'yes',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "show_title", 'value' => array( 'yes' ) ),
					"std" => 'h3',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						esc_html__( "Page Title", "impeka-wpb-extension" ) => 'page-title',
						esc_html__( "Feature Title", "impeka-wpb-extension" ) => 'feature-title',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "show_title", 'value' => array( 'yes' ) ),
					"std" => 'h3',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Quote Text", "impeka-wpb-extension" ) => 'quote-text',
					),
					'std' => 'none',
					"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"std" => 'white',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Featured Image", "impeka-wpb-extension" ),
					"param_name" => "show_image",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => 'yes',
					"dependency" => array( 'element' => "style", 'value_not_equal_to' => array( 'style-2', 'style-3' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Alignment", "impeka-wpb-extension" ),
					"param_name" => "align",
					"value" => array(
						esc_html__( "Inherit", "impeka-wpb-extension" ) => 'inherit',
						esc_html__( "Left", "impeka-wpb-extension" ) => 'left',
						esc_html__( "Right", "impeka-wpb-extension" ) => 'right',
						esc_html__( "Center", "impeka-wpb-extension" ) => 'center',
					),
					"description" => '',
					"dependency" => array( 'element' => "style", 'value_not_equal_to' => array( 'style-4', 'style-5' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
					"dependency" => array( 'element' => "style", 'value' => array( 'style-4', 'style-5' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"dependency" => array( 'element' => "type", 'value' => array( 'advanced' ) ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				//Navigation
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Behavior", 'impeka-wpb-extension'),
					"param_name" => "label_behavior",
					'value' => '',
					"std" => '',
					"description" => esc_html__( "Configure the carousel behavior", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
					"param_name" => "loop",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Autoplay", "impeka-wpb-extension" ),
					"param_name" => "auto_play",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Slideshow Speed", "impeka-wpb-extension" ),
					"param_name" => "slideshow_speed",
					"value" => '3000',
					"description" => esc_html__( "Slideshow Speed in ms ( Only available for classic type ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_html__( "Pause on Hover", "impeka-wpb-extension" ),
					"param_name" => "pause_hover",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"std" => "no",
					"description" => esc_html__( "If selected, carousel will be paused on hover ( Only available for classic type ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Auto Height", "impeka-wpb-extension" ),
					"param_name" => "auto_height",
					"value" => array( esc_html__( "Select if you want smooth auto height", "impeka-wpb-extension" ) => 'yes' ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Carousel Pagination", "impeka-wpb-extension" ),
					"param_name" => "pagination",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
					"std" => 'yes',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Pagination Speed", "impeka-wpb-extension" ),
					"param_name" => "pagination_speed",
					"value" => '400',
					"description" => esc_html__( "Pagination Speed in ms. ( Only available for classic type )", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "pagination", 'value' => array( 'yes' ) ),
					"group" => esc_html__( "Navigation", "impeka-wpb-extension" ),
				),
				//Categories
				array(
					"type" => "textfield",
					"heading" => esc_html__("Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Testimonial Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories( 'testimonial_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_testimonial_carousel', 'impeka_wpb_ext_testimonial_carousel_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
