<?php
/**
 * Testimonial Shortcode
 */

function impeka_wpb_ext_testimonial_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'testimonial.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_testimonial', 'impeka_wpb_ext_testimonial_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_testimonial_shortcode_params' ) ) {
	function impeka_wpb_ext_testimonial_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Testimonial", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a captivating testimonial grid", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-testimonial",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Testimonial Mode", "impeka-wpb-extension" ),
					"param_name" => "mode",
					"value" => array(
						esc_html__( "Masonry", "impeka-wpb-extension" ) => 'masonry',
						esc_html__( "Grid", "impeka-wpb-extension" ) => 'grid',
					),
					"admin_label" => true,
					"description" => esc_html__( "Select your testimonial type.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Large Screen Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_large_screen",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
					),
					"std" => '3',
					"description" => esc_html__( "Select column on large devices.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Columns", "impeka-wpb-extension" ),
					"param_name" => "columns",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
					),
					"std" => '3',
					"description" => esc_html__( "Select number of columns.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Landscape Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_landscape",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, landscape orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Tablet Portrait Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_tablet_portrait",
					"value" => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					"std" => '2',
					"description" => esc_html__( "Select responsive column on tablet devices, portrait orientation.", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Mobile Columns", "impeka-wpb-extension" ),
					"param_name" => "columns_mobile",
					"value" => array(
						'1' => '1',
						'2' => '2',
					),
					"std" => '1',
					"description" => esc_html__( "Select responsive column on mobile devices.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Gutter between images", "impeka-wpb-extension" ),
					"param_name" => "item_gutter",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"description" => esc_html__( "Add gutter among images.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Gutter Size", "impeka-wpb-extension" ),
					"param_name" => "gutter_size",
					"value" => '40',
					"dependency" => array( 'element' => "item_gutter", 'value' => array( 'yes' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "CSS Animation", "impeka-wpb-extension"),
					"param_name" => "animation",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => '',
						esc_html__( "Fade In", "impeka-wpb-extension" ) => "fade-in",
						esc_html__( "Fade In Up", "impeka-wpb-extension" ) => "fade-in-up",
						esc_html__( "Fade In Down", "impeka-wpb-extension" ) => "fade-in-down",
						esc_html__( "Fade In Left", "impeka-wpb-extension" ) => "fade-in-left",
						esc_html__( "Fade In Right", "impeka-wpb-extension" ) => "fade-in-right",
						esc_html__( "Zoom In", "impeka-wpb-extension" ) => "zoom-in",
					),
					"description" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka-wpb-extension" ),
					"std" => "",
				),
				impeka_wpb_ext_add_order_by(),
				impeka_wpb_ext_add_order(),
				impeka_wpb_ext_add_margin_bottom(),
				array(
					"type" => "el_id",
					"heading" => esc_html__( "Element ID", "impeka-wpb-extension" ),
					'description' => esc_html__( "Enter element ID (Note: make sure it is unique)", "impeka-wpb-extension" ),
					"param_name" => "el_id",
					'settings' => array(
						'auto_generate' => true,
					),
				),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Testimonial Syle", "impeka-wpb-extension" ),
					"param_name" => "style",
					"value" => array(
						esc_html__( 'Style 4' , 'impeka-wpb-extension' ) => 'style-4',
						esc_html__( 'Style 5' , 'impeka-wpb-extension' ) => 'style-5',
					),
					"description" => esc_html__( "Select your testimonial style.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),				
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Item Title", "impeka-wpb-extension" ),
					"param_name" => "show_title",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => 'yes',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Tag", "impeka-wpb-extension" ),
					"param_name" => "heading_tag",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "div", "impeka-wpb-extension" ) => 'div',
					),
					"description" => esc_html__( "Title Tag for SEO", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "show_title", 'value' => array( 'yes' ) ),
					"std" => 'h3',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Size/Typography", "impeka-wpb-extension" ),
					"param_name" => "heading",
					"value" => array(
						esc_html__( "h1", "impeka-wpb-extension" ) => 'h1',
						esc_html__( "h2", "impeka-wpb-extension" ) => 'h2',
						esc_html__( "h3", "impeka-wpb-extension" ) => 'h3',
						esc_html__( "h4", "impeka-wpb-extension" ) => 'h4',
						esc_html__( "h5", "impeka-wpb-extension" ) => 'h5',
						esc_html__( "h6", "impeka-wpb-extension" ) => 'h6',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Link Text", "impeka-wpb-extension" ) => 'link-text',
						esc_html__( "Page Title", "impeka-wpb-extension" ) => 'page-title',
						esc_html__( "Feature Title", "impeka-wpb-extension" ) => 'feature-title',
					),
					"description" => esc_html__( "Title size and typography, defined in Theme Options - Typography Options", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "show_title", 'value' => array( 'yes' ) ),
					"std" => 'h3',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Style", "impeka-wpb-extension" ),
					"param_name" => "text_style",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Leader Text", "impeka-wpb-extension" ) => 'leader-text',
						esc_html__( "Subtitle Text", "impeka-wpb-extension" ) => 'subtitle-text',
						esc_html__( "Small Text", "impeka-wpb-extension" ) => 'small-text',
						esc_html__( "Quote", "impeka-wpb-extension" ) => 'quote-text',
					),
					"std" => 'none',
					"description" => esc_html__( "Select your text style.", 'impeka-wpb-extension' ),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Featured Image", "impeka-wpb-extension" ),
					"param_name" => "show_image",
					"value" => array(
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
					),
					"std" => 'yes',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
					"param_name" => "title_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"std" => 'black',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array(),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
					"std" => 'white',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Border Radius", "impeka-wpb-extension" ),
					"param_name" => "radius",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Radius 3px", "impeka-wpb-extension" ) => '3',
						esc_html__( "Radius 5px", "impeka-wpb-extension" ) => '5',
						esc_html__( "Radius 10px", "impeka-wpb-extension" ) => '10',
						esc_html__( "Radius 15px", "impeka-wpb-extension" ) => '15',
						esc_html__( "Radius 20px", "impeka-wpb-extension" ) => '20',
						esc_html__( "Radius 25px", "impeka-wpb-extension" ) => '25',
						esc_html__( "Radius 30px", "impeka-wpb-extension" ) => '30',
						esc_html__( "Radius 35px", "impeka-wpb-extension" ) => '35',
					),
					"description" => '',
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Add Shadow", "impeka-wpb-extension" ),
					"param_name" => "shadow",
					"value" => array(
						esc_html__( "None", "impeka-wpb-extension" ) => 'none',
						esc_html__( "Small", "impeka-wpb-extension" ) => 'small',
						esc_html__( "Medium", "impeka-wpb-extension" ) => 'medium',
						esc_html__( "Large", "impeka-wpb-extension" ) => 'large',
					),
					"group" => esc_html__( "Styles & Titles", "impeka-wpb-extension" ),
				),				
				array(
					"type" => 'impeka_param_label',
					"heading" => esc_html__( "Pagination", 'impeka-wpb-extension'),
					"description" => esc_html__( "Define the items to show per page or the total items number according to the selected display style.", "impeka-wpb-extension" ),
					"param_name" => "label_pagination",
					'value' => '',
					"std" => '',
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Items per page", "impeka-wpb-extension" ),
					"param_name" => "posts_per_page",
					"value" => '20',
					"description" => esc_html__( "Enter how many items per page you want to display.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Display Style", "impeka-wpb-extension" ),
					"param_name" => "display_style",
					"value" => array(
						esc_html__( "Show All", "impeka-wpb-extension" ) => '',
						esc_html__( "Pagination", "impeka-wpb-extension" ) => 'pagination',
						esc_html__( "Load More", "impeka-wpb-extension" ) => 'load-more',
						esc_html__( "Infinite Scroll", "impeka-wpb-extension" ) => 'infinite-scroll',
					),
					"std" => 'pagination',
					"description" => esc_html__( "Select display style", "impeka-wpb-extension" ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Load More Title", "impeka-wpb-extension" ),
					"param_name" => "load_more_title",
					"value" => 'Load More',
					"description" => esc_html__( "Title for load more.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "display_style", 'value' => array( 'load-more' ) ),
					"group" => esc_html__( "Pagination & Extras", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Exclude Posts", "impeka-wpb-extension" ),
					"param_name" => "exclude_posts",
					"value" => '',
					"description" => esc_html__( "Type the post ids you want to exclude separated by comma ( , ).", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "impeka_wpb_ext_multi_checkbox",
					"heading" => esc_html__("Testimonial Categories", "impeka-wpb-extension" ),
					"param_name" => "categories",
					"value" => impeka_wpb_ext_get_post_categories( 'testimonial_category' ),
					"description" => esc_html__( "Select all or multiple categories.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Include Specific Posts", "impeka-wpb-extension" ),
					"param_name" => "include_posts",
					"value" => '',
					"description" => esc_html__( "Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Categories", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_testimonial', 'impeka_wpb_ext_testimonial_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
