<?php
/**
 * Title Shortcode
 */

function impeka_wpb_ext_title_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'title.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_title', 'impeka_wpb_ext_title_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_title_shortcode_params' ) ) {
	function impeka_wpb_ext_title_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Title", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a title in many and diverse ways", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-title",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array_merge(
				//General Tab
				array(
					array(
						"type" => "textarea_html",
						"heading" => esc_html__( "Title Content", "impeka-wpb-extension" ),
						"param_name" => "content",
						"value" => "Sample Title",
						"description" => esc_html__( "Enter your title here.", "impeka-wpb-extension" ),
						"save_always" => true,
						"admin_label" => true,
					),
					impeka_wpb_ext_get_heading_tag( "h3" ),
					impeka_wpb_ext_get_heading( "h3" ),
					impeka_wpb_ext_get_heading_increase(),
					impeka_wpb_ext_get_heading_increase_reset(),
					impeka_wpb_ext_get_custom_font_family(),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Title Color", "impeka-wpb-extension" ),
						"param_name" => "title_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'gradient', 'standard', 'custom'] ),
						"description" => esc_html__( "Select the color of your title.", "impeka-wpb-extension" ),
					),
					array(
						'type' => 'colorpicker',
						'heading' => esc_html__( "Custom Title Color", "impeka-wpb-extension" ),
						'param_name' => 'title_color_custom',
						'description' => esc_html__( "Select a custom color for your title", "impeka-wpb-extension" ),
						"std" => '#e1e1e1',
						"dependency" => array( 'element' => "title_color", 'value' => array( 'custom' ) ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line type", "impeka-wpb-extension" ),
						"param_name" => "line_type",
						"value" => array(
							esc_html__( "No Line", "impeka-wpb-extension" ) => '',
							esc_html__( "Top Line", "impeka-wpb-extension" ) => 'top-line',
							esc_html__( "Left Line", "impeka-wpb-extension" ) => 'left-line',
							esc_html__( "Right Line", "impeka-wpb-extension" ) => 'right-line',
							esc_html__( "Bottom Line", "impeka-wpb-extension" ) => 'bottom-line',
						),
						"description" => '',
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( "Line Width", "impeka-wpb-extension" ),
						"param_name" => "line_width",
						"value" => "50",
						"description" => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'not_empty' => true ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line Height", "impeka-wpb-extension" ),
						"param_name" => "line_height",
						"value" => array( '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ),
						"std" => '2',
						"description" => esc_html__( "Enter the hight for your line in px.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'not_empty' => true ),
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__( "Line Color", "impeka-wpb-extension" ),
						"param_name" => "line_color",
						"param_holder_class" => "grve-colored-dropdown",
						"value" => impeka_wpb_ext_get_color_array(),
						"description" => esc_html__( "Color for the line.", "impeka-wpb-extension" ),
						"dependency" => array( 'element' => "line_type", 'not_empty' => true ),
					),
					impeka_wpb_ext_add_inherit_align(),
					impeka_wpb_ext_add_margin_bottom(),
					impeka_wpb_ext_add_el_class(),
				),
				//Animation Tab
				array(
					impeka_wpb_ext_add_animation_clipping(),
					impeka_wpb_ext_add_clipping(),
					impeka_wpb_ext_add_appear(),
					impeka_wpb_ext_add_clipping_colors(),
					impeka_wpb_ext_add_animation_delay(),
					impeka_wpb_ext_add_animation_duration(),
				)
			)
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_title', 'impeka_wpb_ext_title_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
