<?php
/**
 * Typed Text Shortcode
 */

function impeka_wpb_ext_typed_text_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'typed-text.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_typed_text', 'impeka_wpb_ext_typed_text_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_typed_text_shortcode_params' ) ) {
	function impeka_wpb_ext_typed_text_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Typed text", "impeka-wpb-extension" ),
			"description" => esc_html__( "Add a typed text", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-typed-text",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Prefix", "impeka-wpb-extension" ),
					"param_name" => "typed_prefix",
					"value" => "",
					"description" => esc_html__( "Enter prefix text.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "exploded_textarea",
					"heading" => esc_html__("Typed Text", "impeka-wpb-extension"),
					"param_name" => "typed_values",
					"description" => esc_html__( "Input Typed Text here. Divide values with linebreaks (Enter).", "impeka-wpb-extension" ),
					"value" => "These are the default values...,Use your own values!",
					"save_always" => true,
					"admin_label" => true,
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Suffix", "impeka-wpb-extension" ),
					"param_name" => "typed_suffix",
					"value" => "",
					"description" => esc_html__( "Enter suffix text.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_get_heading_tag( "h3" ),
				impeka_wpb_ext_get_heading( "h3" ),
				impeka_wpb_ext_get_heading_increase(),
				impeka_wpb_ext_get_heading_increase_reset(),
				impeka_wpb_ext_get_custom_font_family(),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Typed Text Color", "impeka-wpb-extension" ),
					"param_name" => "text_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
					"description" => esc_html__( "Color of the typed text.", "impeka-wpb-extension" ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Background Color", "impeka-wpb-extension" ),
					"param_name" => "text_bg_color",
					"param_holder_class" => "grve-colored-dropdown",
					"value" => impeka_wpb_ext_get_color_array( ['none', 'primary', 'standard'] ),
					"std" => 'none',
					"description" => esc_html__( "Background color for the typed text.", "impeka-wpb-extension" ),
				),
				impeka_wpb_ext_add_inherit_align(),
				impeka_wpb_ext_add_animation(),
				impeka_wpb_ext_add_animation_delay(),
				impeka_wpb_ext_add_animation_duration(),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Text Speed", "impeka-wpb-extension" ),
					"param_name" => "textspeed",
					"value" => 100,
					"description" => esc_html__( "Enter text speed in ms.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Backspeed", "impeka-wpb-extension" ),
					"param_name" => "backspeed",
					"value" => 80,
					"description" => esc_html__( "Enter speed of delete in ms.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Start Delay", "impeka-wpb-extension" ),
					"param_name" => "startdelay",
					"value" => 0,
					"description" => esc_html__( "Enter start delay in ms.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Back Delay", "impeka-wpb-extension" ),
					"param_name" => "backdelay",
					"value" => 500,
					"description" => esc_html__( "Enter back delay in ms.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Loop", "impeka-wpb-extension" ),
					"param_name" => "loop",
					"value" => array( esc_html__( "Enable loop", "impeka-wpb-extension" ) => 'yes' ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
				array(
					"type" => 'checkbox',
					"heading" => esc_html__( "Show Cursor", "impeka-wpb-extension" ),
					"param_name" => "show_cursor",
					"value" => array( esc_html__( "Show Cursor", "impeka-wpb-extension" ) => 'yes' ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
					"std" => 'yes',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Cursor Text", "impeka-wpb-extension" ),
					"param_name" => "cursor_text",
					"value" => "|",
					"description" => esc_html__( "Enter cursor text.", "impeka-wpb-extension" ),
					"group" => esc_html__( "Extra Settings", "impeka-wpb-extension" ),
				),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_typed_text', 'impeka_wpb_ext_typed_text_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
