<?php
/**
 * Video Shortcode
 */

function impeka_wpb_ext_video_shortcode( $atts, $content ) {
	return impeka_wpb_ext_locate_template( 'video.php', array( 'atts' => $atts, 'content' => $content) );
}
add_shortcode( 'impeka_video', 'impeka_wpb_ext_video_shortcode' );

/**
 * Add shortcode to Page Builder
 */

if( !function_exists( 'impeka_wpb_ext_video_shortcode_params' ) ) {
	function impeka_wpb_ext_video_shortcode_params( $tag ) {
		return array(
			"name" => esc_html__( "Video", "impeka-wpb-extension" ),
			"description" => esc_html__( "Embed YouTube/Vimeo player", "impeka-wpb-extension" ),
			"base" => $tag,
			"class" => "",
			"icon"      => "icon-wpb-grve-video",
			"category" => esc_html__( "Content", "js_composer" ),
			'front_enqueue_js'  => IMPEKA_WPB_EXT_PLUGIN_DIR_URL . 'assets/js/admin/impeka-wpb-front-elements.js',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Video Type", "impeka-wpb-extension" ),
					"param_name" => "video_type",
					"value" => array(
						esc_html__( "YouTube/Vimeo Video", "impeka-wpb-extension" ) => 'link',
						esc_html__( "HTML5 Video", "impeka-wpb-extension" ) => 'html5',
					),
					"description" => esc_html__( 'Select your Video Type', 'impeka-wpb-extension' ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "Video Link", "impeka-wpb-extension" ),
					"param_name" => "video_link",
					"value" => "",
					"description" => esc_html__( "Type a YouTube/Vimeo URL.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'link' ) ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__( "Image", "impeka-wpb-extension" ),
					"param_name" => "video_poster",
					"value" => '',
					"description" => esc_html__( "Select a poster image.", "impeka-wpb-extension" ),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "MP4 File URL", "impeka-wpb-extension" ),
					"param_name" => "video_mp4",
					"value" => "",
					"description" => esc_html__( "Fill mp4 format URL", 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "WebM File URL ( optional )", "impeka-wpb-extension" ),
					"param_name" => "video_webm",
					"value" => "",
					"description" => esc_html__( "Fill .webm format for browser compatibility.", 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__( "OGV File URL ( optional )", "impeka-wpb-extension" ),
					"param_name" => "video_ogv",
					"value" => "",
					"description" => esc_html__( "Fill .ogg format for browser compatibility.", 'impeka-wpb-extension' ),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Show Video Controls", "impeka-wpb-extension" ),
					"param_name" => "video_controls",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Video Loop", "impeka-wpb-extension" ),
					"param_name" => "video_loop",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Video Autoplay", "impeka-wpb-extension" ),
					"param_name" => "video_autoplay",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Video Sound", "impeka-wpb-extension" ),
					"param_name" => "video_sound",
					"value" => array(
						esc_html__( "Yes", "impeka-wpb-extension" ) => 'yes',
						esc_html__( "No", "impeka-wpb-extension" ) => 'no',
					),
					"dependency" => array( 'element' => "video_type", 'value' => array( 'html5' ) ),
				),
				impeka_wpb_ext_add_margin_bottom(),
				impeka_wpb_ext_add_el_class(),
			),
		);
	}
}

if( function_exists( 'vc_lean_map' ) ) {
	vc_lean_map( 'impeka_video', 'impeka_wpb_ext_video_shortcode_params' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
