<?php
/**
 * Animated Text Template
 */

$atts = vc_map_get_attributes( 'impeka_animated_text', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-animated-text', 'grve-animated-item', 'grve-align-' . $align, 'grve-' . $heading, 'grve-' . $style );

if ( !empty( $custom_font_family ) ) {
	$element_classes[] = 'grve-' . $custom_font_family;
}
if( '100' != $increase_heading ){
	if( !empty( $increase_heading_reset ) ) {
		$element_classes = impeka_wpb_ext_increase_heading_reset( $increase_heading_reset, $element_classes );
	}
	$element_classes[] = 'grve-increase-heading';
	$element_classes[] = 'grve-heading-' . $increase_heading;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}

$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$wrapper_attributes[] = 'data-style="' . esc_attr( $style ) . '"';
$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
$animated_text_safe = vc_value_from_safe( $animated_text );

//OUTPUT

echo '<' . tag_escape( $heading_tag ) . ' ' . implode( ' ', $wrapper_attributes ) . '>';
if( preg_match_all("/(\|.*?\|)/is", $animated_text_safe, $entries) ) {
	foreach($entries[0] as $entry) {
		$text = substr($entry, 1, -1); // Remove Asteriks
		$lines = explode(';', str_replace( '&amp;', '&', $text) );
		$lines = array_map('trim', $lines); // Trim Whitespace
		$animated_text_safe = str_replace( $entry, '<placeholder>', $animated_text_safe );

		$animated_text_to_add = '';
		foreach ($lines as $line) {
			$animated_text_to_add .= '<span class="grve-animated-entry"><span class="grve-line">' . wp_kses_post( $line ) . '</span></span>';
		}
		echo str_replace('<placeholder>', $animated_text_to_add, $animated_text_safe);
	}
}
echo '</' . tag_escape( $heading_tag ) . '>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
