<?php
/**
 * Button Template
 */

$atts = vc_map_get_attributes( 'impeka_button', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-align-' . $align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( 'custom' == $btn_fluid ) {
	$element_classes[] = 'grve-fluid-button';
}
if ( 'yes' == $btn_fluid ) {
	$element_classes[] = 'grve-fullwidth-button';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( 'custom' == $btn_fluid ) {
	$css_style .= impeka_wpb_ext_build_dimension( 'max-width', $btn_custom_width );
}
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
echo impeka_wpb_ext_get_button( $atts );
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
