<?php
/**
 * Cascading Images Template
 */

$atts = vc_map_get_attributes( 'impeka_cascading_image', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-cascading-images' );
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if ( 'auto' != $image_width ) {
	$element_classes[] = 'grve-image-expand-width';
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}


$values = (array) vc_param_group_parse_atts( $image_item );

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

if( !empty( $values ) ) {
	foreach ( $values as $k => $v ) {

		$image_mode = isset( $v['image_mode'] ) ? $v['image_mode'] : '';
		$image = isset( $v['image'] ) ? $v['image'] : '';
		$retina_image = isset( $v['retina_image'] ) ? $v['retina_image'] : '';
		$radius = isset( $v['radius'] ) ? $v['radius'] : '';
		$shadow = isset( $v['shadow'] ) ? $v['shadow'] : '';
		$offset_x = isset( $v['offset_x'] ) ? $v['offset_x'] : '';
		$offset_y = isset( $v['offset_y'] ) ? $v['offset_y'] : '';
		$animation = isset( $v['animation'] ) ? $v['animation'] : '';
		$animation_delay = isset( $v['animation_delay'] ) ? $v['animation_delay'] : '';
		$animation_duration = isset( $v['animation_duration'] ) ? $v['animation_duration'] : '';

		$image_mode_size = impeka_wpb_ext_get_image_size( $image_mode );
		$image_item_atts = array(
			'image' => $image,
			'retina_image' => $retina_image,
			'image_mode_size' => $image_mode_size,
			'image_load_mode' => $image_load_mode,
			'wrapper' => 'yes',
			'column_space' => $image_width,
		);

		$image_item_wrapper_classes = array('grve-image-item');
		$image_item_wrapper_attributes = array();
		if ( !empty( $animation ) ) {
			$image_item_wrapper_classes[] = 'grve-animated-item';
			$image_item_wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
			$image_item_wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
			$image_item_wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
		}
		$image_item_wrapper_class_string = implode( ' ', $image_item_wrapper_classes );
		$image_item_wrapper_attributes[] = 'class="' . esc_attr( $image_item_wrapper_class_string ) . '"';

		$image_item_classes = array('grve-image-item-inner');
		$image_item_attributes = array();
		if ( 'none' != $radius ) {
			$image_item_classes[] = 'grve-radius-' . $radius;
		}
		if ( 'none' != $shadow ) {
			$image_item_classes[] = 'grve-shadow-' . $shadow;
		}

		$pattern = '/^(-?\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';

		$regexr = preg_match( $pattern, $offset_x, $matches );
		$value = isset( $matches[1] ) ? (float) $matches[1] : 30;
		$unit = isset( $matches[2] ) ? $matches[2] : 'px';
		$offset_x = $value . $unit;

		$regexr = preg_match( $pattern, $offset_y, $matches );
		$value = isset( $matches[1] ) ? (float) $matches[1] : 30;
		$unit = isset( $matches[2] ) ? $matches[2] : 'px';
		$offset_y = $value . $unit;

		if( '' != $offset_x && '' != $offset_y ) {
			$image_item_attributes[] = 'style="transform: translate(' . esc_attr( $offset_x ) . ',' . esc_attr( $offset_y ) . ')"';
		} else if( '' != $offset_x ) {
			$image_item_attributes[] = 'style="transform: translateX(' . esc_attr( $offset_x ) . ')"';
		} else if( '' != $offset_y ) {
			$image_item_attributes[] = 'style="transform: translateY(' . esc_attr( $offset_y ) . ')"';
		}

		$image_item_class_string = implode( ' ', $image_item_classes );
		$image_item_attributes[] = 'class="' . esc_attr( $image_item_class_string ) . '"';


		echo '<div class="grve-image-item-wrapper">';
			echo '<div ' . implode( ' ', $image_item_wrapper_attributes ) . '>';
				echo '<div ' . implode( ' ', $image_item_attributes ) . '>';
				echo impeka_wpb_ext_get_image_html( $image_item_atts );
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
}

echo '</div>';


//Omit closing PHP tag to avoid accidental whitespace output errors.
