<?php
/**
 * Countdown Template
 */

$atts = vc_map_get_attributes( 'impeka_countdown', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-countdown', 'grve-style-' . $countdown_style );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if( '100' != $increase_heading ){
	$wrapper_attributes[] = 'data-increase-heading="' . esc_attr( $increase_heading ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$wrapper_attributes[] = 'data-countdown="' . esc_attr( $final_date ) . '"';
$wrapper_attributes[] = 'data-countdown-format="' . esc_attr( $countdown_format ) . '"';
$wrapper_attributes[] = 'data-numbers-size="' . esc_attr( $numbers_size ) . '"';
$wrapper_attributes[] = 'data-text-size="' . esc_attr( $text_size ) . '"';
if( '2' == $countdown_style ) {
	$wrapper_attributes[] = 'data-bg-color="' . esc_attr( $bg_color ) . '"';
}
$wrapper_attributes[] = 'data-numbers-color="' . esc_attr( $numbers_color ) . '"';
$wrapper_attributes[] = 'data-text-color="' . esc_attr( $text_color ) . '"';

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '></div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
