<?php
/**
 * Counter Template
 */

$atts = vc_map_get_attributes( 'impeka_counter', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-counter', 'grve-align-' . $align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Counter Number
$counter_number = array( 'grve-counter-item', 'grve-' . $counter_heading, 'grve-text-' . $counter_color );
if ( !empty( $counter_custom_font_family ) ) {
	$counter_number[] = 'grve-' . $counter_custom_font_family;
}
if( '100' != $increase_counter_heading ){
	$counter_number[] = 'grve-increase-heading';
	$counter_number[] = 'grve-heading-' . $increase_counter_heading;
}
$counter_number_class_string = implode( ' ', $counter_number );

//Title
$title_classes = array( 'grve-counter-title', 'grve-' . $heading );
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if( 'inherit' != $title_color ){
	$title_classes[] = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );

//Icon
$icon_class_string = '';
if ( 'icon' == $icon_type ) {
	$icon_class = isset( ${"icon_" . $icon_library} ) ? esc_attr( ${"icon_" . $icon_library} ) : 'fas fa-adjust';
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
		vc_icon_element_fonts_enqueue( $icon_library );
	}
	$icon_classes = array( $icon_class, 'grve-text-' . $icon_color , 'grve-' . $icon_size );
	$icon_class_string = implode( ' ', $icon_classes );
}

if( 'yes' == $counter_prefix_space && !empty( $counter_prefix )  ) {
	$counter_prefix = $counter_prefix . ' ';
}

if( 'yes' == $counter_suffix_space && !empty( $counter_suffix ) ) {
	$counter_suffix = ' ' . $counter_suffix;
}

$counter_attributes = array();
$counter_attributes[] = 'data-thousands-separator-vis="' . esc_attr( $counter_thousands_separator_vis ) . '"';
$counter_attributes[] = 'data-thousands-separator="' . esc_attr( $counter_thousands_separator ) . '"';
$counter_attributes[] = 'data-prefix="' . esc_attr( $counter_prefix ) . '"';
$counter_attributes[] = 'data-suffix="' . esc_attr( $counter_suffix ) . '"';
$counter_attributes[] = 'data-start-val="' . esc_attr( $counter_start_val ) . '"';
$counter_attributes[] = 'data-end-val="' . esc_attr( $counter_end_val ) . '"';
$counter_attributes[] = 'data-decimal-points="' . esc_attr( $counter_decimal_points ) . '"';
$counter_attributes[] = 'data-decimal-separator="' . esc_attr( $counter_decimal_separator ) . '"';
$counter_attributes[] = '';

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

if ( 'icon' == $icon_type ) {
	echo ' <div class="grve-counter-icon">';
	echo ' <span class="grve-icon ' . esc_attr( $icon_class_string ) . '"></span>';
	echo ' </div>';


} else if( 'svg' == $icon_type ) {
	if ( !empty( $icon_svg ) ) {
		$img_id = preg_replace('/[^\d]/', '', $icon_svg);
		$img_src = wp_get_attachment_image_src( $img_id, 'full' );
		if ( $img_src ) {
			$img_url = $img_src[0];
			$parts = pathinfo( $img_url );
			if ( isset( $parts['extension'] ) && 'svg' == $parts['extension'] ) {
				echo '<div class="grve-counter-icon grve-' . esc_attr( $icon_size ) . '">';
				echo '<div id="' . uniqid('grve-svg-') . '" data-file="' . esc_url( $img_url ) . '" class="grve-custom-svg-icon grve-text-' . esc_attr( $icon_color ) . '"></div>';
				echo '</div>';
			}
		}
	}
} else if( 'animated-svg' == $icon_type ) {
	if ( !empty( $icon_svg ) ) {
		$img_id = preg_replace('/[^\d]/', '', $icon_svg);
		$img_src = wp_get_attachment_image_src( $img_id, 'full' );
		if ( $img_src ) {
			echo '<div class="grve-counter-icon grve-' . esc_attr( $icon_size ) . '">';
			echo '<div id="' . uniqid('grve-svg-') . '" data-file="' . esc_url( $img_src[0] ) . '" data-duration="' . esc_attr( $animated_svg_animation_duration ) . '" class="grve-animated-svg-icon grve-text-' . esc_attr( $icon_color ) . '"></div>';
			echo '</div>';
		}
	}
}

echo '<div class="grve-counter-content">';
echo '<div class="' . esc_attr( $counter_number_class_string ) . '">';
echo '<span ' . implode( ' ', $counter_attributes ) . '>' . esc_html( $counter_start_val ) . '</span>';
echo '</div>';
echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
echo '</div>';

echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
