<?php
/**
 * Dropcap Template
 */

$atts = vc_map_get_attributes( 'impeka_dropcap', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-dropcap' );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if ( 'inherit' != $text_color ) {
	$element_classes[] = 'grve-text-' . $text_color;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

if ( !empty( $content ) ) {

	$dropcap_char = mb_substr( $content, 0, 1, 'UTF8' );
	$dropcap_content = mb_substr( $content, 1, mb_strlen( $content ) , 'UTF8' );
	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	if ( '1' == $dropcap_style ) {
	echo '<p><span class="grve-style-' . esc_attr( $dropcap_style ) . ' grve-text-' . esc_attr( $color ) . '">' . esc_html( $dropcap_char ) . '</span>' . wp_kses_post( $dropcap_content ) . '</p>';
	} else {
	echo '<p><span class="grve-style-' . esc_attr( $dropcap_style ) . ' grve-bg-' . esc_attr( $color ) . '">' . esc_html( $dropcap_char ) . '</span>' . wp_kses_post( $dropcap_content ) . '</p>';
	}
	echo '</div>';

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
