<?php
/**
 * Empty Space Template
 */

$atts = vc_map_get_attributes( 'impeka_empty_space', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-empty-space' );
if ( 'custom' == $height_multiplier ) {
	$pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
	$regexr = preg_match( $pattern, $height, $matches );
	$value = isset( $matches[1] ) ? (float) $matches[1] : 30;
	$unit = isset( $matches[2] ) ? $matches[2] : 'px';
	$height = $value . $unit;
	$css_style = 'height: ' . esc_attr( $height ) . ';';
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
} else {
	$element_classes[] = 'grve-height-' . $height_multiplier;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '></div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
