<?php
/**
 * Flexible Carousel Template
 */

$atts = vc_map_get_attributes( 'impeka_flexible_carousel', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel', 'grve-flexible-carousel' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-autoheight="' . esc_attr( $auto_height ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
$carousel_attributes[] = 'data-stage-padding="0"';

if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}


$carousel_classes = array( 'grve-carousel-element' );

if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flexible-advanced-carousel';
	$carousel_classes[] = 'flickity';
}

$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';


//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
		<?php
			if ( !empty( $content ) ) {
				echo do_shortcode( $content );
			}
		?>
		</div>
	</div>
</div>
