<?php
/**
 * Map Template
 */

$atts = vc_map_get_attributes( 'impeka_gmap', $atts );
extract( $atts );

wp_enqueue_script( 'impeka-google-maps');
wp_enqueue_script( 'impeka-openstreetmap-maps');

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-map' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
$css_style .= impeka_wpb_ext_build_dimension( 'height', $map_height );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$values = (array) vc_param_group_parse_atts( $map_points );
if ( !empty( $map_mode ) && !empty( $values )  ) {
	$map_lat = impeka_wpb_ext_array_value( $values[0], 'lat', '51.516221' );
	$map_lng = impeka_wpb_ext_array_value( $values[0], 'lng', '-0.136986' );
}

$wrapper_attributes[] = 'data-lat="' . esc_attr( $map_lat ) . '"';
$wrapper_attributes[] = 'data-lng="' . esc_attr( $map_lng ) . '"';
$wrapper_attributes[] = 'data-zoom="' . esc_attr( $map_zoom ) . '"';
$wrapper_attributes[] = 'data-disable-style="' . esc_attr( $map_disable_style ) . '"';


//Marker
if ( empty( $map_marker_type ) ) {
	if ( empty( $map_marker ) ) {
		$map_marker = get_template_directory_uri() . '/images/markers/markers.png';
	} else {
		$id = preg_replace('/[^\d]/', '', $map_marker);
		$full_src = wp_get_attachment_image_src( $id, 'full' );
		$map_marker = $full_src[0];
	}
	$point_type = $map_marker_type = 'image';
	$point_bg_color = '';
} else {
	$map_marker = get_template_directory_uri() . '/images/markers/transparent.png';
	$point_type = $map_marker_type;
	$point_bg_color = $map_marker_bg_color;
}
$map_marker = str_replace( array( 'http:', 'https:' ), '', $map_marker );

$map_title = '';

//OUTPUT

echo '<div class="grve-map-wrapper">';
echo '<div ' . implode( ' ', $wrapper_attributes ) . '>' . apply_filters( 'impeka_grve_privacy_gmap_fallback', '', $map_lat, $map_lng ) . '</div>';

if ( empty( $map_mode ) ) {

	$map_point_attributes = array();
	$map_point_attributes[] = 'data-point-lat="' . esc_attr( $map_lat ) . '"';
	$map_point_attributes[] = 'data-point-lng="' . esc_attr( $map_lng ) . '"';
	$map_point_attributes[] = 'data-point-title="' . esc_attr( $map_title ) . '"';
	$map_point_attributes[] = 'data-point-type="' . esc_attr( $point_type ) . '"';
	if( 'image' != $point_type ) {
		$map_point_attributes[] = 'data-point-bg-color="' . esc_attr( $point_bg_color ) . '"';
	}
	echo '<div style="display:none" class="grve-map-point" data-point-marker="' . esc_attr( $map_marker ) . '" ' . implode( ' ', $map_point_attributes ) . '></div>';
} else {
	if( !empty( $values ) ) {
		foreach ( $values as $k => $v ) {

			$point_lat = isset( $v['lat'] ) ? $v['lat'] : '51.516221';
			$point_lng = isset( $v['lng'] ) ? $v['lng'] : '-0.136986';
			$point_marker = isset( $v['marker'] ) ? $v['marker'] : '';
			$point_title = isset( $v['title'] ) ? $v['title'] : '';
			$point_infotext = isset( $v['infotext'] ) ? $v['infotext'] : '';
			$point_infotext_open = isset( $v['infotext_open'] ) ? $v['infotext_open'] : 'no';
			$point_link_text = isset( $v['link_text'] ) ? $v['link_text'] : '';
			$point_link = isset( $v['link'] ) ? $v['link'] : '';
			$point_link_class = isset( $v['link_class'] ) ? 'grve-infotext-link ' . $v['link_class'] : 'grve-infotext-link';

			if ( empty( $point_marker ) ) {
				$point_marker = $map_marker;
				$point_type = $map_marker_type;
				$point_bg_color = $map_marker_bg_color;
			} else {
				$id = preg_replace('/[^\d]/', '', $point_marker);
				$full_src = wp_get_attachment_image_src( $id, 'full' );
				$point_marker = $full_src[0];
				$point_marker = str_replace( array( 'http:', 'https:' ), '', $point_marker );
				$point_type = 'image';
				$point_bg_color = '';
			}

			$map_point_attributes = array();
			$map_point_attributes[] = 'data-point-lat="' . esc_attr( $point_lat ) . '"';
			$map_point_attributes[] = 'data-point-lng="' . esc_attr( $point_lng ) . '"';
			$map_point_attributes[] = 'data-point-title="' . esc_attr( $point_title ) . '"';
			$map_point_attributes[] = 'data-point-type="' . esc_attr( $point_type ) . '"';
			$map_point_attributes[] = 'data-point-open="' . esc_attr( $point_infotext_open ) . '"';
			if( 'image' != $point_type ) {
				$map_point_attributes[] = 'data-point-bg-color="' . esc_attr( $point_bg_color ) . '"';
			}

			echo '<div style="display:none" class="grve-map-point" data-point-marker="' . esc_attr( $point_marker ) . '" ' . implode( ' ', $map_point_attributes ) . '>';
			if ( !empty( $point_title ) || !empty( $point_infotext ) || !empty( $point_link_text ) ) {
				echo '<div class="grve-map-infotext">';
				if ( !empty( $point_title ) ) {
					echo '<h6 class="grve-infotext-title">' . esc_html( $point_title ) . '</h6>';
				}
				if ( !empty( $point_infotext ) ) {
					echo '<p class="grve-infotext-description">' . wp_kses_post( $point_infotext ) . '</p>';
				}
				if ( !empty( $point_link_text ) && impeka_wpb_ext_has_link ( $point_link ) ) {
					$link_attributes = impeka_wpb_ext_get_link_attributes( $point_link, $point_link_class );
					echo '<a ' . implode( ' ', $link_attributes ) . '>';
					echo esc_html( $point_link_text );
					echo '</a>';
				}
				echo '</div>';
			}
			echo '</div>';
		}
	}
}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
