<?php
/**
 * Icon Template
 */

$atts = vc_map_get_attributes( 'impeka_icon', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-single-icon', 'grve-align-' . $align, 'grve-' . $icon_size );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}

if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Icon Wrapper
$icon_wrapper_attributes = array();
$icon_wrapper_classes = array( 'grve-wrapper-icon' );
if ( !empty( $icon_shape ) ) {
	$icon_wrapper_classes[] = 'grve-' . $icon_shape;
	$icon_wrapper_classes[] = 'grve-' . $shape_type;
	$icon_wrapper_classes[] = 'grve-with-shape';
	if ( 'outline' != $shape_type ) {
		$icon_wrapper_classes[] = 'grve-bg-' . $icon_shape_color;
	} else {
		$icon_wrapper_classes[] = 'grve-border-' . $icon_shape_color;
	}
	if ( !empty( $loop_animation ) ) {
		$icon_wrapper_classes[] = 'grve-loop-' . $loop_animation;
	}
}
$icon_wrapper_classes[] = 'grve-text-' . $icon_color;
$icon_wrapper_class_string = implode( ' ', $icon_wrapper_classes );
$icon_wrapper_attributes[] = 'class="' . esc_attr( $icon_wrapper_class_string ) . '"';

//Icon Wrapper Style
$icon_wrapper_style = '';
if( 'custom' == $icon_color ) {
	$icon_wrapper_style .= ' color: ' . esc_attr( $icon_color_custom ) . ';';
}
if( 'custom' == $icon_shape_color ) {
	if ( 'outline' != $shape_type ) {
		$icon_wrapper_style .= ' background-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
	} else {
		$icon_wrapper_style .= ' border-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
	}
}
if ( !empty( $icon_wrapper_style ) ) {
	$icon_wrapper_attributes[] = 'style="' . esc_attr( $icon_wrapper_style ) . '"';
}

//Icon
$icon_class = '';
if ( 'icon' == $icon_type ) {
	$icon_class = isset( ${"icon_" . $icon_library} ) ? esc_attr( ${"icon_" . $icon_library} ) : 'fas fa-adjust';
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
		vc_icon_element_fonts_enqueue( $icon_library );
	}
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<div ' . implode( ' ', $icon_wrapper_attributes ) . '>';

if ( impeka_wpb_ext_has_link( $link ) ) {
	$link_attributes = impeka_wpb_ext_get_link_attributes( $link, $link_class );
	echo '<a ' . implode( ' ', $link_attributes ) . '>';
}

if( 'svg' == $icon_type ) {
	if ( !empty( $icon_svg ) ) {
		$img_id = preg_replace('/[^\d]/', '', $icon_svg);
		$img_src = wp_get_attachment_image_src( $img_id, 'full' );
		if ( $img_src ) {
			$img_url = $img_src[0];
			$parts = pathinfo( $img_url );
			if ( isset( $parts['extension'] ) && 'svg' == $parts['extension'] ) {
				echo '<div id="' . uniqid('grve-svg-') . '" data-file="' . esc_url( $img_url ) . '" class="grve-custom-svg-icon grve-text-' . esc_attr( $icon_color ) . '"></div>';
			}
		}
	}
} else if( 'animated-svg' == $icon_type ) {
	if ( !empty( $icon_svg ) ) {
		$img_id = preg_replace('/[^\d]/', '', $icon_svg);
		$img_src = wp_get_attachment_image_src( $img_id, 'full' );
		if ( $img_src ) {
			echo '<div id="' . uniqid('grve-svg-') . '" data-file="' . esc_url( $img_src[0] ) . '" data-duration="' . esc_attr( $animated_svg_animation_duration ) . '" class="grve-animated-svg-icon grve-text-' . esc_attr( $icon_color ) . '"></div>';
		}
	}
} else if( 'theme-icon-svg' == $icon_type ) {
	echo impeka_wpb_ext_get_svg_icon( $theme_icon );
} else {
	echo '<span class="grve-icon '. esc_attr( $icon_class ) . '"></span>';
}

if ( impeka_wpb_ext_has_link( $link ) ) {
echo '</a>';
}
if ( 'animation-1' == $loop_animation ) {
	echo '<div class="grve-pulse-bg"></div>';
}
echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
