<?php
/**
 * Image Carousel Template
 */

$atts = vc_map_get_attributes( 'impeka_image_carousel', $atts );
extract( $atts );

$attachments = explode( ",", $ids );

if ( empty( $attachments ) ) {
	return '';
}

//Custom Links
if ( 'custom_link' == $link_type ) {
	$custom_links_data = array();
	$custom_links = vc_value_from_safe( $custom_links );
	if( !empty( $custom_links ) ) {
		$custom_links_lines = explode( ',', $custom_links );
		foreach ($custom_links_lines as $line) {
			$new_line = array();
			$data = explode("|", $line);
			$index = isset( $data[0] ) && !empty( $data[0] ) ? $data[0] : 1;
			$url = isset( $data[1] ) && !empty( $data[1] ) ? $data[1] : '#';
			$custom_links_data[$index] = $url;
		}
	}
} elseif ( 'multi_popup' == $link_type ) {
	$multi_popup_data = array();
	$multi_popup_links = vc_value_from_safe( $multi_popup_links );
	if( !empty( $multi_popup_links ) ) {
		$multi_popup_lines = explode( ',', $multi_popup_links );
		foreach ($multi_popup_lines as $line) {
			$new_line = array();
			$data = explode("|", $line);
			$index = isset( $data[0] ) && !empty( $data[0] ) ? $data[0] : 1;
			$url = isset( $data[1] ) && !empty( $data[1] ) ? $data[1] : '#';
			$multi_popup_data[$index] = $url;
		}
	}
}

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel', 'grve-image-carousel' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
$carousel_attributes[] = 'data-slider-autoheight="no"';
$carousel_attributes[] = 'data-stage-padding="0"';

if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}

$carousel_classes = array( 'grve-carousel-element' );
if ( 'popup' == $link_type || 'multi_popup' == $link_type ) {
	$carousel_classes[] = 'grve-gallery-popup';
}
if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';


//Image Size
$image_size = impeka_wpb_ext_get_image_size( $image_mode );

//Image Popup Size
$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );

$overlay_opacity = ( '0' == $overlay_opacity ) ? 'none' : $overlay_opacity;

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
<?php

$gallery_index = 0;
$i = -1;
$image_size_class = '';
$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );

foreach ( $attachments as $id ) {

	$gallery_index++;
	$i++;

	$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );

	//Title and Caption
	$caption = $title = '';
	if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
		$title = get_post_field( 'post_title', $id );
	}
	if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
		$caption = get_post_field( 'post_excerpt', $id );
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	if ( 'popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $full_src[0] ) . '"';
		if ( !empty( $data_html ) ) {
			$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
		}
	} elseif ( 'custom_link' == $link_type ) {
		if( !empty( $custom_links_data ) && isset( $custom_links_data[ $gallery_index ] ) && !empty(  $custom_links_data[ $gallery_index ] ) ) {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $custom_links_data[ $gallery_index ]  ) . '"';
			if ( '_blank' == $custom_links_target ) {
				$link_atts[] = 'target="' . esc_attr( $custom_links_target ) . '"';
				$link_atts[] = 'rel="noopener noreferrer"';
			}
		}
	} elseif ( 'multi_popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		if( !empty( $multi_popup_data ) && isset( $multi_popup_data[ $gallery_index ] ) && !empty(  $multi_popup_data[ $gallery_index ] ) ) {
			$link_atts[] = 'href="' . esc_url( $multi_popup_data[ $gallery_index ]  ) . '"';
		} else {
			$link_atts[] = 'href="' . esc_url( $full_src[0] ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		}
	}

	$hover_params = array(
		'element' => 'image-carousel',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
	);
?>

			<div class="grve-entry-item grve-carousel-item">
				<div class="grve-image-item">
					<?php get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params ); ?>
				</div>
			</div>
<?php	}
?>
		</div>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
