<?php
/**
 * Image Gallery Template
 */

$atts = vc_map_get_attributes( 'impeka_gallery_advanced', $atts );
extract( $atts );

$attachments = '';
if( 'default' == $images_mode ) {
	if ( !empty( $ids ) ) {
		$attachments = explode( ",", $ids );
	}
} else {
	$attachments = (array) vc_param_group_parse_atts( $single_image_ids );
}
if ( empty( $attachments ) ) {
	return '';
}

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => 'none',
	'animation' => $animation,
);
$wrapper_attributes = impeka_wpb_ext_get_grid_layout_atts( $wrapper_params );
$element_classes = array( 'grve-element', 'grve-gallery' , 'grve-isotope' );
if ( 'default' == $images_mode ) {
	$element_classes[] = 'grve-gallery-popup';
} else {
	$element_classes[] = 'grve-multi-popup';
}
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$element_classes[] = 'grve-with-gap';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

if ( 'masonry' == $mode ) {
	$image_size = impeka_wpb_ext_get_image_size( $masonry_image_mode );
} else {
	$image_size = impeka_wpb_ext_get_image_size( $grid_image_mode );
}

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
//Filter
if ( 'single' == $images_mode && 'yes' == $filter ) {

	$filter_values = array();
	foreach ( $attachments as $image_item ) {
		$filter_categories = impeka_wpb_ext_array_value( $image_item, 'img_filter_categories' );
		if ( !empty(  $filter_categories  ) ) {
			$filter_values[] = $filter_categories;
		}
	}
	$filter_atts = array(
		'category_prefix_class' => 'gallery-category',
		'filter_values' => $filter_values,
		'filter_all_text' => $filter_all_text,
		'filter_style' => $filter_style,
		'filter_shape' => $filter_shape,
		'filter_color' => $filter_color,
		'filter_align' => $filter_align,
		'filter_order_by' => $filter_order_by,
		'filter_order' => $filter_order,
		'filter_gototop' => $filter_gototop,
	);
	impeka_wpb_ext_print_image_filters( $filter_atts );
}
?>
	<div class="grve-isotope-container">
		<div class="grve-grid-sizer"></div>
<?php

$gallery_index = 0;
$i = -1;

$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );


$video_icon_color = '';
foreach ( $attachments as $image_item ) {

	$item_extra_class = '';
	$gallery_index++;
	$i++;

	if( 'default' == $images_mode ) {
		$id = $image_item;
	} else {
		$image = impeka_wpb_ext_array_value( $image_item, 'img' );
		$id = preg_replace('/[^\d]/', '', $image);

		$img_full_url = impeka_wpb_ext_array_value( $image, 'url' );

		$link_type = impeka_wpb_ext_array_value( $image_item, 'img_link_type' );
		$image_popup_size = impeka_wpb_ext_array_value( $image_item, 'img_popup_size' );
		$link = impeka_wpb_ext_array_value( $image_item, 'img_link' );
		$video_link = impeka_wpb_ext_array_value( $image_item, 'img_video_link' );
		$video_icon_color = impeka_wpb_ext_array_value( $image_item, 'video_icon_color', 'none' );
		$filter_categories = impeka_wpb_ext_array_value( $image_item, 'img_filter_categories' );

		$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );

		if ( 'yes' == $filter && !empty(  $filter_categories  )  ) {
			$image_categories = explode( '|', $filter_categories );
			foreach( $image_categories as $image_category ){
					$item_extra_class .= " gallery-category-" .sanitize_title_with_dashes( $image_category );
			}
		}
	}

	if ( 'masonry' == $mode && empty( $masonry_image_mode ) ) {
		$impeka_wpb_ext_masonry_data = impeka_wpb_ext_get_masonry_data( $gallery_index, $columns );
		$item_extra_class .= ' ' . $impeka_wpb_ext_masonry_data['class'];
		$image_size = $impeka_wpb_ext_masonry_data['image_size'];
	}

	//Title and Caption
	$caption = $title = '';

	if( !empty( $id ) ) {
		$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
		if ( $full_src ) {
			$img_full_url = $full_src[0];
		}

		if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
			$title = get_post_field( 'post_title', $id );
		}
		if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
			$caption = get_post_field( 'post_excerpt', $id );
		}
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	if( 'default' == $images_mode ) {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		}
	} else {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		} elseif ( 'custom-link' == $link_type ) {
			$link_atts = impeka_wpb_ext_get_link_attributes( $link );
			$link_atts[] = 'class="grve-item-url"';
		} elseif ( 'video-popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			if( !empty( $video_link ) ) {
				$link_atts[] = 'href="' . esc_url( $video_link  ) . '"';
				$item_extra_class .= ' grve-video-popup-item';
			}
		}
	}

	$hover_params = array(
		'element' => 'image-gallery',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'title_bg_color' => $title_bg_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'text_bg_color' => $text_bg_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
		'indicator' => $indicator,
		'indicator_text' => $indicator_text,
		'indicator_color' => $indicator_color,
		'link_type' => $link_type,
		'video_icon_color' => $video_icon_color,
	);
?>
		<div class="grve-entry-item grve-popup-item <?php echo esc_attr( $item_extra_class ); ?>">
			<div class="grve-isotope-item-inner">
				<?php get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params ); ?>
			</div>
		</div>
<?php
}
?>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
