<?php
/**
 * Image Gallery Template
 */

$atts = vc_map_get_attributes( 'impeka_gallery', $atts );
extract( $atts );

$attachments = explode( ",", $ids );

if ( empty( $ids ) || empty( $attachments ) ) {
	return '';
}

if ( 'custom_link' == $link_type ) {
	$custom_links_data = array();
	$custom_links = vc_value_from_safe( $custom_links );
	if( !empty( $custom_links ) ) {
		$custom_links_lines = explode( ',', $custom_links );
		foreach ($custom_links_lines as $line) {
			$new_line = array();
			$data = explode("|", $line);
			$index = isset( $data[0] ) && !empty( $data[0] ) ? $data[0] : 1;
			$url = isset( $data[1] ) && !empty( $data[1] ) ? $data[1] : '#';
			$custom_links_data[$index] = $url;
		}
	}
} elseif ( 'multi_popup' == $link_type ) {
	$multi_popup_data = array();
	$multi_popup_links = vc_value_from_safe( $multi_popup_links );
	if( !empty( $multi_popup_links ) ) {
		$multi_popup_lines = explode( ',', $multi_popup_links );
		foreach ($multi_popup_lines as $line) {
			$new_line = array();
			$data = explode("|", $line);
			$index = isset( $data[0] ) && !empty( $data[0] ) ? $data[0] : 1;
			$url = isset( $data[1] ) && !empty( $data[1] ) ? $data[1] : '#';
			$multi_popup_data[$index] = $url;
		}
	}
}

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => 'none',
	'animation' => $animation,
);
$wrapper_attributes = impeka_wpb_ext_get_grid_layout_atts( $wrapper_params );
$element_classes = array( 'grve-element', 'grve-gallery' , 'grve-isotope' );
if ( 'popup' == $link_type || 'multi_popup' == $link_type ) {
	$element_classes[] = 'grve-gallery-popup';
}
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$element_classes[] = 'grve-with-gap';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

if ( 'masonry' == $mode ) {
	$image_size = impeka_wpb_ext_get_image_size( $masonry_image_mode );
} else {
	$image_size = impeka_wpb_ext_get_image_size( $grid_image_mode );
}

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php

$filter_values = vc_value_from_safe( $filter_values );
$filter_values = explode( ',', $filter_values );


//Filter
if ( 'yes' == $filter ) {

	$filter_atts = array(
		'category_prefix_class' => 'gallery-category',
		'filter_values' => $filter_values,
		'filter_all_text' => $filter_all_text,
		'filter_style' => $filter_style,
		'filter_shape' => $filter_shape,
		'filter_color' => $filter_color,
		'filter_align' => $filter_align,
		'filter_order_by' => $filter_order_by,
		'filter_order' => $filter_order,
		'filter_gototop' => $filter_gototop,
	);
	impeka_wpb_ext_print_image_filters( $filter_atts );
}
?>
	<div class="grve-isotope-container">
		<div class="grve-grid-sizer"></div>
<?php

$gallery_index = 0;
$i = -1;

$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );

foreach ( $attachments as $id ) {

	$item_extra_class = '';
	$gallery_index++;
	$i++;

	if ( 'masonry' == $mode && empty( $masonry_image_mode ) ) {
		$impeka_wpb_ext_masonry_data = impeka_wpb_ext_get_masonry_data( $gallery_index, $columns );
		$item_extra_class .= ' ' . $impeka_wpb_ext_masonry_data['class'];
		$image_size = $impeka_wpb_ext_masonry_data['image_size'];
	}

	$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );

	if ( 'yes' == $filter && isset( $filter_values[ $i ] ) && !empty(  $filter_values[ $i ] )  ) {
		$image_categories = explode( '|', $filter_values[ $i ] );
		foreach( $image_categories as $image_category ){
				$item_extra_class .= " gallery-category-" .sanitize_title_with_dashes( $image_category );
		}
	}

	//Title and Caption
	$caption = $title = '';
	if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
		$title = get_post_field( 'post_title', $id );
	}
	if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
		$caption = get_post_field( 'post_excerpt', $id );
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	$item_link_type = '';
	//Link Attributes
	$link_atts = array();
	if ( 'popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $full_src[0] ) . '"';
		if ( !empty( $data_html ) ) {
			$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
		}
	} elseif ( 'custom_link' == $link_type ) {
		if( !empty( $custom_links_data ) && isset( $custom_links_data[ $gallery_index ] ) && !empty(  $custom_links_data[ $gallery_index ] ) ) {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $custom_links_data[ $gallery_index ]  ) . '"';
			if ( '_blank' == $custom_links_target ) {
				$link_atts[] = 'target="' . esc_attr( $custom_links_target ) . '"';
				$link_atts[] = 'rel="noopener noreferrer"';
			}
		}
	} elseif ( 'multi_popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		if( !empty( $multi_popup_data ) && isset( $multi_popup_data[ $gallery_index ] ) && !empty(  $multi_popup_data[ $gallery_index ] ) ) {
			$link_atts[] = 'href="' . esc_url( $multi_popup_data[ $gallery_index ]  ) . '"';
			$item_extra_class .= ' grve-video-popup-item';
			$item_link_type = 'video-popup';
		} else {
			$link_atts[] = 'href="' . esc_url( $full_src[0] ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		}
	}

	$hover_params = array(
		'element' => 'image-gallery',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'title_bg_color' => $title_bg_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'text_bg_color' => $text_bg_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
		'indicator' => $indicator,
		'indicator_text' => $indicator_text,
		'indicator_color' => $indicator_color,
		'link_type' => $item_link_type,
		'video_icon_color' => $video_icon_color,
	);
?>
		<div class="grve-entry-item grve-popup-item <?php echo esc_attr( $item_extra_class ); ?>">
			<div class="grve-isotope-item-inner">
				<?php get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params ); ?>
			</div>
		</div>
<?php

}
?>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
