<?php
/**
 * Slider Template
 */

$atts = vc_map_get_attributes( 'impeka_slider', $atts );
extract( $atts );

$attachments = explode( ",", $ids );

if ( empty( $attachments ) ) {
	return '';
}

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-slider', 'grve-layout-1' );
if ( 'auto' == $image_width && 'none' == $title_caption ) {
	$element_classes[] = 'grve-image-auto-width';
}
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Carousel Wrapper
$slider_attributes = array();
$slider_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$slider_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
$slider_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
$slider_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
$slider_attributes[] = 'data-slider-transition="' . esc_attr( $transition ) . '"';
$slider_attributes[] = 'data-slider-autoheight="' . esc_attr( $auto_height ) . '"';
$slider_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$slider_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';

$slider_classes = array( 'grve-slider-element' );
if ( 'popup' == $link_type ) {
	$slider_classes[] = 'grve-gallery-popup';
}
$slider_class_string = implode( ' ', $slider_classes );
$slider_attributes[] = 'class="' . esc_attr( $slider_class_string ) . '"';

if ( 'custom_link' == $link_type ) {
	$custom_links = vc_value_from_safe( $custom_links );
	$custom_links = explode( ',', $custom_links );
}
//Image Size
if( 'autocrop' == $image_mode ) {
	$image_size = 'impeka-grve-large-rect-horizontal';
} else {
	$image_size = impeka_wpb_ext_get_image_size( $image_mode );
}

//Image Popup Size
$image_popup_size_mode = impeka_wpb_ext_get_image_size( $image_popup_size );

//Image Atts
$image_atts = array( 'data-lazyload' => $image_load_mode, 'data-column-space' => '100' );
if ( 'auto' == $image_width && 'none' == $title_caption ) {
	$image_atts = array( 'data-lazyload' => $image_load_mode );
}

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $slider_attributes ); ?>>
<?php

$i = -1;
foreach ( $attachments as $id ) {
	$i++;
	$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
	//Title and Caption
	$caption = $title = '';
	if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
		$title = get_post_field( 'post_title', $id );
	}
	if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
		$caption = get_post_field( 'post_excerpt', $id );
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	if ( 'popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $full_src[0] ) . '"';
		if ( !empty( $data_html ) ) {
			$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
		}
	} elseif ( 'custom_link' == $link_type && isset( $custom_links[ $i ] ) && !empty(  $custom_links[ $i ] )  ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $custom_links[ $i ]  ) . '"';
		$link_atts[] = 'target="' . esc_attr( $custom_links_target ) . '"';
	}

	$hover_params = array(
		'element' => 'image-slider',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => $image_atts,
	);
?>
			<div class="grve-slider-item">
				<?php
				 if ( 'none' == $title_caption )  {
					 get_template_part( 'templates/image/image-default', '', $hover_params );
				 } else {
					 get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params );
				 }
				?>
			</div>
<?php
}
?>
		</div>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.