<?php
/**
 * Media Box Template
 */

$atts = vc_map_get_attributes( 'impeka_media_box', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-media-box', 'grve-align-' . $align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( 'image' == $media_type || 'image-video-popup' == $media_type ) {
	$element_classes[] = 'grve-' . $media_style;
} else {
	$element_classes[] = 'grve-style-1';
}
if ( 'style-2' == $media_style && ('image' == $media_type || 'image-video-popup' == $media_type) ) {
	if ( !empty( $shadow ) ) {
		$element_classes[] = 'grve-' . $shadow;
	}
	if ( 'square' != $image_shape ) {
		$element_classes[] = 'grve-' . $image_shape;
	}
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( 'style-2' == $media_style && ('image' == $media_type || 'image-video-popup' == $media_type) ) {
	$pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
	$regexr = preg_match( $pattern, $min_height, $matches );
	$value = isset( $matches[1] ) ? (float) $matches[1] : 30;
	$unit = isset( $matches[2] ) ? $matches[2] : 'px';
	$min_height = $value . $unit;
	$css_style .= 'min-height: ' . esc_attr( $min_height ) . ';';
}
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}


$has_link = impeka_wpb_ext_has_link( $title_link );

//Media Classes
$media_classes = array('grve-media');
if ( !empty( $shadow ) ) {
	$media_classes[] = 'grve-' . $shadow;
}
if ( 'square' != $image_shape ) {
	$media_classes[] = 'grve-' . $image_shape;
}
$media_class_string = implode( ' ', $media_classes );

// Text Color
$text_color = 'white';
if ( 'white' == $overlay_color || 'grey' == $overlay_color || 'light-grey' == $overlay_color ) {
	$text_color = 'black';
}

// Content Wrapper Classes
$content_wrapper_classes = array( 'grve-content-wrapper' );
if ( empty( $text_colors ) ) {
	$content_wrapper_classes[]  = 'grve-fixed-colors';
	$content_wrapper_classes[]  = 'grve-headings-' . $text_color;
	$content_wrapper_classes[]  = 'grve-text-' . $text_color;
	$content_wrapper_classes[]  = 'grve-link-' . $text_color;
	$content_wrapper_classes[]  = 'grve-link-hover-' . $text_color;
}
if ( !empty( $read_more_title ) && $has_link && 'style-2' == $media_style ) {
	$content_wrapper_classes[]  = 'grve-with-readmore';
}
$content_wrapper_class_string = implode( ' ', $content_wrapper_classes );

// Content
$content_output = '';

$content_output .= '<div class="grve-box-content">';
$content_output .= '<div class="grve-content-inner">';
if ( 'image-video-popup' == $media_type && 'style-2' == $media_style ) {
	$content_output .= '<a class="grve-video-popup" href="' . esc_url( $video_link ) . '">';
	$content_output .= impeka_wpb_ext_get_video_icon( $video_icon_color );
	$content_output .= '</a>';
}
if ( !empty( $title ) ) {
	$title_classes = array( 'grve-box-title' );
	$title_classes[]  = 'grve-' . $heading;
	if ( !empty( $custom_font_family ) ) {
		$title_classes[]  = 'grve-' . $custom_font_family;
	}
	$title_class_string = implode( ' ', $title_classes );

	if ( $has_link ) {
		$link_attributes = impeka_wpb_ext_get_link_attributes( $title_link, $link_class );
		$content_output .= '<a ' . implode( ' ', $link_attributes ) . '>';
	}
	$content_output .= '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . wp_kses_post( $title ) . '</' . tag_escape( $heading_tag ) . '>';
	if ( $has_link ) {
		$content_output .= '</a>';
	}
}
if( !empty( $text_style ) ) {
	$content_output .= '    <p class="grve-' . esc_attr( $text_style ) . '">' . do_shortcode( $content ) . '</p>';
} else {
	$content_output .= '    <p>' . do_shortcode( $content ) . '</p>';
}

$content_output .= '</div>';
if ( !empty( $read_more_title ) && $has_link ) {
	$link_class_string = 'grve-link-text grve-media-read-more';
	if( !empty( $link_class ) )  {
		$link_class_string .= ' ' . $link_class;
	}
	$link_attributes = impeka_wpb_ext_get_link_attributes( $title_link, $link_class_string );
	$content_output .= '<a ' . implode( ' ', $link_attributes ) . '><span>';
	$content_output .=  $read_more_title ;
	$content_output .= '</span></a>';
}
$content_output .= '  </div>';


//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

switch( $media_type ) {
	case 'image':
	case 'image-video-popup':

		$image_mode_size = impeka_wpb_ext_get_image_size( $image_mode );
		$image_item_atts = array(
			'image' => $image,
			'retina_image' => $retina_image,
			'image_mode_size' => $image_mode_size,
			'fallback_image_mode_size' => 'medium',
			'image_load_mode' => $image_load_mode,
			'column_space' => '100',
			'wrapper' => 'yes',
		);

		if ( 'image-video-popup' == $media_type && !empty( $video_link ) && 'style-2' != $media_style ) {
			echo '<a class="grve-video-popup" href="' . esc_url( $video_link ) . '">';
			echo '<div class="' . esc_attr( $media_class_string ) . '">';
			echo impeka_wpb_ext_get_video_icon( $video_icon_color );
			if( '0' != $overlay_opacity ) {
				echo '<div class="grve-bg-overlay grve-bg-' . esc_attr( $overlay_color ) . ' grve-opacity-' . esc_attr( $overlay_opacity ) . '"></div>';
			}
			echo impeka_wpb_ext_get_image_html( $image_item_atts );
			echo '</div>';
			echo '</a>';
			echo $content_output;
		} else if ( 'image' == $media_type && 'style-2' != $media_style ) {
			if ( $has_link ) {
				$link_attributes = impeka_wpb_ext_get_link_attributes( $title_link, $link_class );
				echo '<a ' . implode( ' ', $link_attributes ) . '>';
			}
			echo '<div class="' . esc_attr( $media_class_string ) . '">';
			if( '0' != $overlay_opacity ) {
				echo '<div class="grve-bg-overlay grve-bg-' . esc_attr( $overlay_color ) . ' grve-opacity-' . esc_attr( $overlay_opacity ) . '"></div>';
			}
			echo impeka_wpb_ext_get_image_html( $image_item_atts );
			echo '</div>';
			if ( $has_link ) {
				echo '</a>';
			}
			echo $content_output;
		} else if ( 'style-2' == $media_style && ('image' == $media_type || 'image-video-popup' == $media_type) ) {

			//Background Image
			$bg_img_style = impeka_wpb_ext_img_style( $image ,$bg_image_size );

			echo '<div class="grve-background-wrapper">';
			echo '<div class="grve-bg-image"  ' . $bg_img_style . '></div>';
			if( '0' != $overlay_opacity ) {
				echo '<div class="grve-bg-overlay grve-bg-' . esc_attr( $overlay_color ) . ' grve-opacity-' . esc_attr( $overlay_opacity ) . '"></div>';
			}
			echo '</div>';
			echo '<div class="' . esc_attr( $content_wrapper_class_string ) . '">';
			echo $content_output;
			echo '</div>';
		}
		break;
	case 'video':
		if ( !empty( $video_link ) ) {
			global $wp_embed;
			echo '<div class="' . esc_attr( $media_class_string ) . '">' .  $wp_embed->run_shortcode( '[embed]' . $video_link . '[/embed]' ) . '</div>';
			echo $content_output;
		}
		break;
	case 'map':
		wp_enqueue_script( 'impeka-google-maps');
		wp_enqueue_script( 'impeka-openstreetmap-maps');
		if ( empty( $map_marker ) ) {
			$map_marker = get_template_directory_uri() . '/images/markers/markers.png';
		} else {
			$id = preg_replace('/[^\d]/', '', $map_marker);
			$full_src = wp_get_attachment_image_src( $id, 'full' );
			$map_marker = $full_src[0];
		}
		$map_title = '';

		$map_attributes = array();
		$map_attributes[] = 'class="grve-map"';
		$map_attributes[] = 'data-lat="' . esc_attr( $map_lat ) . '"';
		$map_attributes[] = 'data-lng="' . esc_attr( $map_lng ) . '"';
		$map_attributes[] = 'data-zoom="' . esc_attr( $map_zoom ) . '"';
		$map_attributes[] = 'data-disable-style="' . esc_attr( $map_disable_style ) . '"';

		$css_style .= impeka_wpb_ext_build_dimension( 'height', $map_height );
		if ( !empty( $css_style ) ) {
			$map_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
		}

		echo '<div class="' . esc_attr( $media_class_string ) . '">';
		echo '<div ' . implode( ' ', $map_attributes ) . '>';
		echo apply_filters( 'impeka_grve_privacy_gmap_fallback', '', $map_lat, $map_lng );
		echo '</div>';

		$map_point_attributes = array();
		$map_point_attributes[] = 'data-point-lat="' . esc_attr( $map_lat ) . '"';
		$map_point_attributes[] = 'data-point-lng="' . esc_attr( $map_lng ) . '"';
		$map_point_attributes[] = 'data-point-marker="' . esc_url( $map_marker ) . '"';
		$map_point_attributes[] = 'data-point-title="' . esc_attr( $map_title ) . '"';

		echo '<div style="display:none" class="grve-map-point" ' . implode( ' ', $map_point_attributes ) . '"></div>';
		echo '</div>';
		echo $content_output;
		break;
	default :
		break;
}

echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
