<?php
/**
 * Menu Template
 */

$atts = vc_map_get_attributes( 'impeka_menu', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-menu-element', 'grve-align-' . $align, 'grve-space-' . $item_space );
if ( !empty( $heading ) ) {
	$element_classes[] = 'grve-' . $heading;
}
if ( !empty( $custom_font_family ) ) {
	$element_classes[] = 'grve-' . $custom_font_family;
}
if( 'horizontal' == $orientation && 'inherit' != $responsive_orientation ) {
	$element_classes[] = 'grve-' . $responsive_orientation;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}

$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

if ( empty( $nav_menu) ) {
	?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
		<?php if( 'horizontal' == $orientation ){ ?>
		<nav class="grve-horizontal-menu grve-menu-element">
			<ul class="grve-menu">
				<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 1</span></a></div></li>
				<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 2</span></a></div></li>
				<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 3</span></a></div></li>
				<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 4</span></a></div></li>
			</ul>
		</nav>
		<?php } else { ?>
		<div class="grve-vertical-menu-wrapper">
			<nav class="grve-vertical-menu grve-menu-element grve-<?php echo esc_attr( $menu_type ); ?>-animation" data-menu-type="<?php echo esc_attr( $menu_type ); ?>">
				<ul class="grve-menu">
					<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 1</span></a></div></li>
					<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 2</span></a></div></li>
					<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 3</span></a></div></li>
					<li class="menu-item grve-first-level"><div class="grve-link-wrapper"><a href="#"><span class="grve-item">Menu Item 4</span></a></div></li>
				</ul>
			</nav>
		</div>
		<?php } ?>
	</div>
	<?php
	return;
}

$walker = false;
if ( class_exists('Impeka_Grve_Element_Navigation_Walker') ) {
	$walker = new Impeka_Grve_Element_Navigation_Walker();
}

//OUTPUT

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php if( 'horizontal' == $orientation ){ ?>
		<nav class="grve-horizontal-menu grve-menu-element">
			<?php
				wp_nav_menu(
					array(
						'menu' => $nav_menu,
						'menu_class' => 'grve-menu',
						'container' => false,
						'walker' => $walker,
						'fallback_cb' => false,
						'depth' => '1',
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'orientation' => $orientation,
					)
				);
			?>
		</nav>
	<?php } else { ?>
	<div class="grve-vertical-menu-wrapper">
		<nav class="grve-vertical-menu grve-menu-element grve-<?php echo esc_attr( $menu_type ); ?>-animation" data-menu-type="<?php echo esc_attr( $menu_type ); ?>">
			<?php
				wp_nav_menu(
					array(
						'menu' => $nav_menu,
						'menu_class' => 'grve-menu',
						'container' => false,
						'walker' => $walker,
						'fallback_cb' => false,
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'orientation' => $orientation,
					)
				);
			?>
		</nav>
	</div>
	<?php } ?>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
