<?php
/**
 * Message Box Template
 */

$atts = vc_map_get_attributes( 'impeka_message_box', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-message' );
if ( !empty( $animation ) ) {
	if( 'clipping-animation' == $animation ) {
		$element_classes[] = 'grve-clipping-animation';
		$element_classes[] = 'grve-advanced-animation';
		if( 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation || 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation ) {
			$element_classes[] = 'grve-colored-clipping';
			$wrapper_attributes[] = 'data-clipping-color="' . esc_attr( $clipping_animation_colors ) . '"';
		}
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $clipping_animation ) . '"';
	} else if('appear-animation' == $animation) {
		$element_classes[] = 'grve-appear-animation';
		$element_classes[] = 'grve-advanced-animation';
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $appear_animation ) . '"';
	} else {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	}
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if( 'white' == $bg_color || 'grey' == $bg_color || 'light-grey' == $bg_color ) {
	$element_classes[] = 'grve-text-dark-grey';
} else {
	$element_classes[] = 'grve-text-white';
}

if ( !empty( $shadow ) ) {
	$element_classes[] = 'grve-' . $shadow;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

if( 'yes' == $add_icon ) {
	$icon_class = isset( ${"icon_" . $icon_library} ) ? esc_attr( ${"icon_" . $icon_library} ) : 'fas fa-adjust';
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ) {
		vc_icon_element_fonts_enqueue( $icon_library );
	}
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div class="grve-message-inner grve-bg-'. esc_attr( $bg_color ) . '">';
		if( 'yes' == $add_icon ) {
			echo '<span class="grve-message-icon '. esc_attr( $icon_class ) . '"></span>';
		}
		echo '<div class="grve-content-wrapper">';
			echo '<p>' . do_shortcode( $content ) . '</p>';
		echo '</div>';
		if ( 'yes' != $remove_close ) {
			echo '<div class="grve-close-btn">' . impeka_wpb_ext_get_svg_icon( 'close' ) . '</div>';
		}
	echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
