<?php
/**
 * Progres Bar Template
 */

$atts = vc_map_get_attributes( 'impeka_progress_bar', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-progress-bars', 'grve-' . $bar_style );
if ( !empty( $heading ) ) {
	$element_classes[] = 'grve-' . $heading;
}
if( 'inherit' != $text_color && 'style-2' == $bar_style ){
	$element_classes[] = 'grve-text-' . $text_color;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Bar Classes
$bar_classes = array( 'grve-bar' );
if ( !empty( $base_color ) ) {
	$bar_classes[] = 'grve-base-bg-' . $base_color;
}
if ( !empty( $bar_line_style ) ) {
	$bar_classes[] = 'grve-' . $bar_line_style;
}
$bar_class_string = implode( ' ', $bar_classes );

$bar_height_style = '';
if( !empty( $bar_height ) && 'style-2' == $bar_style ) {
	$bar_height_style .= 'height: '.(preg_match('/(px|em|\%|pt|cm)$/', $bar_height) ? $bar_height : $bar_height.'px').';';
}

$graph_lines = explode(",", $values);

$graph_lines_data = array();
foreach ($graph_lines as $line) {
	$new_line = array();
	$data = explode("|", $line);
	$new_line['value'] = isset( $data[0] ) && !empty( $data[0] ) ? $data[0] : 0;
	$new_line['percentage_value'] = isset( $data[1] ) && !empty( $data[1] ) ? $data[1] : '';
	$new_line['color'] = isset( $data[2] ) && !empty( $data[2] ) ? $data[2] : $color;

	if( (float)$new_line['value'] < 0 ) {
		$new_line['value'] = 0;
	} else if ( (float)$new_line['value'] > 100 ) {
		$new_line['value'] = 100;
	}

	$new_line['label'] = $new_line['percentage_value'];
	$graph_lines_data[] = $new_line;
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

foreach($graph_lines_data as $line) {

	$bar_item_classes = array('grve-bar-line');
	$color_class = 'grve-primary';
	if ( 'primary' != $line['color'] ) {
		$bar_item_classes[] = 'grve-bg-' . $line['color'];
	}
	if( 'white' == $line['color'] ) {
		$bar_item_classes[] = 'grve-text-black';
	} else {
		$bar_item_classes[] = 'grve-text-white';
	}
	$bar_item_class_string = implode( ' ', $bar_item_classes );

	$progress_bar_classes = array('grve-progress-bar');
	if( 'style-1' == $bar_style ) {
		if( 'white' == $line['color'] || 'grey' == $line['color'] || 'light-grey' == $line['color'] ) {
			$progress_bar_classes[] = 'grve-text-black';
		} else {
			$progress_bar_classes[] = 'grve-text-white';
		}
	}
	$progress_bar_class_string = implode( ' ', $progress_bar_classes );


	echo '<div class="' . esc_attr( $progress_bar_class_string ) . '" data-value="' .  esc_attr( $line['value'] ) . '">';
		echo '<div class="grve-bar-title">' . $line['label'] . '<span class="grve-percentage">' .  esc_html( $line['value'] ) . '%</span> </div>';
		echo '<div class="' . esc_attr( $bar_class_string ) . '">';
			echo '<div class="' .  esc_attr( $bar_item_class_string ) . '" style="' . esc_attr( $bar_height_style ) . '"></div>';
		echo '</div>';
	echo '</div>';

}

echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
