<?php
/**
 * Quote Template
 */

$atts = vc_map_get_attributes( 'impeka_quote', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-quote-element', 'grve-align-' . $align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if ( 'inherit' != $text_color ) {
	$element_classes[] = 'grve-text-' . $text_color;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<blockquote ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<p>' . wp_kses_post( $content ) . '</p>';
echo '</blockquote>';

//Omit closing PHP tag to avoid accidental whitespace output errors.