<?php
/**
 * Slogan Template
 */

$atts = vc_map_get_attributes( 'impeka_slogan', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-slogan', 'grve-align-' . $align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Title
if ( !empty( $title ) ) {
	//Title Classes
	$title_classes = array( 'grve-slogan-title', 'grve-align-' . $align, 'grve-' . $heading );

	if ( !empty( $custom_font_family ) ) {
		$title_classes[] = 'grve-' . $custom_font_family;
	}
	if( '100' != $increase_heading ){
		if( !empty( $increase_heading_reset ) ) {
			$title_classes = impeka_wpb_ext_increase_heading_reset( $increase_heading_reset, $title_classes );
		}
		$title_classes[] = 'grve-increase-heading';
		$title_classes[] = 'grve-heading-' . $increase_heading;
	}
	if( 'inherit' != $title_color && 'custom' != $title_color ){
		$title_classes[] = 'grve-text-' . $title_color;
	}
	$title_class_string = implode( ' ', $title_classes );

	if( 'custom' == $title_color ){
		$css_style .= ' color: ' . esc_attr( $title_color_custom ) . ';';
	}
}

//Subtitle Classes
$subtitle_classes = array( 'grve-subtitle' );
if( 'inherit' != $subtitle_color ){
	$subtitle_classes[] = 'grve-text-' . $subtitle_color;
}
$subtitle_class_string = implode( ' ', $subtitle_classes );

//Text Classes
$text_classes = array();
if ( !empty( $text_style ) && $text_style != 'none' ) {
	$text_classes[] = 'grve-' . $text_style;
}
if( 'inherit' != $text_color ){
	$text_classes[] = 'grve-text-' . $text_color;
}
$text_class_string = implode( ' ', $text_classes );

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
if ( !empty( $subtitle ) ) {
	echo '<div class="' . esc_attr( $subtitle_class_string ) . '">' . wp_kses_post( $subtitle ) . '</div>';
}
if ( !empty( $title ) ) {
	$title_style = '';
	if( 'custom' == $title_color ){
		$title_style .= ' color: ' . esc_attr( $title_color_custom ) . ';';
	}
	echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '" style="' . esc_attr( $title_style ) . '">';
	echo '<span>' . $title;
	if( 'line' == $line_type ) {
		$line_style = '';
		$line_style .= 'width: '.(preg_match('/(px|em|\%|pt|cm)$/', $line_width) ? $line_width : $line_width.'px').';';
		$line_style .= 'height: '. $line_height. 'px;';
		echo '<span class="grve-title-line grve-bg-' . esc_attr( $line_color ) . '" style="' . esc_attr( $line_style ) . '"></span>';
	}
	echo '</span>';
	echo '</' . tag_escape( $heading_tag ) . '>';
}
if ( !empty( $content ) ) {
	echo '<p class="' . esc_attr( $text_class_string ) . '">' . impeka_wpb_ext_unautop( $content ) . '</p>';
}

if ( !empty( $btn_text ) || !empty( $btn2_text ) ) {
	echo '<div class="grve-btn-wrapper">';
	echo impeka_wpb_ext_get_button( $atts );
	echo impeka_wpb_ext_get_button( $atts, '2' );
	echo '</div>';
}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
