<?php
/**
 * Social Links Template
 */

$atts = vc_map_get_attributes( 'impeka_social_links', $atts );
extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'default-social-links-id';
}
$el_id = 'social-links-' . $el_id;

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-social', 'grve-align-' . $align, 'grve-' . $social_type . '-type', 'grve-space-' . $item_space );
if ( 'list' == $social_type ) {
	$element_classes[] = 'grve-' . $list_type;
	$element_classes[] = 'grve-text-' . $icon_color;
} else {
	$element_classes[] = 'grve-icon-' . $icon_size;
}
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';

if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Social Shape Classes
$social_shape_classes = array( 'grve-' . $icon_shape );
if ( 'no-shape' != $icon_shape ) {
	$social_shape_classes[] = 'grve-with-shape';
	$social_shape_classes[] = 'grve-' . $shape_type;
	if ( 'outline' != $shape_type ) {
		$social_shape_classes[] = 'grve-bg-' . $shape_color;
	} else {
		$social_shape_classes[] = 'grve-text-' . $shape_color;
		$social_shape_classes[] = 'grve-text-hover-' . $shape_color;
	}
}
$social_shape_class_string = implode( ' ', $social_shape_classes );

global $impeka_grve_social_list_extended;

//OUTPUT

if ( isset( $impeka_grve_social_list_extended ) ) {

?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
		<ul>
		<?php
		foreach ( $impeka_grve_social_list_extended as $social_item ) {

			$social_item_url = impeka_wpb_ext_array_value( $atts, $social_item['url'] );

			if ( ! empty( $social_item_url ) ) {

				if( 'icon' == $social_type ) {

					if ( 'skype' == $social_item['id'] ) {
		?>
						<li>
							<a href="<?php echo esc_url( $social_item_url, array( 'skype', 'http', 'https' ) ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?>">
								<span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> <?php echo esc_attr( $social_item['class'] ); ?>"></span>
								<span class="screen-reader-text"><?php echo esc_html( $social_item['title'] ); ?></span>
							</a>
						</li>
		<?php
					} else {
		?>
						<li>
							<a href="<?php echo esc_url( $social_item_url ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?>" target="_blank" rel="noopener noreferrer">
								<span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> <?php echo esc_attr( $social_item['class'] ); ?>"></span>
								<span class="screen-reader-text"><?php echo esc_html( $social_item['title'] ); ?></span>
							</a>
						</li>
		<?php
					}
				} else {
					if ( 'skype' == $social_item['id'] ) {
		?>
						<li>
							<a href="<?php echo esc_url( $social_item_url, array( 'skype', 'http', 'https' ) ); ?>" class="grve-<?php echo esc_attr( $font_size ); ?>">
								<span><?php echo esc_attr( $social_item['title'] ); ?></span>
							</a>
						</li>
		<?php
					} else {
		?>
						<li>
							<a href="<?php echo esc_url( $social_item_url ); ?>" class="grve-<?php echo esc_attr( $font_size ); ?>" target="_blank" rel="noopener noreferrer">
								<span><?php echo esc_attr( $social_item['title'] ); ?></span>
							</a>
						</li>
		<?php
					}

				}

			}
		}
		?>
		</ul>
	</div>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.