<?php
/**
 * Social Template
 */

$atts = vc_map_get_attributes( 'impeka_social', $atts );
extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'default-social-id';
}
$el_id = 'social-' . $el_id;

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-social', 'grve-align-' . $align, 'grve-icon-type', 'grve-space-' . $item_space );
$element_classes[] = 'grve-icon-' . $icon_size;
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';

if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Social Shape Classes
$social_shape_classes = array( 'grve-' . $icon_shape );
if ( 'no-shape' != $icon_shape ) {
	$social_shape_classes[] = 'grve-with-shape';
	$social_shape_classes[] = 'grve-' . $shape_type;
	if ( 'outline' != $shape_type ) {
		$social_shape_classes[] = 'grve-bg-' . $shape_color;
	} else {
		$social_shape_classes[] = 'grve-text-' . $shape_color;
		$social_shape_classes[] = 'grve-text-hover-' . $shape_color;
	}
}
$social_shape_class_string = implode( ' ', $social_shape_classes );


$page_link = get_permalink();
$page_title = get_the_title();
$page_email_string = 'mailto:?subject=' . $page_title . '&body=' . $page_title . ': ' . $page_link;

$image_url = '';
if ( is_singular() && has_post_thumbnail() ) {
	$image_url = get_the_post_thumbnail_url( get_the_ID(), 'large' );
}

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<ul>
		<?php if ( !empty( $social_email ) ) { ?>
		<li><a href="<?php echo esc_url( $page_email_string ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-email" aria-label="E-mail"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fas fa-envelope"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_facebook ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-facebook" aria-label="Facebook"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-facebook-f"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_twitter ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-twitter" aria-label="Twitter"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-twitter"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_linkedin ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-linkedin" aria-label="Linkedin"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-linkedin-in"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_reddit ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-reddit" aria-label="Reddit"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-reddit"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_pinterest ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-pinterest" aria-label="Pinterest" data-pin-img="<?php echo esc_url( $image_url ); ?>" ><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-pinterest"></span></a></li>
		<?php } ?>
		<?php if ( !empty( $social_tumblr ) ) { ?>
		<li><a href="<?php echo esc_url( $page_link ); ?>" title="<?php echo esc_attr( $page_title ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-social-share-tumblr" aria-label="Tumblr"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fab fa-tumblr"></span></a></li>
		<?php } ?>

		<?php if ( !empty( $likes ) && function_exists( 'impeka_grve_likes' ) ) {
			global $post;
			$post_id = $post->ID;
		?>
		<li><a href="#" class="<?php echo esc_attr( $social_shape_class_string ); ?> grve-like-counter-link" data-post-id="<?php echo esc_attr( $post_id ); ?>" aria-label="<?php esc_attr_e( 'Likes', 'impeka-wpb-extension' ); ?>"><span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> fas fa-heart"></span><span class="grve-like-counter"><?php echo impeka_grve_likes( $post_id, 'number' ); ?></span></a></li>
		<?php } ?>

	</ul>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.