<?php
/**
 * Split Content Template
 */

$atts = vc_map_get_attributes( 'impeka_split_content', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-split-content', 'grve-' . $split_content_height . '-size', 'grve-media-' . $split_content_align );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $min_height ) ) {
	$css_style .= ' min-height:' . esc_attr( $min_height ) . 'px';
}
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

// Title Classes
$title_classes = array( 'grve-title', 'grve-align-center', 'grve-heading-color', 'grve-' . $heading );
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if ( '100' != $increase_heading ){
	if( !empty( $increase_heading_reset ) ) {
		$title_classes = impeka_wpb_ext_increase_heading_reset( $increase_heading_reset, $title_classes );
	}
	$title_classes[]  = 'grve-increase-heading';
	$title_classes[]  = 'grve-heading-' . $increase_heading;
}
if ( !empty( $split_title ) ) {
	$title_classes[]  = 'grve-split-title';
	$title_classes[]  = 'grve-split-size-' . $split_title_space;
}
$title_class_string = implode( ' ', $title_classes );

// Bg Wrapper Classes
$bg_image_wrapper_classes = array( 'grve-split-wrapper', 'grve-media-wrapper', 'grve-headings-' . $overlapping_title_color, 'grve-text-' . $overlapping_title_color );
$bg_image_wrapper_class_string = implode( ' ', $bg_image_wrapper_classes );

//Background Image Classses
$bg_image_classes = array( 'grve-bg-image','grve-bg-' . $bg_position );
if( $bg_image > 0 ){
	$bg_image_classes[] = 'grve-bg-image-id-' . $bg_image ;
}
$bg_image_string = implode( ' ', $bg_image_classes );

$out_image_bg = $out_slider_image_bg = $out_video_bg_url = $out_video_bg = $out_media_bg = '';

//Background Image
$img_style = impeka_wpb_ext_img_style( $bg_image ,$bg_image_size );

if ( 'image' == $media_type ) {
	$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . '"  ' . $img_style . '></div>';
}

if ( ( 'hosted_video' == $media_type || 'video' == $media_type ) && !empty ( $bg_image ) ) {
	$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . '"  ' . $img_style . '></div>';
}

//Background Video
if ( 'hosted_video' == $media_type && ( !empty ( $bg_video_webm ) || !empty ( $bg_video_mp4 ) || !empty ( $bg_video_ogv ) ) ) {

	$has_video_bg = true;
	$video_poster = $playsinline = '';
	if ( wp_is_mobile() ) {
		if ( 'yes' == $bg_video_device ) {
			$video_poster = impeka_wpb_ext_img_url( $bg_image ,$bg_image_size );
			$muted = 'yes';
			$playsinline = 'yes';
		} else {
			$has_video_bg = false;
		}
	}

	if ( $has_video_bg ) {
		$video_settings = array(
			'preload' => 'auto',
			'autoplay' => 'yes',
			'loop' => 'yes',
			'muted' => 'yes',
			'poster' => $video_poster,
			'playsinline' => $playsinline,
		);

		if ( function_exists( 'impeka_grve_print_media_video_settings' ) ) {
			$video_attr = impeka_grve_print_media_video_settings( $video_settings );
		} else {
			$video_attr = ' controls';
		}

		$out_video_bg .= '<div class="grve-bg-video grve-html5-bg-video" data-video-device="' . esc_attr( $bg_video_device ) .'">';
		$out_video_bg .=  '<video data-autoplay ' . $video_attr . '>';
		if ( !empty ( $bg_video_webm ) ) {
			$out_video_bg .=  '<source src="' . esc_url( $bg_video_webm ) . '" type="video/webm">';
		}
		if ( !empty ( $bg_video_mp4 ) ) {
			$out_video_bg .=  '<source src="' . esc_url( $bg_video_mp4 ) . '" type="video/mp4">';
		}
		if ( !empty ( $bg_video_ogv ) ) {
			$out_video_bg .=  '<source src="' . esc_url( $bg_video_ogv ) . '" type="video/ogg">';
		}
		$out_video_bg .=  '</video>';
		$out_video_bg .= '</div>';
	}
}

//YouTube Video
$out_video_bg_url = '';

$youtube_id = '';
if ( function_exists( 'impeka_grve_extract_youtube_id' ) ) {
	$youtube_id = impeka_grve_extract_youtube_id( $bg_video_url );
}
$has_video_bg = ( 'video' == $media_type && ! empty( $bg_video_url ) && $youtube_id );
if ( $has_video_bg ) {
	wp_enqueue_script( 'youtube-iframe-api' );
	$out_video_bg_url .= '<div class="grve-bg-video grve-yt-bg-video" data-video-bg-url="' . esc_attr( $bg_video_url ) . '"></div>';
}

// Slider
if ( 'slider' == $media_type ) {

	$attachments = explode( ",", $ids );
	if ( !empty( $attachments ) ) {

		$slider_data = '';
		$slider_data .= ' data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
		$slider_data .= ' data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
		$slider_data .= ' data-slider-loop="' . esc_attr( $loop ) . '"';
		$slider_data .= ' data-slider-transition="' . esc_attr( $transition ) . '"';

		$out_slider_image_bg .= '<div class="grve-slit-content-slider grve-slider-element"' . $slider_data . '>';

		foreach ( $attachments as $id ) {
			$slider_img_style = impeka_wpb_ext_img_style( $id ,$bg_image_size );
			$out_slider_image_bg .= '  <div class="grve-slider-item">';
			$out_slider_image_bg .= '    <div class="' . esc_attr( $bg_image_string ) . '"  ' . $slider_img_style . '></div>';
			$out_slider_image_bg .= '  </div>';
		}

		$out_slider_image_bg .= '</div>';
	}
}

// Media Output
$out_media_bg .= '<div class="grve-background-wrapper">';
if ( 'slider' != $media_type ) {
	$out_media_bg .= $out_image_bg;
	$out_media_bg .= $out_video_bg_url;
	$out_media_bg .= $out_video_bg;
} else {
	$out_media_bg .= $out_slider_image_bg;
}
if ( !empty ( $opacity_overlay ) && '0' != $opacity_overlay ) {
	$out_media_bg .= '  <div class="grve-bg-overlay grve-bg-' . esc_attr( $color_overlay ) . ' grve-opacity-' . esc_attr( $opacity_overlay ) . '"></div>';
}
$out_media_bg .= '</div>';

if( empty( $text_style ) ) {
	$text_style = 'text-none';
}

// Content
$out_content = '';
if ( !empty( $content ) || !empty( $read_more_title ) ) {
	$out_content .= '<div class="grve-content">';
	if ( !empty( $content ) ) {
		$out_content .= '  <p class="grve-description grve-' . esc_attr( $text_style ) . '">' . do_shortcode( $content ) . '</p>';
	}
	$out_content .= impeka_wpb_ext_get_button( $atts );
	$out_content .= '</div>';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div class="' . esc_attr( $bg_image_wrapper_class_string ) . '">';
		echo '<div class="grve-wrapper-inner">';
		if ( !empty( $title ) ) {
		echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '"><span>' . $title. '</span></' . tag_escape( $heading_tag ) . '>';
		}
		echo $out_content;
		echo '</div>';
		echo $out_media_bg;
	echo '</div>';
	echo '<div class="grve-split-wrapper grve-content-wrapper">';
		echo '<div class="grve-wrapper-inner">';
			if ( !empty( $title ) ) {
			echo '<div class="' . esc_attr( $title_class_string ) . '"><span>' . $title. '</span></div>';
			}
			echo $out_content;
		echo '</div>';
		if ( 'slider' == $media_type ) {
			echo '<div class="grve-slider-dots owl-controls"></div>';
		}
	echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.