<?php
/**
 * Team Template
 */

$atts = vc_map_get_attributes( 'impeka_team', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-team', 'grve-' . $team_layout );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}

if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if ( 'layout-3' == $team_layout || 'layout-4' == $team_layout ) {
	if( 'mouse-move' == $image_animation_effect ) {
		$element_classes[] = 'grve-mouse-move';
	}
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$hover_item_classes = array('grve-hover-item');
if ( 'none' != $radius ) {
	$hover_item_classes[] = 'grve-radius-' . $radius;
}
if( 'mouse-move' == $image_animation_effect ) {
	$hover_item_classes[] = 'grve-thumb-mouse-move';
}
if ( !empty( $shadow ) ) {
	$hover_item_classes[] = 'grve-' . $shadow;
}
if ( !empty( $image_effect ) ) {
	$hover_item_classes[] = 'grve-' . $image_effect;
}
$hover_item_class_string = implode( ' ', $hover_item_classes );

// Person Classes
$person_classes = array('grve-team-person');
if ( !empty( $image_effect ) ) {
	$person_classes[] = 'grve-' . $image_effect;
}
$person_class_string = implode( ' ', $person_classes );


$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

// Name Classes
$name_classes = array('grve-team-name');
$name_classes[] = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$name_classes[] = 'grve-' . $custom_font_family;
}
if ( 'inherit' != $name_color && ( 'layout-1' == $team_layout || 'layout-3' == $team_layout || 'layout-4' == $team_layout ) ) {
	$name_classes[] = 'grve-text-' . $name_color;
}
$name_class_string = implode( ' ', $name_classes );

// Identity Classes
$identity_classes = array('grve-team-identity', 'grve-small-text');
if ( 'inherit' != $identity_color && ( 'layout-1' == $team_layout || 'layout-3' == $team_layout || 'layout-4' == $team_layout ) ) {
	$identity_classes[] = 'grve-text-' . $identity_color;
}
$identity_class_string = implode( ' ', $identity_classes );


$image_mode_size = impeka_wpb_ext_get_image_size( $image_size );

if ( 'layout-3' == $team_layout || 'layout-4' == $team_layout ) {
	$image_item_atts = array(
		'image' => $image,
		'image_mode_size' => 'thumbnail',
		'image_load_mode' => $image_load_mode,
	);
} else {
	$image_item_atts = array(
		'image' => $image,
		'retina_image' => $retina_image,
		'image_mode_size' => $image_mode_size,
		'image_load_mode' => $image_load_mode,
		'column_space' => '100',
		'wrapper' => 'yes',
	);
}

$links = '';
if ( !empty( $social_facebook ) ) {
	$links .= '<li><a href="' . esc_url( $social_facebook ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-facebook-f" aria-hidden="true"></span><span class="screen-reader-text">Facebook</span></a></li>';
}
if ( !empty( $social_twitter ) ) {
	$links .= '<li><a href="' . esc_url( $social_twitter ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-twitter" aria-hidden="true"></span><span class="screen-reader-text">Twitter</span></a></li>';
}
if ( !empty( $social_linkedin ) ) {
	$links .= '<li><a href="' . esc_url( $social_linkedin ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-linkedin-in" aria-hidden="true"></span><span class="screen-reader-text">Linkedin</span></a></li>';
}
if ( !empty( $social_xing ) ) {
	$links .= '<li><a href="' . esc_url( $social_xing ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-xing" aria-hidden="true"></span><span class="screen-reader-text">Xing</span></a></li>';
}
if ( !empty( $social_instagram ) ) {
	$links .= '<li><a href="' . esc_url( $social_instagram ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-instagram" aria-hidden="true"></span><span class="screen-reader-text">Instagram</span></a></li>';
}
if ( !empty( $social_youtube ) ) {
	$links .= '<li><a href="' . esc_url( $social_youtube ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-youtube" aria-hidden="true"></span><span class="screen-reader-text">YouTube</span></a></li>';
}
if ( !empty( $social_vimeo ) ) {
	$links .= '<li><a href="' . esc_url( $social_vimeo ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-icon fab fa-vimeo" aria-hidden="true"></span><span class="screen-reader-text">Vimeo</span></a></li>';
}
if ( !empty( $email ) ) {
	$links .= '<li><a href="' . esc_url( 'mailto:' . antispambot( $email ) ) . '"><span class="grve-icon fas fa-envelope" aria-hidden="true"></span><span class="screen-reader-text">E-mail</span></a></li>';
}

$has_link = impeka_wpb_ext_has_link( $link );

$link_team_class = 'grve-team-url';
if( !empty( $link_class ) )  {
	$link_team_class .= ' ' . $link_class;
}
$link_attributes = impeka_wpb_ext_get_link_attributes( $link, $link_class );
$link_team_attributes = impeka_wpb_ext_get_link_attributes( $link, $link_team_class );

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
if ( 'layout-1' == $team_layout || 'layout-2' == $team_layout ) {
?>
	<div class="<?php echo esc_attr( $hover_item_class_string ); ?>">
		<?php if ( $has_link ) { echo '<a ' . implode( ' ', $link_team_attributes ) . '></a>'; } ?>
		<div class="<?php echo esc_attr( $person_class_string ); ?>">
			<?php echo impeka_wpb_ext_get_image_html( $image_item_atts ); ?>
		</div>
		<ul class="grve-team-social grve-align-center">
			<?php echo $links; ?>
		</ul>
		<?php
		if ( 'layout-2' == $team_layout ) {
		?>
		<div class="grve-team-description grve-align-center">
			<?php if ( !empty( $identity ) ) { ?>
			<div class="<?php echo esc_attr( $identity_class_string ); ?>"><?php echo wp_kses_post( $identity ); ?></div>
			<?php } ?>
			<<?php echo tag_escape( $heading_tag ); ?> class="<?php echo esc_attr( $name_class_string ); ?>"><?php echo wp_kses_post( $name ); ?></<?php echo tag_escape( $heading_tag ); ?>>
		</div>
		<?php
			}
		?>
	</div>
	<?php
	if ( 'layout-1' == $team_layout ) {
	?>
	<div class="grve-team-description grve-align-center">
		<?php if ( !empty( $identity ) ) { ?>
		<div class="<?php echo esc_attr( $identity_class_string ); ?>"><?php echo wp_kses_post( $identity ); ?></div>
		<?php } ?>
		<<?php echo tag_escape( $heading_tag ); ?> class="<?php echo esc_attr( $name_class_string ); ?>"><?php echo wp_kses_post( $name ); ?></<?php echo tag_escape( $heading_tag ); ?>>
	</div>
	<?php
		}
	?>
<?php
	} else if ( 'layout-3' == $team_layout || 'layout-4' == $team_layout ) {
?>
	<div class="<?php echo esc_attr( $person_class_string ); ?>">
		<?php echo impeka_wpb_ext_get_image_html( $image_item_atts ); ?>
		<?php if ( $has_link ) { echo '<a ' . implode( ' ', $link_team_attributes ) . '></a>'; } ?>
	</div>
	<div class="grve-team-description">
		<?php if ( !empty( $identity ) ) { ?>
		<div class="<?php echo esc_attr( $identity_class_string ); ?>"><?php echo wp_kses_post( $identity ); ?></div>
		<?php } ?>
		<<?php echo tag_escape( $heading_tag ); ?> class="<?php echo esc_attr( $name_class_string ); ?>"><?php echo wp_kses_post( $name ); ?></<?php echo tag_escape( $heading_tag ); ?>>
	</div>
<?php
	}
?>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
