<?php
/**
 * Testimonial Carousel Template
 */

$atts = vc_map_get_attributes( 'impeka_testimonial_carousel', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-testimonial-carousel' );
$element_classes[] = $el_class;
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

if( 'style-1' == $style || 'style-2' == $style || 'style-3' == $style ) {
	$type = 'classic';
}

//Carousel Wrapper
$carousel_attributes = array();
if( 'style-1' == $style || 'style-2' == $style || 'style-3' == $style ) {
	$carousel_attributes[] = 'data-items="1"';
	$carousel_attributes[] = 'data-items-tablet-landscape="1"';
	$carousel_attributes[] = 'data-items-tablet-portrait="1"';
	$carousel_attributes[] = 'data-items-mobile="1"';
} else {
	$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
	$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
	$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
	$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
}
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
$carousel_attributes[] = 'data-slider-autoheight="' . esc_attr( $auto_height ) . '"';
$carousel_attributes[] = 'data-stage-padding="0"';

if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter && ('style-1' != $style || 'style-2' != $style) ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}

$carousel_classes = array( 'grve-carousel-element', 'grve-testimonial' );
if ( !empty ( $align ) && 'style-4' != $style && 'style-5' != $style ) {
	$carousel_classes[] = 'grve-align-' . $align;
}
if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size && ('style-1' != $style || 'style-2' != $style) ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
if ( 'none' != $text_style ) {
	$carousel_classes[] ='grve-' . $text_style;
}
$carousel_classes[] = 'grve-carousel-pagination-1';
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';

$testimonial_cat = "";

if ( !empty( $categories ) ) {
	$testimonial_category_list = explode( ",", $categories );
	foreach ( $testimonial_category_list as $testimonial_list ) {
		$testimonial_term = get_term( $testimonial_list, 'testimonial_category' );
		$testimonial_cat = $testimonial_cat.$testimonial_term->slug . ', ';
	}
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'testimonial',
		'post_status'=>'publish',
		'paged' => 1,
		'post__in' => $include_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'testimonial',
		'post_status'=>'publish',
		'paged' => 1,
		'testimonial_category' => $testimonial_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div <?php echo implode( ' ', $carousel_attributes ); ?>>

<?php
while ( $query->have_posts() ) : $query->the_post();

	$item_params = array(
		'type' => $type,
		'name' => impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_name' ),
		'identity' => impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_identity' ),
		'title_color' => $title_color,
		'text_color' => $text_color,
		'bg_color' => $bg_color,
		'show_title' => $show_title,
		'heading_tag' => $heading_tag,
		'heading' => $heading,
		'show_image' => $show_image,
		'radius' => $radius,
		'shadow' => $shadow,
	);
	?>
	<div <?php post_class( "grve-carousel-item" ); ?>>
		<?php get_template_part( 'templates/testimonial/testimonial', $style, $item_params ); ?>
	</div>
	<?php
endwhile;
?>
	</div>
	<?php if( ( 'style-2' == $style || 'style-3' == $style ) && 'yes' == $pagination ) { ?>
	<div class="grve-thumb-pagination grve-align-<?php echo esc_attr( $align ); ?> grve-<?php echo esc_attr( $style ); ?>">
		<?php
		while ( $query->have_posts() ) : $query->the_post();
			$name = impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_name' );
			$identity = impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_identity' );
		?>
			<button class="grve-pagination-item">
				<?php the_post_thumbnail( 'thumbnail' ); ?>
				<?php if( 'style-3' == $style && (!empty( $name ) || !empty( $identity ))) { ?>
				<span class="grve-pagination-content">
					<span class="grve-link-text"><?php echo esc_html( $name ); ?></span>
					<span class="grve-small-text"><?php echo esc_html( $identity ); ?></span>
				</span>
				<?php } ?>
			</button>
		<?php
		endwhile;
		?>
	</div>
	<?php } ?>
</div>

<?php
else :
	get_template_part( 'templates/testimonial/testimonial', 'none' );
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
