<?php
/**
 * Testimonial Template
 */

$atts = vc_map_get_attributes( 'impeka_testimonial', $atts );
$combined_atts = $atts;
extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'testimonial-default-id';
}
$el_id = 'el-' . $el_id;

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => $display_style,
	'animation' => $animation,
);
$wrapper_attributes = impeka_wpb_ext_get_grid_layout_atts( $wrapper_params );

$element_classes = array( 'grve-element', 'grve-testimonial', 'grve-testimonial-box', 'grve-isotope' );
if ( 'yes' == $item_gutter ) {
	$element_classes[] = 'grve-with-gap';
}
if ( 'none' != $text_style ) {
	$element_classes[] ='grve-' . $text_style;
}
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_classes[] = 'grve-testimonial-' . $mode;
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$testimonial_cat = "";
if ( !empty( $categories ) ) {
	$testimonial_category_list = explode( ",", $categories );
	foreach ( $testimonial_category_list as $testimonial_list ) {
		$testimonial_term = get_term( $testimonial_list, 'testimonial_category' );
		$testimonial_cat = $testimonial_cat.$testimonial_term->slug . ', ';
	}
}

$paged = 1;
$disable_pagination = '';
if ( empty( $display_style ) ) {
	$disable_pagination = 'yes';
}
if ( 'yes' != $disable_pagination ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'testimonial',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $posts_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'testimonial',
		'post_status'=>'publish',
		'paged' => $paged,
		'testimonial_category' => $testimonial_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $posts_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT
?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

		<div class="grve-isotope-container">
			<div class="grve-grid-sizer"></div>

<?php
while ( $query->have_posts() ) : $query->the_post();

	$item_params = array(
		'type' => $mode,
		'name' => impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_name' ),
		'identity' => impeka_wpb_ext_post_meta( '_impeka_grve_testimonial_identity' ),
		'title_color' => $title_color,
		'text_color' => $text_color,
		'bg_color' => $bg_color,
		'show_title' => $show_title,
		'heading_tag' => $heading_tag,
		'heading' => $heading,
		'show_image' => $show_image,
		'radius' => $radius,
		'shadow' => $shadow,
	);

	?>
		<div <?php post_class(); ?>>
			<div class="grve-isotope-item-inner">
				<?php get_template_part( 'templates/testimonial/testimonial', $style, $item_params ); ?>
			</div>
		</div>
	<?php

endwhile;

?>
		</div>
<?php

	if ( 'yes' != $disable_pagination ) {
		impeka_wpb_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
			'load_more_title' => $load_more_title,
		));
	}
?>
	</div>

<?php
else :
	get_template_part( 'templates/testimonial/testimonial', 'none' );
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
