<?php
/**
 * Video Template
 */

$atts = vc_map_get_attributes( 'impeka_video', $atts );
extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element' );
if ( $video_type == 'link' ){
	$element_classes[] = 'grve-video';
} else {
	$element_classes[] = 'grve-embed-video';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_wpb_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

if ( $video_type == 'html5' ){
	if( 'no' == $video_controls && 'yes' == $video_autoplay  ) {
		$video_sound = 'no';
		$wrapper_attributes[] = 'playsinline';
	}
	if( 'yes' == $video_controls ){
		$wrapper_attributes[] = 'controls';
	}
	if( 'yes' == $video_loop ){
		$wrapper_attributes[] = 'loop="loop"';
	}
	if( 'no' == $video_sound  ){
		$wrapper_attributes[] ='muted="muted"';
	}
	if( 'yes' == $video_autoplay ){
		$wrapper_attributes[] = 'autoplay="autoplay"';
	}
	if( !empty( $video_poster ) ){
		$id = preg_replace('/[^\d]/', '', $video_poster);
		$image_url = wp_get_attachment_url( $id );
		$wrapper_attributes[] = 'poster="' . esc_url( $image_url ) . '"';
	}
}

//OUTPUT

if ( $video_type == 'link' && !empty( $video_link ) ) {
	global $wp_embed;
	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>' . $wp_embed->run_shortcode( '[embed]' . $video_link . '[/embed]' ) . '</div>';
}

if ( $video_type == 'html5' ) {
	echo '<video ' . implode( ' ', $wrapper_attributes ) . '>';
	if ( !empty ( $video_webm ) ) {
		echo '<source src="' . esc_url( $video_webm ) . '" type="video/webm">';
	}
	if ( !empty ( $video_mp4 ) ) {
		echo '<source src="' . esc_url( $video_mp4 ) . '" type="video/mp4">';
	}
	if ( !empty ( $video_ogv ) ) {
		echo '<source src="' . esc_url( $video_ogv ) . '" type="video/ogg">';
	}
	echo '</video>';
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
