<?php
	$output = $out_pattern = $out_overlay = $out_image_bg = $out_video_bg = $column_link = '';

	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
	extract( $atts );

	switch( $width ) {
		case '1/12':
			$shortcode_column = '1-12';
			break;
		case '2/12':
		case '1/6':
			$shortcode_column = '1-6';
			break;
		case '3/12':
		case '1/4':
			$shortcode_column = '1-4';
			break;
		case '4/12':
		case '1/3':
			$shortcode_column = '1-3';
			break;
		case '5/12':
			$shortcode_column = '5-12';
			break;
		case '6/12':
		case '1/2':
			$shortcode_column = '1-2';
			break;
		case '7/12':
			$shortcode_column = '7-12';
			break;
		case '8/12':
		case '2/3':
		case '4/6':
			$shortcode_column = '2-3';
			break;
		case '9/12':
		case '3/4':
			$shortcode_column = '3-4';
			break;
		case '10/12':
		case '5/6':
			$shortcode_column = '5-6';
			break;
		case '11/12':
			$shortcode_column = '11-12';
			break;
		case '1/5':
			$shortcode_column = '1-5';
			break;
		case '2/5':
			$shortcode_column = '2-5';
			break;
		case '3/5':
			$shortcode_column = '3-5';
			break;
		case '4/5':
			$shortcode_column = '4-5';
			break;
		case '12/12':
		case '1/1':
		default :
			$shortcode_column = '1';
			break;
	}


	if ( !empty( $block_content ) && function_exists( 'impeka_grve_is_privacy_key_enabled' ) && !impeka_grve_is_privacy_key_enabled( $block_content ) ) {
		$column_content = impeka_grve_privacy_disable_fallback( $block_content );
	} else {
		$column_content = do_shortcode( $content );
	}

	$css_custom = '';


	$column_classes = array( 'grve-column', 'wpb_column', 'grve-bookmark' );
	$column_classes[] = 'grve-column-' . $shortcode_column;

	//CSS Class
	$column_classes[] = impeka_wpb_ext_shortcode_grve_css_class( $grve_css );

	if ( 'default' != $rc_heading_color ) {
		$column_classes[] = 'grve-headings-' . $rc_heading_color;
	}

	if( empty ( $rc_link_color ) ) {
		$rc_link_color = 'default';
	}

	if( empty ( $rc_link_hover_color ) ) {
		$rc_link_hover_color = 'default';
	}

	if( 'default' != $rc_link_color || 'default' != $rc_link_hover_color ) {
		$column_classes[] = 'grve-link-' . $rc_link_color;
		$column_classes[] = 'grve-link-hover-' . $rc_link_hover_color;
	}

	if( 'yes' == $full_height ) {
		$column_classes[] = 'grve-column-fullheight';
	}

	if( !empty ( $expand_column_bg ) ) {
		$column_classes[] = 'grve-expand-bg';
		$column_classes[] = 'grve-' . $expand_column_bg;
	}
	if( !empty ( $tablet_expand_column_bg ) ) {
		$column_classes[] = 'grve-tablet-landscape-expand-bg-' . $tablet_expand_column_bg;
	}
	if( !empty ( $tablet_sm_expand_column_bg ) ) {
		$column_classes[] = 'grve-tablet-portrait-expand-bg-' . $tablet_sm_expand_column_bg;
	}
	if( !empty ( $mobile_expand_column_bg ) ) {
		$column_classes[] = 'grve-mobile-expand-bg-' . $mobile_expand_column_bg;
	}

	if ( !empty ( $hover_animation ) ) {
		$column_classes[] = 'grve-hover-animation';
		$column_classes[] = 'grve-' . $hover_animation;
	}

	//Color Overlay
	if ( 'image' == $rc_bg_type || 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type  ) {

		if ( 'none' != $rc_bg_color_overlay && 'custom' != $rc_bg_color_overlay && 'gradient' != $rc_bg_color_overlay  ) {

			//Overlay Classes
			$overlay_classes = array();
			$overlay_classes[] = 'grve-bg-overlay grve-bg-' . $rc_bg_color_overlay;
			if ( !empty ( $rc_bg_opacity_overlay ) ) {
				$overlay_classes[] = 'grve-opacity-' . $rc_bg_opacity_overlay;
			}
			$overlay_string = implode( ' ', $overlay_classes );
			$out_overlay .= '  <div class="' . esc_attr( $overlay_string ) .'"></div>';
		}

		if ( 'custom' == $rc_bg_color_overlay ) {
			$out_overlay .= '  <div class="grve-bg-overlay" style="background-color:' . esc_attr( $rc_bg_color_overlay_custom ) . '"></div>';
		}

		if ( 'gradient' == $rc_bg_color_overlay ) {
			$out_overlay .= '  <div class="grve-bg-overlay" style="background:' . esc_attr( $rc_bg_gradient_overlay_custom_1 ) . '; background: linear-gradient(' . esc_attr( $rc_bg_gradient_overlay_direction ) . 'deg,' . esc_attr( $rc_bg_gradient_overlay_custom_1 ) . ' 0%,' . esc_attr( $rc_bg_gradient_overlay_custom_2 ) . ' 100%);"></div>';
		}
	}
	// Pattern Overlay
	if ( !empty ( $rc_bg_pattern_overlay ) ) {
		$out_pattern .= '  <div class="grve-pattern"></div>';
	}

	//Background Image Classes
	$bg_image_classes = array( 'grve-bg-image' );
	if( 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type || 'horizontal' == $rc_bg_image_type ){
		$bg_image_classes[] = 'grve-bg-center-' . $rc_bg_image_vertical_position;
	}
	if( '' == $rc_bg_image_type || 'none' == $rc_bg_image_type || 'pattern' == $rc_bg_image_type ){
		$bg_image_classes[] = 'grve-bg-' . $rc_bg_position;
		if ( !empty( $rc_bg_tablet_sm_position ) ) {
			$bg_image_classes[] = 'grve-bg-tablet-sm-' . $rc_bg_tablet_sm_position;
		}
	}
	if( $rc_bg_image > 0 ){
		$bg_image_classes[] = 'grve-bg-image-id-' . $rc_bg_image ;
	}
	$bg_image_string = implode( ' ', $bg_image_classes );

	//Background Image
	if ( ( 'image' == $rc_bg_type || ( 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type ) && !empty ( $rc_bg_image )) ) {
		if ( function_exists( 'impeka_grve_option' ) && 'off' != impeka_grve_option( 'image_load_mode' ) ) {
			$img_srcset = impeka_wpb_ext_build_shortcode_img_srcset( $rc_bg_image ,$rc_bg_image_size );
			$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . ' lazyload"  data-bgset="' . esc_attr( $img_srcset )  . '" data-sizes="auto"></div>';
		} else {
			$img_style = impeka_wpb_ext_build_shortcode_img_style( $rc_bg_image ,$rc_bg_image_size );
			$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . '"  ' . $img_style . '></div>';
		}
	}

	//Background Video
	if ( 'hosted_video' == $rc_bg_type && ( !empty ( $rc_bg_video_webm ) || !empty ( $rc_bg_video_mp4 ) || !empty ( $rc_bg_video_ogv ) ) ) {

		$has_video_bg = true;
		$video_poster = $playsinline = '';
		$muted = 'yes';
		if ( wp_is_mobile() ) {
			if ( 'yes' == $rc_bg_video_device ) {
				$video_poster = impeka_wpb_ext_shortcode_img_url( $rc_bg_image ,$rc_bg_image_size );
				$muted = 'yes';
				$playsinline = 'yes';
			} else {
				$has_video_bg = false;
			}
		}
		if ( $has_video_bg ) {
			$video_settings = array(
				'preload' => 'auto',
				'autoplay' => 'yes',
				'loop' => $rc_bg_video_loop,
				'muted' => $muted,
				'poster' => $video_poster,
				'playsinline' => $playsinline,
			);

			$out_video_bg .= '<div class="grve-bg-video grve-html5-bg-video" data-video-device="' . esc_attr( $rc_bg_video_device ) .'">';
			$out_video_bg .=  '<video data-autoplay ' . impeka_grve_print_media_video_settings( $video_settings ) . '>';
			if ( !empty ( $rc_bg_video_webm ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_webm ) . '" type="video/webm">';
			}
			if ( !empty ( $rc_bg_video_mp4 ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_mp4 ) . '" type="video/mp4">';
			}
			if ( !empty ( $rc_bg_video_ogv ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_ogv ) . '" type="video/ogg">';
			}
			$out_video_bg .=  '</video>';
			$out_video_bg .= '</div>';
		}
	}

	//YouTube/Vimeo Video
	$out_video_bg_url = '';
	$has_video_bg = ( 'video' == $rc_bg_type && ! empty( $rc_bg_video_url ) );
	if ( $has_video_bg ) {
		if ( impeka_grve_extract_youtube_id( $rc_bg_video_url ) ) {
			wp_enqueue_script( 'youtube-iframe-api' );
			$out_video_bg_url .= '<div class="grve-bg-video grve-yt-bg-video" data-video-bg-url="' . esc_attr( $rc_bg_video_url ) . '"></div>';
			if ( !empty( $rc_bg_video_button ) ) {
				$out_video_bg_url .= '<a class="grve-video-popup grve-bg-video-button-' . esc_attr( $rc_bg_video_button ) . '" href="' . esc_url( $rc_bg_video_url ) . '">';
				$out_video_bg_url .= impeka_grve_get_video_icon( 'white', $rc_bg_video_button_position );
				$out_video_bg_url .= '</a>';
			}
		} else {
			wp_enqueue_script( 'vimeo-api' );
			$wrapper_attributes = array();
			$wrapper_attributes[] = 'id="' . esc_attr( uniqid('vimeo-') ) . '"';
			$wrapper_attributes[] = 'data-vimeo-url="' . esc_attr( $rc_bg_video_url ) . '"';
			$wrapper_attributes[] = 'data-vimeo-autoplay="true"';
			$wrapper_attributes[] = 'data-vimeo-autopause="false"';
			$wrapper_attributes[] = 'data-vimeo-loop="true"';
			$wrapper_attributes[] = 'data-vimeo-background="true"';
			$wrapper_attributes[] = 'data-vimeo-muted="true"';

			$wrapper_attributes[] = 'class="grve-bg-video grve-vimeo-bg-video"';
			$out_video_bg_url .= '<div '. implode( ' ', $wrapper_attributes ) . '></div>';
			if ( !empty( $rc_bg_video_button ) ) {
				$out_video_bg_url .= '<a class="grve-video-popup grve-bg-video-button-' . esc_attr( $rc_bg_video_button ) . '" href="' . esc_url( $rc_bg_video_url ) . '">';
				$out_video_bg_url .= impeka_grve_get_video_icon( 'white', $rc_bg_video_button_position );
				$out_video_bg_url .= '</a>';
			}
		}
	}

	if( vc_settings()->get( 'not_responsive_css' ) != '1') {

		if ( !empty( $desktop_hide ) ) {
			$column_classes[] = 'grve-desktop-column-' . $desktop_hide;
		}
		if ( !empty( $tablet_width ) ) {
			$column_classes[] = 'grve-tablet-column-' . $tablet_width;
		}
		if ( !empty( $tablet_sm_width ) ) {
			$column_classes[] = 'grve-tablet-sm-column-' . $tablet_sm_width;
		} else {
			if ( !empty( $tablet_width ) ) {
				$column_classes[] = 'grve-tablet-sm-column-' . $tablet_width;
			}
		}
		if ( !empty( $mobile_width ) ) {
			$column_classes[] = 'grve-mobile-column-' . $mobile_width;
		}
	}

	if ( !empty ( $responsive_class ) ) {
		$column_classes[] = $responsive_class;
	}
	if ( $column_effect != 'none' ) {
		$column_classes[] = 'grve-parallax-effect';
	}

	if( $horizontal_content_position != 'left' ) {
		$column_classes[] = 'grve-horizontal-position-' . $horizontal_content_position;
	}

	if( !empty ( $tablet_horizontal_content_position ) ) {
		$column_classes[] = 'grve-tablet-horizontal-position-' . $tablet_horizontal_content_position;
	}

	if( !empty ( $tablet_sm_horizontal_content_position ) ) {
		$column_classes[] = 'grve-tablet-sm-horizontal-position-' . $tablet_sm_horizontal_content_position;
	}

	if( !empty ( $mobile_horizontal_content_position ) ) {
		$column_classes[] = 'grve-mobile-horizontal-position-' . $mobile_horizontal_content_position;
	}

	if( $vertical_content_position != 'top' ) {
		$column_classes[] = 'grve-vertical-position-' . $vertical_content_position;
	}

	if( 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type ){
		$column_classes[] = 'grve-' . $rc_bg_image_type;
		$column_classes[] = 'grve-bg-parallax';
	} else {
		if( !empty ( $rc_bg_type ) ) {
			$column_classes[] = 'grve-with-bg-' . $rc_bg_type;
		} else {
			$column_classes[] = 'grve-with-bg-transparent';
		}
		if( !empty($rc_bg_image_type) ) {
			$column_classes[] = 'grve-bg-' . $rc_bg_image_type;
		}
	}

	if( '100' != $content_width && 'custom' != $content_width ){
		$column_classes[] = 'grve-custom-width-' . $content_width;
	}

	if( !empty ( $tablet_content_width ) ){
		$column_classes[] = 'grve-tablet-custom-width-' . $tablet_content_width;
	}

	if( !empty ( $tablet_sm_content_width ) ){
		$column_classes[] = 'grve-tablet-sm-custom-width-' . $tablet_sm_content_width;
	}

	if( !empty ( $mobile_content_width ) ){
		$column_classes[] = 'grve-mobile-custom-width-' . $mobile_content_width;
	}


	if( 'left' != $text_align ){
		$column_classes[] = 'grve-align-' . $text_align;
	}

	if( !empty ($tablet_text_align) ){
		$column_classes[] = 'grve-tablet-align-' . $tablet_text_align;
	}

	if( !empty ($tablet_sm_text_align) ){
		$column_classes[] = 'grve-tablet-sm-align-' . $tablet_sm_text_align;
	}

	if( !empty ($mobile_text_align) ){
		$column_classes[] = 'grve-mobile-align-' . $mobile_text_align;
	}

	if( !empty ($tablet_column_order) || !empty ($tablet_sm_column_order) || ($mobile_column_order) ){
		$column_classes[] = 'grve-change-order';
	}

	if ( !empty ( $animation ) ) {
		$column_classes[] = 'grve-animated-item';
	}

	if ( 'clipping' == $animation ) {
		$column_classes[] = 'grve-clipping-animation';
	}

	if ( 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation || 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation ) {
		$column_classes[] = 'grve-colored-clipping';
	}

	if ( !empty ( $el_class ) ) {
		$column_classes[] = $el_class;
	}

	if( empty( $column_content ) ) {
		$column_classes[] =  'grve-empty-column';
	}

	if ( !empty( $add_column_link ) && impeka_wpb_ext_has_link( $column_link ) ) {
		$column_classes[] =  'grve-with-link';
	}

	$column_string = implode( ' ', $column_classes );

	$wrapper_attributes = array();
	$wrapper_attributes[] = 'class="' . esc_attr( $column_string ) . '"';

	$css_style = impeka_wpb_ext_build_shortcode_style(
		array(
			'font_color' => $rc_font_color,
		)
	);

	if ( ! empty( $el_id ) ) {
		$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	}

	if( !empty( $css_style ) ) {
		$wrapper_attributes[] = $css_style;
	}

	if( 'parallax' == $rc_bg_image_type || 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type ){
		$wrapper_attributes[] = 'data-parallax-threshold="' . esc_attr( $rc_bg_parallax_threshold ) . '"';
	}


	if ( !empty ( $animation ) ) {
		$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
		$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
	}

	if ( !empty ( $animation ) && 'clipping' != $animation ) {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	} else if ( !empty ( $animation ) && 'clipping' == $animation ) {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $clipping_animation ) . '"';
	}

	if ( 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation || 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation ) {
		$wrapper_attributes[] = ' data-clipping-color="' . esc_attr( $clipping_animation_colors ) . '"';
	}

	// Column Effect
	switch( $column_effect ) {
		case 'vertical-parallax':
			$wrapper_attributes[] = 'data-parallax-effect="vertical-parallax"';
			if ( $tablet_landscape_column_effect == 'none' ) {
				$wrapper_attributes[] = 'data-tablet-landscape-parallax-effect="none"';
			}
			if ( $tablet_portrait_column_effect == 'none' ) {
				$wrapper_attributes[] = 'data-tablet-portrait-parallax-effect="none"';
			}
			if ( $mobile_column_effect == 'none' ) {
				$wrapper_attributes[] = 'data-mobile-parallax-effect="none"';
			}
			break;
		case 'mouse-move-x-y':
			$wrapper_attributes[] = 'data-parallax-effect="mouse-move"';
			$wrapper_attributes[] = 'data-mouse-move="x-y"';
			$wrapper_attributes[] = 'data-sensitive="' . esc_attr( $column_effect_sensitive ) . '"';
			$wrapper_attributes[] = 'data-invert="' . esc_attr( $column_effect_invert ) . '"';
			break;
		case 'mouse-move-x':
			$wrapper_attributes[] = 'data-parallax-effect="mouse-move"';
			$wrapper_attributes[] = 'data-mouse-move="x"';
			$wrapper_attributes[] = 'data-sensitive="' . esc_attr( $column_effect_sensitive ) . '"';
			$wrapper_attributes[] = 'data-invert="' . esc_attr( $column_effect_invert ) . '"';
			break;
		case 'mouse-move-y':
			$wrapper_attributes[] = 'data-parallax-effect="mouse-move"';
			$wrapper_attributes[] = 'data-mouse-move="y"';
			$wrapper_attributes[] = 'data-sensitive="' . esc_attr( $column_effect_sensitive ) . '"';
			$wrapper_attributes[] = 'data-invert="' . esc_attr( $column_effect_invert ) . '"';
			break;
		default:
			break;
	}

	// Column Order
	if( !empty ($tablet_column_order) ){
		$wrapper_attributes[] = ' data-tablet-order="' . esc_attr( $tablet_column_order ) . '"';
	}

	if( !empty ($tablet_sm_column_order) ){
		$wrapper_attributes[] = ' data-tablet-sm-order="' . esc_attr( $tablet_sm_column_order ) . '"';
	}

	if( !empty ($mobile_column_order) ){
		$wrapper_attributes[] = ' data-mobile-order="' . esc_attr( $mobile_column_order ) . '"';
	}

	$column_wrapper_classes = array( 'grve-column-wrapper' );
	if ( !empty( $css_custom ) ) {
		$column_wrapper_classes[] = $css_custom;
	}

	if ( !empty ( $el_wrapper_class ) ) {
		$column_wrapper_classes[] = $el_wrapper_class;
	}

	if ( 'yes' == $column_sticky ) {
		$column_wrapper_classes[] = 'grve-sticky-element';
		$column_wrapper_classes[] = 'grve-sticky-column';
	}

	if( 'no' != $rc_add_shadow ){
		$column_wrapper_classes[] = 'grve-' . $rc_add_shadow;
	}

	if ( !empty ( $hover_animation ) ) {
		$column_wrapper_classes[] = 'grve-hover-animation-wrapper';
	}

	$column_wrapper_string = implode( ' ', $column_wrapper_classes );


	//Column wrapper
	$column_wrapper_attributes = array();
	$column_wrapper_attributes[] = 'class="' . esc_attr( $column_wrapper_string ) . '"';
	if ( 'gradient' != $rc_bg_type ) {
		$rc_bg_gradient_color_1 = $rc_bg_gradient_color_2 = $rc_bg_gradient_direction = "";
	}
	if ( 'gradient' == $rc_bg_type || 'animated-color' == $rc_bg_type ) {
		$rc_bg_color = "";
	}

	if ( 'animated-color' == $rc_bg_type ) {
		$rc_bg_color = $rc_bg_animated_color_1;
		if ( !empty ( $rc_bg_animated_color_1 ) ) {
			$column_wrapper_attributes[] = 'data-first-color="' . esc_attr( $rc_bg_animated_color_1 ) . '"';
		}
		if ( !empty ( $rc_bg_animated_color_2 ) ) {
			$column_wrapper_attributes[] = 'data-second-color="' . esc_attr( $rc_bg_animated_color_2 ) . '"';
		}
	}

	if ( !empty ( $column_sticky_offset ) && 'yes' == $column_sticky ) {
		$column_wrapper_attributes[] = 'data-sticky-offset="' . esc_attr( $column_sticky_offset ) . '"';
	}

	$column_style = impeka_wpb_ext_build_shortcode_style(
		array(
			'bg_color' => $rc_bg_color,
			'bg_gradient_color_1' => $rc_bg_gradient_color_1,
			'bg_gradient_color_2' => $rc_bg_gradient_color_2,
			'bg_gradient_direction' => $rc_bg_gradient_direction,
		)
	);
	if( !empty( $column_style ) ) {
		$column_wrapper_attributes[] = $column_style;
	}

	$content_attributes = array();
	$content_style = impeka_wpb_ext_build_shortcode_style(
		array(
			'content_width' => $content_width,
			'custom_content_width' => $custom_content_width,
		)
	);

	if( !empty( $content_style ) ) {
		$content_attributes[] = $content_style;
	}



	$wrapper_attributes = apply_filters( 'impeka_grve_column_wrapper_attributes', $wrapper_attributes , $atts );

	$grve_css_styles = impeka_wpb_ext_design_styles( $grve_css, 'grve-column-wrapper' );
	if( impeka_wpb_ext_is_page_editable() && !empty( $grve_css_styles )) {
		echo '<style>'. wp_kses_post($grve_css_styles) . '</style>';
	}

	//Column link
	$link_class_string = 'grve-column-link ' . esc_attr( $column_link_class );
	$link_attributes = impeka_wpb_ext_get_link_attributes( $column_link, $link_class_string );

	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div ' . implode( ' ', $column_wrapper_attributes ) . '>';
	echo '<div class="grve-column-content" ' . implode( ' ', $content_attributes ) . '>' . $column_content . '</div>';
	if ( !empty( $add_column_link ) && impeka_wpb_ext_has_link( $column_link ) ) {
		echo '<a ' . implode( ' ', $link_attributes ) . '></a>';
	}
	if ( 'image' == $rc_bg_type || 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type  ) {
	echo '<div class="grve-background-wrapper">' . $out_image_bg . $out_video_bg_url . $out_video_bg . $out_overlay . $out_pattern . '</div>';
	}
	echo '</div>';
	echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
