<?php

	$output = $out_pattern = $out_overlay = $out_image_bg = $out_video_bg = '';

	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
	extract( $atts );

	//Color Overlay
	if ( 'image' == $rc_bg_type || 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type  ) {

		if ( 'none' != $rc_bg_color_overlay && 'custom' != $rc_bg_color_overlay && 'gradient' != $rc_bg_color_overlay  ) {

			//Overlay Classes
			$overlay_classes = array();
			$overlay_classes[] = 'grve-bg-overlay grve-bg-' . $rc_bg_color_overlay;
			if ( !empty ( $rc_bg_opacity_overlay ) ) {
				$overlay_classes[] = 'grve-opacity-' . $rc_bg_opacity_overlay;
			}
			$overlay_string = implode( ' ', $overlay_classes );
			$out_overlay .= '  <div class="' . esc_attr( $overlay_string ) .'"></div>';
		}

		if ( 'custom' == $rc_bg_color_overlay ) {
			$out_overlay .= '  <div class="grve-bg-overlay" style="background-color:' . esc_attr( $rc_bg_color_overlay_custom ) . '"></div>';
		}

		if ( 'gradient' == $rc_bg_color_overlay ) {
			$out_overlay .= '  <div class="grve-bg-overlay" style="background:' . esc_attr( $rc_bg_gradient_overlay_custom_1 ) . '; background: linear-gradient(' . esc_attr( $rc_bg_gradient_overlay_direction ) . 'deg,' . esc_attr( $rc_bg_gradient_overlay_custom_1 ) . ' 0%,' . esc_attr( $rc_bg_gradient_overlay_custom_2 ) . ' 100%);"></div>';
		}
	}
	// Pattern Overlay
	if ( !empty ( $rc_bg_pattern_overlay ) ) {
		$out_pattern .= '  <div class="grve-pattern"></div>';
	}

	//Background Image Classes
	$bg_image_classes = array( 'grve-bg-image' );
	if( 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type || 'horizontal' == $rc_bg_image_type ){
		$bg_image_classes[] = 'grve-bg-center-' . $rc_bg_image_vertical_position;
	}
	if( '' == $rc_bg_image_type || 'none' == $rc_bg_image_type || 'pattern' == $rc_bg_image_type ){
		$bg_image_classes[] = 'grve-bg-' . $rc_bg_position;
		if ( !empty( $rc_bg_tablet_sm_position ) ) {
			$bg_image_classes[] = 'grve-bg-tablet-sm-' . $rc_bg_tablet_sm_position;
		}
	}
	if( $rc_bg_image > 0 ){
		$bg_image_classes[] = 'grve-bg-image-id-' . $rc_bg_image ;
	}
	$bg_image_string = implode( ' ', $bg_image_classes );

	//Background Image
	if ( ( 'image' == $rc_bg_type || ( 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type ) && !empty ( $rc_bg_image )) ) {
		if ( function_exists( 'impeka_grve_option' ) && 'off' != impeka_grve_option( 'image_load_mode' ) ) {
			$img_srcset = impeka_wpb_ext_build_shortcode_img_srcset( $rc_bg_image ,$rc_bg_image_size );
			$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . ' lazyload"  data-bgset="' . esc_attr( $img_srcset )  . '" data-sizes="auto"></div>';
		} else {
			$img_style = impeka_wpb_ext_build_shortcode_img_style( $rc_bg_image ,$rc_bg_image_size );
			$out_image_bg .= '  <div class="' . esc_attr( $bg_image_string ) . '"  ' . $img_style . '></div>';
		}
	}

	//Background Video
	if ( 'hosted_video' == $rc_bg_type && ( !empty ( $rc_bg_video_webm ) || !empty ( $rc_bg_video_mp4 ) || !empty ( $rc_bg_video_ogv ) ) ) {

		$has_video_bg = true;
		$video_poster = $playsinline = '';
		$muted = 'yes';
		if ( wp_is_mobile() ) {
			if ( 'yes' == $rc_bg_video_device ) {
				$video_poster = impeka_wpb_ext_shortcode_img_url( $rc_bg_image ,$rc_bg_image_size );
				$muted = 'yes';
				$playsinline = 'yes';
			} else {
				$has_video_bg = false;
			}
		}
		if ( $has_video_bg ) {
			$video_settings = array(
				'preload' => 'auto',
				'autoplay' => 'yes',
				'loop' => $rc_bg_video_loop,
				'muted' => $muted,
				'poster' => $video_poster,
				'playsinline' => $playsinline,
			);

			$out_video_bg .= '<div class="grve-bg-video grve-html5-bg-video" data-video-device="' . esc_attr( $rc_bg_video_device ) .'">';
			$out_video_bg .=  '<video data-autoplay ' . impeka_grve_print_media_video_settings( $video_settings ) . '>';
			if ( !empty ( $rc_bg_video_webm ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_webm ) . '" type="video/webm">';
			}
			if ( !empty ( $rc_bg_video_mp4 ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_mp4 ) . '" type="video/mp4">';
			}
			if ( !empty ( $rc_bg_video_ogv ) ) {
				$out_video_bg .=  '<source src="' . esc_url( $rc_bg_video_ogv ) . '" type="video/ogg">';
			}
			$out_video_bg .=  '</video>';
			$out_video_bg .= '</div>';
		}
	}

	//YouTube/Vimeo Video
	$out_video_bg_url = '';
	$has_video_bg = ( 'video' == $rc_bg_type && ! empty( $rc_bg_video_url ) );
	if ( $has_video_bg ) {
		if ( impeka_grve_extract_youtube_id( $rc_bg_video_url ) ) {
			wp_enqueue_script( 'youtube-iframe-api' );
			$out_video_bg_url .= '<div class="grve-bg-video grve-yt-bg-video" data-video-bg-url="' . esc_attr( $rc_bg_video_url ) . '"></div>';
			if ( !empty( $rc_bg_video_button ) ) {
				$out_video_bg_url .= '<a class="grve-video-popup grve-bg-video-button-' . esc_attr( $rc_bg_video_button ) . '" href="' . esc_url( $rc_bg_video_url ) . '">';
				$out_video_bg_url .= impeka_grve_get_video_icon( 'white', $rc_bg_video_button_position );
				$out_video_bg_url .= '</a>';
			}
		} else {
			wp_enqueue_script( 'vimeo-api' );
			$wrapper_attributes = array();
			$wrapper_attributes[] = 'id="' . esc_attr( uniqid('vimeo-') ) . '"';
			$wrapper_attributes[] = 'data-vimeo-url="' . esc_attr( $rc_bg_video_url ) . '"';
			$wrapper_attributes[] = 'data-vimeo-autoplay="true"';
			$wrapper_attributes[] = 'data-vimeo-autopause="false"';
			$wrapper_attributes[] = 'data-vimeo-loop="true"';
			$wrapper_attributes[] = 'data-vimeo-background="true"';
			$wrapper_attributes[] = 'data-vimeo-muted="true"';

			$wrapper_attributes[] = 'class="grve-bg-video grve-vimeo-bg-video"';
			$out_video_bg_url .= '<div '. implode( ' ', $wrapper_attributes ) . '></div>';
			if ( !empty( $rc_bg_video_button ) ) {
				$out_video_bg_url .= '<a class="grve-video-popup grve-bg-video-button-' . esc_attr( $rc_bg_video_button ) . '" href="' . esc_url( $rc_bg_video_url ) . '">';
				$out_video_bg_url .= impeka_grve_get_video_icon( 'white', $rc_bg_video_button_position );
				$out_video_bg_url .= '</a>';
			}
		}
	}

	//Section Classses
	$section_classes = array( 'grve-inner-section' );

	if ( 'yes' === $disable_element ) {
		if ( vc_is_page_editable() ) {
			$section_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
		} else {
			return '';
		}
	}

	// Extra Class
	if ( !empty ( $el_class ) ) {
		$section_classes[] = $el_class;
	}

	// Height
	if( 'auto' != $height_ratio ){
		$section_classes[] = 'grve-percentage-height';
	}

	// Padding
	if ( !empty ( $padding_top_multiplier ) && 'custom' != $padding_top_multiplier  ) {
		$section_classes[] = 'grve-padding-top-' . $padding_top_multiplier;
	} else if( 'custom' != $padding_top_multiplier ) {
		$padding_top ="";
	}
	if ( !empty ( $padding_bottom_multiplier ) && 'custom' != $padding_bottom_multiplier ) {
		$section_classes[] = 'grve-padding-bottom-' . $padding_bottom_multiplier;
	} else if( 'custom' != $padding_bottom_multiplier ) {
		$padding_bottom ="";
	}

	// Headings
	if ( 'default' != $rc_heading_color ) {
		$section_classes[] = 'grve-headings-' . $rc_heading_color;
	}

	if( empty ( $rc_link_color ) ) {
		$rc_link_color = 'default';
	}

	if( empty ( $rc_link_hover_color ) ) {
		$rc_link_hover_color = 'default';
	}

	// Links
	if( 'default' != $rc_link_color || 'default' != $rc_link_hover_color ) {
		$section_classes[] = 'grve-link-' . $rc_link_color;
		$section_classes[] = 'grve-link-hover-' . $rc_link_hover_color;
	}

	//Background
	if( 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type ){
		$section_classes[] = 'grve-' . $rc_bg_image_type;
		$section_classes[] = 'grve-bg-parallax';
	} else {
		if( !empty ( $rc_bg_type ) ) {
			$section_classes[] = 'grve-with-bg-' . $rc_bg_type;
		} else {
			$section_classes[] = 'grve-with-bg-transparent';
		}
		if( !empty($rc_bg_image_type) ) {
			$section_classes[] = 'grve-bg-' . $rc_bg_image_type;
		}
	}

	// Equal Columns
	if( 'equal' == $equal_column_height ) {
		$section_classes[] = 'grve-equal-columns';
	}
	if( !empty ($tablet_landscape_equal_column_height) ){
		$section_classes[] = 'grve-tablet-landscape-not-equal-columns';
	}
	if( !empty ($tablet_portrait_equal_column_height) ){
		$section_classes[] = 'grve-tablet-portrait-not-equal-columns';
	}

	// Visibility
	if( vc_settings()->get( 'not_responsive_css' ) != '1') {
		if ( !empty( $desktop_visibility ) ) {
			$section_classes[] = 'grve-desktop-row-hide';
		}
		if ( !empty( $tablet_visibility ) ) {
			$section_classes[] = 'grve-tablet-row-hide';
		}
		if ( !empty( $tablet_sm_visibility ) ) {
			$section_classes[] = 'grve-tablet-sm-row-hide';
		}
		if ( !empty( $mobile_visibility ) ) {
			$section_classes[] = 'grve-mobile-row-hide';
		}
	}


	if( 'no' != $rc_add_shadow ){
		$section_classes[] = 'grve-' . $rc_add_shadow;
	}

	$section_string = implode( ' ', $section_classes );

	// Wrapper
	$wrapper_attributes = array();

	if ( !empty ( $el_id ) ) {
		$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	}
	$wrapper_attributes[] = 'class="' . esc_attr( $section_string ) . '"';

	// Parallax
	if( 'parallax' == $rc_bg_image_type || 'horizontal-parallax-lr' == $rc_bg_image_type || 'horizontal-parallax-rl' == $rc_bg_image_type ){
		$wrapper_attributes[] = 'data-parallax-threshold="' . esc_attr( $rc_bg_parallax_threshold ) . '"';
	}

	// Height Ratio
	if( 'auto' != $height_ratio ){
		$wrapper_attributes[] = 'data-height-ratio="' . esc_attr( $height_ratio ) . '"';
	}
	if( 'inherit' != $tablet_height_ratio ){
		$wrapper_attributes[] = 'data-tablet-height-ratio="' . esc_attr( $tablet_height_ratio ) . '"';
	}
	if( 'inherit' != $tablet_sm_height_ratio ){
		$wrapper_attributes[] = 'data-tablet-sm-height-ratio="' . esc_attr( $tablet_sm_height_ratio ) . '"';
	}
	if( 'inherit' != $mobile_height_ratio ){
		$wrapper_attributes[] = 'data-mobile-height-ratio="' . esc_attr( $mobile_height_ratio ) . '"';
	}

	if ( 'gradient' != $rc_bg_type ) {
		$rc_bg_gradient_color_1 = $rc_bg_gradient_color_2 = $rc_bg_gradient_direction = "";
	}
	if ( 'gradient' == $rc_bg_type || 'animated-color' == $rc_bg_type ) {
		$rc_bg_color = "";
	}

	if ( 'animated-color' == $rc_bg_type ) {
		$rc_bg_color = $rc_bg_animated_color_1;
		if ( !empty ( $rc_bg_animated_color_1 ) ) {
			$wrapper_attributes[] = 'data-first-color="' . esc_attr( $rc_bg_animated_color_1 ) . '"';
		}
		if ( !empty ( $rc_bg_animated_color_2 ) ) {
			$wrapper_attributes[] = 'data-second-color="' . esc_attr( $rc_bg_animated_color_2 ) . '"';
		}
	}

	$css_style = impeka_wpb_ext_build_shortcode_style(
		array(
			'bg_color' => $rc_bg_color,
			'bg_gradient_color_1' => $rc_bg_gradient_color_1,
			'bg_gradient_color_2' => $rc_bg_gradient_color_2,
			'bg_gradient_direction' => $rc_bg_gradient_direction,
			'font_color' => $rc_font_color,
			'padding_top' => $padding_top,
			'padding_bottom' => $padding_bottom,
			'margin_bottom' => $rc_margin_bottom,
		)
	);

	if( !empty( $css_style ) ) {
		$wrapper_attributes[] = $css_style;
	}

	// Row Classes
	$row_classes = array( 'grve-row-inner', 'grve-bookmark' );
	if( !empty( $columns_gap ) ) {
		$row_classes[] = 'grve-columns-gap-' . $columns_gap;
	}
	if( 'none' != $tablet_columns_vertical_gap ) {
		$row_classes[] = 'grve-tablet-vertical-gap-' . $tablet_columns_vertical_gap;
	}
	if( 'none' != $tablet_sm_columns_vertical_gap ) {
		$row_classes[] = 'grve-tablet-sm-vertical-gap-' . $tablet_sm_columns_vertical_gap;
	}
	if( 'none' != $mobile_columns_vertical_gap ) {
		$row_classes[] = 'grve-mobile-vertical-gap-' . $mobile_columns_vertical_gap;
	}

	if( 'auto' != $height_ratio ){
		$row_classes[] = 'grve-percentage-content';
	}

	if ( !empty ( $el_wrapper_class ) ) {
		$row_classes[] = $el_wrapper_class;
	}

	if ( 'yes' == $rtl_reverse ) {
		$row_classes[] = 'grve-rtl-columns-reverse';
	}

	$row_css_string = implode( ' ', $row_classes );

	$wrapper_attributes = apply_filters( 'impeka_grve_row_inner_wrapper_attributes', $wrapper_attributes , $atts );

	//Section Output
	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div class="' . esc_attr( $row_css_string ) . '">' . do_shortcode( $content ) . '</div>';
	if ( 'image' == $rc_bg_type || 'hosted_video' == $rc_bg_type || 'video' == $rc_bg_type  ) {
		echo '<div class="grve-background-wrapper">' . $out_image_bg . $out_video_bg_url . $out_video_bg . $out_overlay . $out_pattern . '</div>';
	}
	echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
