<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $content - shortcode content
 * @var $this WPBakeryShortCode_VC_Tta_Accordion|WPBakeryShortCode_VC_Tta_Tabs|WPBakeryShortCode_VC_Tta_Tour|WPBakeryShortCode_VC_Tta_Pageable
 */
$el_class = $css = $css_animation = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$this->resetVariables( $atts, $content );
$isPageEditable = vc_is_page_editable();
extract( $atts );

if ( 'vc_tta_tabs' == $this->shortcode || 'vc_tta_tour' == $this->shortcode ) {

	$this->setGlobalTtaInfo();
	$prepareContent = $this->getTemplateVariable( 'content' );
	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
	$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );
	$active_section = $this->getActiveSection( $atts, false );

	$heading = impeka_wpb_ext_array_value( $atts, 'heading', 'h3' );
	$heading_tag = impeka_wpb_ext_array_value( $atts, 'heading_tag', 'h6' );
	$custom_font_family = impeka_wpb_ext_array_value( $atts, 'custom_font_family' );
	$el_id = impeka_wpb_ext_array_value( $atts, 'el_id' );

	$wrapper_attributes = array();
	if ( ! empty( $el_id ) ) {
		$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	}
	if ( 'vc_tta_tabs' == $this->shortcode ) {
		$wrapper_attributes[] = 'class="grve-element grve-tab grve-horizontal-tab ' . esc_attr( $css_class ) . '"';
	} else {
		$wrapper_attributes[] = 'class="grve-element grve-tab grve-vertical-tab grve-tab-position-' . esc_attr( $tab_position ) . ' ' . esc_attr( $css_class ) . '"';
	}

	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

	$title_classes = array( 'grve-title' );
	if ( !empty( $custom_font_family ) ) {
		$title_classes[] ='grve-' . $custom_font_family;
	}
	$title_classes[] ='grve-' . $heading;
	$title_class_string = implode( ' ', $title_classes );

	$tabs_title_classes = array( 'grve-tabs-title' );
	$tabs_title_classes[] = "grve-align-" . $alignment;
	if( 'yes' == $tab_go_top ) {
		$tabs_title_classes[] = "grve-tabs-go-top" ;
	}
	if( 'yes' == $tab_collapse_all ) {
		$tabs_title_classes[] = "grve-tabs-collapse" ;
	}
	if ( 'vc_tta_tour' == $this->shortcode ) {
		if( empty( $controls_size ) ) {
			$controls_size = "md";
		}
		$tabs_title_classes[] = "grve-width-" . $controls_size ;
		if( empty( $tab_position ) ) {
			$tab_position = "left";
		}
	}
	$tabs_title_class_string = implode( ' ', $tabs_title_classes );

	//Tabs Top Title Wrapper
	echo '<div class="' . esc_attr( $tabs_title_class_string ) . '">';
	foreach ( WPBakeryShortCode_VC_Tta_Section::$section_info as $nth => $section ) {
		$classes = array( 'grve-tab-title', 'grve-tab-link' );
		if ( ( $nth + 1 ) === $active_section ) {
			$classes[] = 'active';
		}
		$classes[] = 'grve-icon-position-' . esc_attr( $section['i_position'] );
		$icon_html = '';
		if ( 'true' === $section['add_icon'] ) {
			$icon_html = '<span class="grve-tab-icon">';
			$icon_html .= impeka_wpb_ext_construct_icon( $section );
			$icon_html .= '</span>';
		}
		$title = '<' . tag_escape( $heading_tag ) .' class="' . esc_attr( $title_class_string ) . '">' . $icon_html . $section['title'] . '</' . tag_escape( $heading_tag ) .'>';
		echo '<div class="' . implode( ' ', $classes ) . '" data-rel="#' . $section['tab_id'] . '">';
		echo '<div class="grve-tab-title-inner">';
		echo $title;
		echo '</div>';
		echo '</div>';
	}
	echo '</div>';


	//Tabs Wrapper
	echo '<div class="grve-tabs-wrapper grve-align-' . esc_attr( $alignment ) . '">';

	foreach ( WPBakeryShortCode_VC_Tta_Section::$section_info as $nth => $section ) {

		$content_classes = array( 'grve-tab-content' );
		if ( ( $nth + 1 ) === $active_section ) {
			$content_classes[] = 'active';
		}
		if ( isset( $section['el_class'] ) ) {
			$content_classes[] = $section['el_class'];
		}
		$content_classes_string = implode( ' ', array_filter( $content_classes ) );

		echo '<div class="grve-tab-section">';

		$classes = array( 'grve-tab-title', 'grve-responsive-tab-link' );
		if ( ( $nth + 1 ) === $active_section ) {
			$classes[] = 'active';
		}
		$classes[] = 'grve-icon-position-' . esc_attr( $section['i_position'] );
		$icon_html = '';
		if ( 'true' === $section['add_icon'] ) {
			$icon_html = '<span class="grve-tab-icon">';
			$icon_html .= impeka_wpb_ext_construct_icon( $section );
			$icon_html .= '</span>';
		}
		$title = '<' . tag_escape( $heading_tag ) .' class="' . esc_attr( $title_class_string ) . '">' . $icon_html . $section['title'] . '</' . tag_escape( $heading_tag ) .'>';
		echo '<div class="' . implode( ' ', $classes ) . '" data-rel="#' . $section['tab_id'] . '">';
		echo '<div class="grve-tab-title-inner">';
		echo $title;
		echo '</div>';
		echo '</div>';
		echo '<div class="' . esc_attr( $content_classes_string ) . '" id="' . esc_attr( $section['tab_id'] ) . '">';
		if ( $isPageEditable ) {
			echo '<div data-js-panel-body>';
		}
		echo do_shortcode( $section['content'] );
		if ( $isPageEditable ) {
			echo '</div>';
		}
		echo '</div>';

		echo '</div>'; // End Tab Section

	}

	echo '</div>';
	echo '</div>';

} elseif ( 'vc_tta_accordion' == $this->shortcode ) {

	$this->setGlobalTtaInfo();
	$prepareContent = $this->getTemplateVariable( 'content' );
	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
	$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );
	$active_section = $this->getActiveSection( $atts, false );
	$heading = impeka_wpb_ext_array_value( $atts, 'heading', 'h3' );
	$heading_tag = impeka_wpb_ext_array_value( $atts, 'heading_tag', 'h6' );
	$custom_font_family = impeka_wpb_ext_array_value( $atts, 'custom_font_family' );
	$el_id = impeka_wpb_ext_array_value( $atts, 'el_id' );

	$title_classes = array( 'grve-title' );
	if ( !empty( $custom_font_family ) ) {
		$title_classes[] ='grve-' . $custom_font_family;
	}
	$title_classes[] ='grve-' . $heading;
	$title_class_string = implode( ' ', $title_classes );

	$css_accordion_class = array();
	if ( isset( $atts['collapsible_all'] ) && 'true' === $atts['collapsible_all'] ) {
		$css_accordion_class[] = "grve-accordion-wrapper";
		$css_accordion_class[] = "grve-action-toggle";
	} else {
		$css_accordion_class[] = "grve-accordion-wrapper";
		$css_accordion_class[] = "grve-action-accordion";
	}

	if( 'yes' == $accordion_go_top ) {
		$css_accordion_class[] = "grve-accordion-go-top" ;
	}
	if ( isset( $atts['c_icon'] ) && strlen( $atts['c_icon'] ) > 0 ) {
		$css_accordion_class[] = "grve-with-icon";
	}
	$css_accordion_class_string = implode( ' ', $css_accordion_class );

	if ( !isset( $atts['c_align'] ) || empty( $atts['c_align'] ) ) {
		$atts['c_align'] = "left";
	}

	$wrapper_attributes = array();
	$wrapper_attributes[] = 'class="grve-element grve-accordion ' . esc_attr( $css_class ) . '"';
	if ( ! empty( $el_id ) ) {
		$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	}

	echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<ul class="' . esc_attr( $css_accordion_class_string ) . '">';
	foreach ( WPBakeryShortCode_VC_Tta_Section::$section_info as $nth => $section ) {
		$classesTitle = array( 'grve-title-wrapper', 'grve-tab-link' );
		$classesTitle[] = "grve-align-" . $atts['c_align'];
		$classesTitle[] = "grve-icon-position-" . $atts['c_position'];
		$classesContent = array( 'grve-accordion-content' );
		if ( ( $nth + 1 ) === $active_section ) {
			$classesTitle[] = 'active';
			$classesContent[] = 'active';
		}
		if ( isset( $section['el_class'] ) ) {
			$classesContent[] = $section['el_class'];
		}
		$title_wrapper = '';
		$title_wrapper .= '<div class="' . implode( ' ', $classesTitle ) . '" data-rel="#' . esc_attr( $section['tab_id'] ) . '">';
		if ( isset( $atts['c_icon'] ) && strlen( $atts['c_icon'] ) > 0 ) {

			if ( !isset( $atts['c_position'] ) || empty( $atts['c_position'] ) ) {
				$atts['c_position'] = "left";
			}

			if( 'triangle' == $atts['c_icon'] ) {
				$title_wrapper .= '<div class="grve-accordion-arrow grve-svg-heading-color grve-accordion-triangle">' . impeka_wpb_ext_get_svg_icon( 'arrow-triangle-down' ) . '</div>';
			} elseif( 'chevron' == $atts['c_icon'] ) {
				$title_wrapper .= '<div class="grve-accordion-arrow grve-svg-heading-color grve-accordion-chevron">' . impeka_wpb_ext_get_svg_icon( 'arrow-small-down' ) . '</div>';
			} else {
				$title_wrapper .= '<div class="grve-accordion-arrow grve-svg-heading-color grve-accordion-plus">' . impeka_wpb_ext_get_svg_icon( 'plus' ) . '</div>';
			}
		}

		$icon_html = '';
		if ( 'true' === $section['add_icon'] ) {
			if ( 'left' === $section['i_position'] ) {
				$icon_html = '<span class="grve-accordion-icon grve-position-left">';
				$icon_html .= impeka_wpb_ext_construct_icon( $section );
				$icon_html .= '</span>';
			} else {
				$icon_html = '<span class="grve-accordion-icon grve-position-right">';
				$icon_html .= impeka_wpb_ext_construct_icon( $section );
				$icon_html .= '</span>';
			}
		}
		$title = '<' . tag_escape( $heading_tag ) .' class="' . esc_attr( $title_class_string ) . '">' . $icon_html . $section['title'] . '</' . tag_escape( $heading_tag ) .'>';
		$title_wrapper .= $title ;
		$title_wrapper .= '</div>';

		$content = '';
		$content .= '<div class="' . implode( ' ', $classesContent ) . '" id="' . esc_attr( $section['tab_id'] ) . '">';
		if ( $isPageEditable ) {
			$content .= '<div data-js-panel-body>';
		}
		$content .= do_shortcode( $section['content'] );
		if ( $isPageEditable ) {
			$content .= '</div>';
		}
		$content .= '</div>';

		$a_html = '';
		$a_html .= $title_wrapper;
		$a_html .= $content;
		echo '<li>' . $a_html . '</li>';

	}
	echo '</ul>';
	echo '</div>';

} else {

	$this->setGlobalTtaInfo();

	$this->enqueueTtaStyles();
	$this->enqueueTtaScript();

	// It is required to be before tabs-list-top/left/bottom/right for tabs/tours
	$prepareContent = $this->getTemplateVariable( 'content' );

	$class_to_filter = $this->getTtaGeneralClasses();
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );
	$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );

	echo '<div ' . $this->getWrapperAttributes() . '>' . $this->getTemplateVariable( 'title' );
	echo '<div class="' . esc_attr( $css_class ) . '">' . $this->getTemplateVariable( 'tabs-list-top' ) . $this->getTemplateVariable( 'tabs-list-left' );
	echo '<div class="vc_tta-panels-container">' . $this->getTemplateVariable( 'pagination-top' );
	echo '<div class="vc_tta-panels">' . $prepareContent . '</div>' . $this->getTemplateVariable( 'pagination-bottom' );
	echo '</div>' . $this->getTemplateVariable( 'tabs-list-bottom' ) . $this->getTemplateVariable( 'tabs-list-right' ) . '</div>';
	echo '</div>';

}

//Omit closing PHP tag to avoid accidental whitespace output errors.

