<?php
/*
Plugin Name: Elfsight Facebook Reviews CC
Description: Display your Facebook reviews on the website and increase social trust
Plugin URI: https://elfsight.com/facebook-reviews-widget/codecanyon/?utm_source=markets&utm_medium=codecanyon&utm_campaign=facebook-reviews&utm_content=plugin-site
Version: 1.2.4
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=facebook-reviews&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');
require_once('api/api.php');

$elfsight_facebook_reviews_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_facebook_reviews_config = json_decode(file_get_contents($elfsight_facebook_reviews_config_path), true);

new ElfsightFacebookReviewsApi\Api(
	array(
		'plugin_slug' => 'elfsight-facebook-reviews',
		'plugin_file' => __FILE__,
		'cache_time' => 21600,
		'editor_config' => &$elfsight_facebook_reviews_config
	)
);

new ElfsightFacebookReviewsPlugin(
    array(
        'name' => esc_html__('Facebook Reviews'),
        'description' => esc_html__('Display your Facebook reviews on the website and increase social trust'),
        'slug' => 'elfsight-facebook-reviews',
        'version' => '1.2.4',
        'text_domain' => 'elfsight-facebook-reviews',
        'editor_settings' => $elfsight_facebook_reviews_config['settings'],
        'editor_preferences' => $elfsight_facebook_reviews_config['preferences'],

        'plugin_name' => esc_html__('Elfsight Facebook Reviews'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),
        'menu_icon' => plugins_url('assets/img/menu-icon.svg', __FILE__),

        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),
        'product_url' => esc_url('https://codecanyon.net/item/facebook-reviews-wordpress-facebook-reviews-plugin/23558209?ref=Elfsight')
    )
);

?>
