<?php
/*
 * Plugin Name: Impeka Elementor Extension
 * Description: This plugin extends Elementor and adds custom elements.
 * Author: Greatives Team
 * Author URI: https://greatives.eu
 * Version: 1.3.6
 * Text Domain: impeka-elementor-extension
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'IMPEKA_ELEMENTOR_EXT_VERSION' ) ) {
	define( 'IMPEKA_ELEMENTOR_EXT_VERSION', '1.3.6' );
}

if ( ! defined( 'IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH' ) ) {
	define( 'IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL' ) ) {
	define( 'IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( defined( 'ELEMENTOR_VERSION' ) ) {
	require_once IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'includes/impeka-elementor-ext-templates.php';
}

if ( ! class_exists( 'Impeka_Elementor_Extension_Plugin' ) ) {

	class Impeka_Elementor_Extension_Plugin {


		const MINIMUM_ELEMENTOR_VERSION = '3.1.0';
		const MINIMUM_PHP_VERSION = '7.0';

		/**
		 * @action plugins_loaded
		 * @return Impeka_Elementor_Extension_Plugin
		 * @static
		 */
		public static function init()
		{

			static $instance = false;

			if ( ! $instance ) {
				load_plugin_textdomain( 'impeka-elementor-extension' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
				$instance = new Impeka_Elementor_Extension_Plugin;
			}
			return $instance;

		}

		/* Add Page Builder Plugin*/
		private function __construct() {

			if ( isset( $_GET['page'] ) && ( 'impeka-wizard' == $_GET['page'] ) ) {
				return;
			}

			// Check if Elementor installed and activated
			if ( ! did_action( 'elementor/loaded' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
				return;
			}

			// Check for required Elementor version
			if ( defined( 'ELEMENTOR_VERSION' ) && ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
				return;
			}

			// Check for required PHP version
			if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
				return;
			}

			if ( is_user_logged_in() ) {
				add_action( 'admin_enqueue_scripts' , $this->marshal( 'impeka_elementor_ext_add_scripts' ) );
			}
			add_action( 'wp_enqueue_scripts' , $this->marshal( 'impeka_elementor_ext_add_front_end_scripts' ) );

			require_once IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'includes/impeka-elementor-ext-functions.php';
			require_once IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'includes/impeka-elementor-ext-dynamic-css-functions.php';
			require_once IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'includes/impeka-elementor-ext-add-param.php';

			// Add Plugin actions
			add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
			add_action( 'elementor/controls/controls_registered', [ $this, 'init_controls' ] );
		}

		public function impeka_Elementor_extension_plugin() {
			$this->__construct();
		}

		public function impeka_elementor_ext_add_scripts( $hook ) {

		}

		public function impeka_elementor_ext_add_front_end_scripts() {

			$dynamic_css = impeka_elementor_dynamic_css();
			wp_add_inline_style( 'impeka-theme-style', impeka_elementor_compress_css( $dynamic_css ) );

			$min = '';
			if ( function_exists( 'impeka_grve_visibility' ) && impeka_grve_visibility( 'minify_assets', '1' ) ) {
				$min = '.min';
			}

			if ( !class_exists( 'Impeka_WPBakery_Extension_Plugin') ) {
				//Load Styles and scripts from Elementor Extension
				wp_enqueue_style( 'impeka-ext-style',  IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL .'assets/css/ext-style' . $min . '.css', array(), IMPEKA_ELEMENTOR_EXT_VERSION, 'all');
				if ( function_exists( 'impeka_grve_option' ) && impeka_grve_option( 'combine_js', '1' ) ) {
					wp_enqueue_script( 'impeka-ext-extras-script',  IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL .'assets/js/ext-extras.min.js', array( 'jquery' ), IMPEKA_ELEMENTOR_EXT_VERSION, true );
				} else {
					wp_enqueue_script( 'countup', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/countUp.min.js', array( 'jquery' ), '1.9.3', true );
					wp_enqueue_script( 'jquery-easypiechart', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/jquery.easypiechart.min.js', array( 'jquery' ), '2.1.6', true );
					wp_enqueue_script( 'typed', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/typed.min.js', array( 'jquery' ), '1.0', true );
					wp_enqueue_script( 'jquery-countdown', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/jquery.countdown.min.js', array( 'jquery' ), '2.2.0', true );
					wp_enqueue_script( 'bg-scroller', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/bg-scroller.min.js', array( 'jquery' ), '1.0.0', true );
					wp_enqueue_script( 'bg-opacity', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/plugins/bg-opacity.min.js', array( 'jquery' ), '1.0.0', true );
				}
				wp_enqueue_script( 'impeka-ext-elements-script',  IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL .'assets/js/ext-elements' . $min . '.js', array( 'jquery' ), IMPEKA_ELEMENTOR_EXT_VERSION, true );
			}

			wp_enqueue_script( 'impeka-elementor-ext-elements-script',  IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL .'assets/js/ext-elementor-elements' . $min . '.js', array( 'jquery' ), IMPEKA_ELEMENTOR_EXT_VERSION, true );

		}

		public function marshal( $method_name ) {
			return array( &$this , $method_name );
		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have Elementor installed or activated.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_missing_main_plugin() {

			if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

			$message = sprintf(
				/* translators: 1: Plugin name 2: Elementor */
				esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'impeka-elementor-extension' ),
				'<strong>' . esc_html__( 'Impeka Elementor Extension', 'impeka-elementor-extension' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'impeka-elementor-extension' ) . '</strong>'
			);

			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required Elementor version.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_minimum_elementor_version() {

			if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

			$message = sprintf(
				/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'impeka-elementor-extension' ),
				'<strong>' . esc_html__( 'Impeka Elementor Extension', 'impeka-elementor-extension' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'impeka-elementor-extension' ) . '</strong>',
				 self::MINIMUM_ELEMENTOR_VERSION
			);

			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required PHP version.
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function admin_notice_minimum_php_version() {

			if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

			$message = sprintf(
				/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'impeka-elementor-extension' ),
				'<strong>' . esc_html__( 'Impeka Elementor Extension', 'impeka-elementor-extension' ) . '</strong>',
				'<strong>' . esc_html__( 'PHP', 'impeka-elementor-extension' ) . '</strong>',
				 self::MINIMUM_PHP_VERSION
			);

			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

		}

		/**
		 * Init Widgets
		 *
		 * Include widgets files and register them
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function init_widgets() {

			// Include Widget files and register widgets
			require_once( __DIR__ . '/widgets/title_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Title_Widget() );

			require_once( __DIR__ . '/widgets/button_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Button_Widget() );

			require_once( __DIR__ . '/widgets/cascading_image_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Cascading_Image_Widget() );

			require_once( __DIR__ . '/widgets/contact_form_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Contact_Form_Widget() );

			require_once( __DIR__ . '/widgets/custom_contact_form_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Custom_Contact_Form_Widget() );

			require_once( __DIR__ . '/widgets/animated_text_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Animated_Text_Widget() );

			require_once( __DIR__ . '/widgets/typed_text_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Typed_Text_Widget() );

			require_once( __DIR__ . '/widgets/countdown_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Countdown_Widget() );

			require_once( __DIR__ . '/widgets/callout_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Callout_Widget() );

			require_once( __DIR__ . '/widgets/slogan_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Slogan_Widget() );

			require_once( __DIR__ . '/widgets/quote_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Quote_Widget() );

			require_once( __DIR__ . '/widgets/divider_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Divider_Widget() );

			require_once( __DIR__ . '/widgets/dropcap_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Dropcap_Widget() );

			require_once( __DIR__ . '/widgets/empty_space_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Empty_Space_Widget() );

			require_once( __DIR__ . '/widgets/pie_chart_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Pie_Chart_Widget() );

			require_once( __DIR__ . '/widgets/counter_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Counter_Widget() );

			require_once( __DIR__ . '/widgets/menu_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Menu_Widget() );

			require_once( __DIR__ . '/widgets/language_selector_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Language_Selector_Widget() );

			require_once( __DIR__ . '/widgets/pricing_table_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Pricing_Table_Widget() );

			require_once( __DIR__ . '/widgets/progress_bar_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Progress_Bar_Widget() );

			require_once( __DIR__ . '/widgets/fancy_box_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Fancy_Box_Widget() );

			require_once( __DIR__ . '/widgets/icon_box_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Icon_Box_Widget() );

			require_once( __DIR__ . '/widgets/media_box_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Media_Box_Widget() );

			require_once( __DIR__ . '/widgets/message_box_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Message_Box_Widget() );

			require_once( __DIR__ . '/widgets/icon_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Icon_Widget() );

			require_once( __DIR__ . '/widgets/social_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Social_Widget() );

			require_once( __DIR__ . '/widgets/social_links_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Social_Links_Widget() );

			require_once( __DIR__ . '/widgets/blog_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Blog_Widget() );
			require_once( __DIR__ . '/widgets/blog_carousel_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Blog_Carousel_Widget() );
			require_once( __DIR__ . '/widgets/blog_leader_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Blog_Leader_Widget() );

			require_once( __DIR__ . '/widgets/portfolio_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Portfolio_Widget() );
			require_once( __DIR__ . '/widgets/portfolio_carousel_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Portfolio_Carousel_Widget() );
			require_once( __DIR__ . '/widgets/portfolio_broken_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Portfolio_Broken_Widget() );

			require_once( __DIR__ . '/widgets/testimonial_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Testimonial_Widget() );
			require_once( __DIR__ . '/widgets/testimonial_carousel_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Testimonial_Carousel_Widget() );

			if ( class_exists( 'woocommerce' ) ) {
				require_once( __DIR__ . '/widgets/products_params.php' );
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Products_Widget() );
				require_once( __DIR__ . '/widgets/products_carousel_params.php' );
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Products_Carousel_Widget() );
			}

			if ( class_exists( 'Tribe__Events__Main' ) ) {
				require_once( __DIR__ . '/widgets/events_params.php' );
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Events_Widget() );
			}

			require_once( __DIR__ . '/widgets/list_title_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_List_Title_Widget() );

			require_once( __DIR__ . '/widgets/content_slider_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Content_Slider_Widget() );

			require_once( __DIR__ . '/widgets/image_single_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Image_Single_Widget() );

			require_once( __DIR__ . '/widgets/image_text_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Image_Text_Widget() );

			require_once( __DIR__ . '/widgets/image_gallery_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Gallery_Widget() );

			require_once( __DIR__ . '/widgets/image_gallery_broken_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Gallery_Broken_Widget() );

			require_once( __DIR__ . '/widgets/image_carousel_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Image_Carousel_Widget() );

			require_once( __DIR__ . '/widgets/image_slider_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Image_Slider_Widget() );

			require_once( __DIR__ . '/widgets/video_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Video_Widget() );

			require_once( __DIR__ . '/widgets/gmap_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Map_Widget() );

			require_once( __DIR__ . '/widgets/team_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Team_Widget() );

			require_once( __DIR__ . '/widgets/split_content_params.php' );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Impeka_Elementor_Split_Content_Widget() );

		}

		/**
		 * Init Controls
		 *
		 * Include controls files and register them
		 *
		 * @since 1.0.0
		 *
		 * @access public
		 */
		public function init_controls() {

			\Elementor\Controls_Manager::add_tab(
				'grve-general-tab',
				__( 'General', 'impeka-elementor-extension' )
			);

			\Elementor\Controls_Manager::add_tab(
				'grve-button-tab',
				__( 'Button', 'impeka-elementor-extension' )
			);

			\Elementor\Controls_Manager::add_tab(
				'grve-animation-tab',
				__( 'Animation', 'impeka-elementor-extension' )
			);

		}
	}

	/**
	 * Initialize the Extension Plugin
	 */
	add_action( 'init' , array( 'Impeka_Elementor_Extension_Plugin' , 'init' ), 12 );

	/**
	 * Add Body Class
	 */
	function impeka_elementor_ext_body_class( $classes ){
		$impeka_elementor_ext_ver = 'grve-elementor-ext-ver-' . IMPEKA_ELEMENTOR_EXT_VERSION;
		return array_merge( $classes, array( $impeka_elementor_ext_ver ) );
	}
	add_filter( 'body_class', 'impeka_elementor_ext_body_class' );

}

//Omit closing PHP tag to avoid accidental whitespace output errors.]