<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */



 /**
 * Generic Parameters to reuse
 * Used in widgets
 */

if( !function_exists( 'impeka_elementor_ext_add_item_space' ) ) {
	function impeka_elementor_ext_add_item_space( $std = '30' ) {
		return [
			'label' => esc_html__( 'Item Spacing', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'0' => '0',
				'1' => '1',
				'5' => '5',
				'10' => '10',
				'15' => '15',
				'20' => '20',
				'25' => '25',
				'30' => '30',
				'35' => '35',
				'40' => '40',
				'45' => '45',
				'50' => '50',
				'55' => '55',
				'60' => '60',
			],
			'default' => $std,
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_align' ) ) {
	function impeka_elementor_ext_add_align( $std = 'left' ) {
		return [
			'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
				'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),
				'center' => esc_html__( 'Center', 'impeka-elementor-extension' ),
			],
			'default' => $std,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_responsive_align' ) ) {
	function impeka_elementor_ext_add_responsive_align( $std = 'left' ) {
		return [
			'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'impeka-elementor-extension' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'impeka-elementor-extension' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'impeka-elementor-extension' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => $std,
			//'toggle' => false,
			'devices' => [ 'desktop', 'tablet', 'mobile' ],
			'prefix_class' => 'grve-elementor-align-%s',
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_shadow_alt' ) ) {
	function impeka_elementor_ext_add_shadow_alt() {
		return [
			'label' => esc_html__( 'Shadow', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'No' , 'impeka-elementor-extension' ),
				'small-shadow' => esc_html__( 'Small' , 'impeka-elementor-extension' ),
				'medium-shadow' => esc_html__( 'Medium' , 'impeka-elementor-extension' ),
				'large-shadow' => esc_html__( 'Large' , 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( 'Select your shadow', 'impeka-elementor-extension' ),
			'default' => '',
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_shadow' ) ) {
	function impeka_elementor_ext_add_shadow() {
		return [
			'label' => esc_html__( 'Shadow', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
				'small' => esc_html__( 'Small' , 'impeka-elementor-extension' ),
				'medium' => esc_html__( 'Medium' , 'impeka-elementor-extension' ),
				'large' => esc_html__( 'Large' , 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( 'Select your shadow', 'impeka-elementor-extension' ),
			'default' => 'none',
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_radius' ) ) {
	function impeka_elementor_ext_add_radius() {
		return [
			'label' => esc_html__( 'Border Radius', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
				'3' => esc_html__( 'Radius 3px' , 'impeka-elementor-extension' ),
				'5' => esc_html__( 'Radius 5px' , 'impeka-elementor-extension' ),
				'10' => esc_html__( 'Radius 10px' , 'impeka-elementor-extension' ),
				'15' => esc_html__( 'Radius 15px' , 'impeka-elementor-extension' ),
				'20' => esc_html__( 'Radius 20px' , 'impeka-elementor-extension' ),
				'25' => esc_html__( 'Radius 25px' , 'impeka-elementor-extension' ),
				'30' => esc_html__( 'Radius 30px' , 'impeka-elementor-extension' ),
				'35' => esc_html__( 'Radius 35px' , 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( 'Select your border radius', 'impeka-elementor-extension' ),
			'default' => 'none',
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_image_load_mode' ) ) {
	function impeka_elementor_ext_add_image_load_mode() {
		return [
			'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => array(
				'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
				'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
				'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
				'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
			),
			'default' => '',
			'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_order_by' ) ) {
	function impeka_elementor_ext_add_order_by() {
		return [
			'label' => esc_html__( 'Order By', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'date' => esc_html__( 'Date', 'impeka-elementor-extension' ),
				'modified' => esc_html__( 'Last modified date', 'impeka-elementor-extension' ),
				'comment_count' => esc_html__( 'Number of comments', 'impeka-elementor-extension' ),
				'title' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'author' => esc_html__( 'Author', 'impeka-elementor-extension' ),
				'rand' => esc_html__( 'Random', 'impeka-elementor-extension' ),
				'menu_order' => esc_html__( "Post Order", "impeka-elementor-extension" ),
				'post__in' => esc_html__( "Post In", "impeka-elementor-extension" ),
			],
			'default' => 'date',
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_order' ) ) {
	function impeka_elementor_ext_add_order() {
		return [
			'label' => esc_html__( 'Order', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'DESC' => esc_html__( 'Descending', 'impeka-elementor-extension' ),
				'ASC' => esc_html__( 'Ascending', 'impeka-elementor-extension' ),
			],
			'default' => 'DESC',
			'conditions' => [
				'terms' => [
					[ 'name' => 'order_by', 'operator' => '!in', 'value' => [ 'rand', 'post__in' ] ],
				],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_margin_bottom' ) ) {
	function impeka_elementor_ext_add_margin_bottom() {
		return [
			'label' => esc_html__( 'Bottom margin', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'description' => esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-elementor-extension' ),
			'default' => '',
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_el_class' ) ) {
	function impeka_elementor_ext_add_el_class() {
		return [
			'label' => esc_html__( 'Extra class name', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'impeka-elementor-extension' ),
			'default' => '',
		];
	}
}

//Animation Parameters

if( !function_exists( 'impeka_elementor_ext_add_animation_all' ) ) {
	function impeka_elementor_ext_add_animation_all( $std = "" ) {
		return [
			'label' => esc_html__( 'CSS Animation', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => $std,
			'options' => [
				''  => esc_html__( 'No', 'impeka-elementor-extension' ),
				'fade-in'  => esc_html__( 'Fade In', 'impeka-elementor-extension' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'impeka-elementor-extension' ),
				'fade-in-up-big' => esc_html__( 'Fade In Up Big', 'impeka-elementor-extension' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'impeka-elementor-extension' ),
				'fade-in-down-big' => esc_html__( 'Fade In Down Big', 'impeka-elementor-extension' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'impeka-elementor-extension' ),
				'fade-in-left-big' => esc_html__( 'Fade In Left Big', 'impeka-elementor-extension' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'impeka-elementor-extension' ),
				'fade-in-right-big' => esc_html__( 'Fade In Right Big', 'impeka-elementor-extension' ),
				'zoom-in' => esc_html__( 'Zoom In', 'impeka-elementor-extension' ),
				'clipping-animation' => esc_html__( 'Clipping Animation', 'impeka-elementor-extension' ),
				'appear-animation' => esc_html__( 'Appear Animation', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'impeka-elementor-extension' ),
		];
	}
}


if( !function_exists( 'impeka_elementor_ext_add_clipping' ) ) {
	function impeka_elementor_ext_add_clipping( $std = "" ) {
		return [
			'label' => esc_html__( 'CSS Clipping Animation', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => $std,
			'options' => [
				''  => esc_html__( 'No', 'impeka-elementor-extension' ),
				'clipping-up' => esc_html__( 'Clipping Up', 'impeka-elementor-extension' ),
				'clipping-down' => esc_html__( 'Clipping Down', 'impeka-elementor-extension' ),
				'clipping-left' => esc_html__( 'Clipping Left', 'impeka-elementor-extension' ),
				'clipping-right' => esc_html__( 'Clipping Right', 'impeka-elementor-extension' ),
				'colored-clipping-up' => esc_html__( 'Colored Clipping Up', 'impeka-elementor-extension' ),
				'colored-clipping-down' => esc_html__( 'Colored Clipping Down', 'impeka-elementor-extension' ),
				'colored-clipping-left' => esc_html__( 'Colored Clipping Left', 'impeka-elementor-extension' ),
				'colored-clipping-right' => esc_html__( 'Colored Clipping Right', 'impeka-elementor-extension' ),

			],
			'condition' => [
				'grve_animation' => [ 'clipping-animation' ],
			],
			'description' => esc_html__( "Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_clipping_colors' ) ) {
	function impeka_elementor_ext_add_clipping_colors( $std = 'black' ) {
		return [
			'label' => esc_html__( 'Clipping Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => $std,
			'options' => impeka_elementor_ext_get_color_array(),
			'condition' => ['grve_animation' => [ 'clipping-animation' ],
				'clipping_animation' => [ 'colored-clipping-up', 'colored-clipping-down', 'colored-clipping-left', 'colored-clipping-right' ],
				'clipping_animation' => [ 'colored-clipping-up', 'colored-clipping-down', 'colored-clipping-left', 'colored-clipping-right' ],
			],
			'description' => esc_html__( "Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_appear' ) ) {
	function impeka_elementor_ext_add_appear( $std = "" ) {
		return [
			'label' => esc_html__( 'CSS Appear Animation', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => $std,
			'options' => [
				''  => esc_html__( 'No', 'impeka-elementor-extension' ),
				'appear-up' => esc_html__( 'Appear Up', 'impeka-elementor-extension' ),
				'appear-down' => esc_html__( 'Appear Down', 'impeka-elementor-extension' ),
				'appear-left' => esc_html__( 'Appear Left', 'impeka-elementor-extension' ),
				'appear-right' => esc_html__( 'Appear Right', 'impeka-elementor-extension' ),
			],
			'condition' => [
				'grve_animation' => [ 'appear-animation' ],
			],
			'description' => esc_html__( "Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_animation' ) ) {
	function impeka_elementor_ext_add_animation( $std = "" ) {
		return [
			'label' => esc_html__( 'CSS Animation', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => $std,
			'options' => [
				''  => esc_html__( 'No', 'impeka-elementor-extension' ),
				'fade-in'  => esc_html__( 'Fade In', 'impeka-elementor-extension' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'impeka-elementor-extension' ),
				'fade-in-up-big' => esc_html__( 'Fade In Up Big', 'impeka-elementor-extension' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'impeka-elementor-extension' ),
				'fade-in-down-big' => esc_html__( 'Fade In Down Big', 'impeka-elementor-extension' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'impeka-elementor-extension' ),
				'fade-in-left-big' => esc_html__( 'Fade In Left Big', 'impeka-elementor-extension' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'impeka-elementor-extension' ),
				'fade-in-right-big' => esc_html__( 'Fade In Right Big', 'impeka-elementor-extension' ),
				'zoom-in' => esc_html__( 'Zoom In', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_animation_delay' ) ) {
	function impeka_elementor_ext_add_animation_delay() {
		return [
			'label' => esc_html__( 'CSS Animation Delay', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '0',
			'description' => esc_html__( 'Add delay in milliseconds.', 'impeka-elementor-extension' ),
			'conditions' => [
				'terms' => [
					[ 'name' => 'grve_animation', 'operator' => '!in', 'value' => [ '' ] ],
				],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_animation_duration' ) ) {
	function impeka_elementor_ext_add_animation_duration() {
		return [
			'label' => esc_html__( 'CSS Animation Duration', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'normal',
			'options' => [
				'very-fast'  => esc_html__( 'Very Fast', 'impeka-elementor-extension' ),
				'fast'  => esc_html__( 'Fast', 'impeka-elementor-extension' ),
				'normal' => esc_html__( 'Normal', 'impeka-elementor-extension' ),
				'slow' => esc_html__( 'Slow', 'impeka-elementor-extension' ),
				'very-slow' => esc_html__( 'Very Slow', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select the duration for your animated element.", 'impeka-elementor-extension' ),
			'conditions' => [
				'terms' => [
					[ 'name' => 'grve_animation', 'operator' => '!in', 'value' => [ '' ] ],
				],
			],
		];
	}
}

//Filter parameters

if( !function_exists( 'impeka_elementor_ext_add_filter' ) ) {
	function impeka_elementor_ext_add_filter() {
		return [
			'label' => esc_html__( 'Filter', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => '',
			'description' => esc_html__( 'If selected, an isotope filter will be displayed.', 'impeka-elementor-extension' ) . ' ' . esc_html__( 'Enable Filter ( Only for All or Multiple Categories )', 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_all_text' ) ) {
	function impeka_elementor_ext_add_filter_all_text() {
		return [
			'label' => esc_html__( 'Filter All Text', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'All',
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_order_by' ) ) {
	function impeka_elementor_ext_add_filter_order_by() {
		return [
			'label' => esc_html__( 'Filter Order By', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'Default ( Unordered )', 'impeka-elementor-extension'  ),
				'id' => esc_html__( 'ID', 'impeka-elementor-extension' ),
				'slug' => esc_html__( 'Slug', 'impeka-elementor-extension' ),
				'title' => esc_html__( 'Title', 'impeka-elementor-extension' ),
			],
			'default' => '',
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_order' ) ) {
	function impeka_elementor_ext_add_filter_order() {
		return [
			'label' => esc_html__( 'Filter Order', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'ASC' => esc_html__( 'Ascending', 'impeka-elementor-extension' ),
				'DESC' => esc_html__( 'Descending', 'impeka-elementor-extension' ),
			],
			'default' => 'ASC',
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_style' ) ) {
	function impeka_elementor_ext_add_filter_style() {
		return [
			'label' => esc_html__( 'Filter Style', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'simple' => esc_html__( 'Simple', 'impeka-elementor-extension' ),
				'button' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'classic' => esc_html__( 'Classic', 'impeka-elementor-extension' ),
				'splitted' => esc_html__( 'Splitted', 'impeka-elementor-extension' ),
				'count' => esc_html__( 'Count', 'impeka-elementor-extension' ),
			],
			'default' => 'simple',
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_shape' ) ) {
	function impeka_elementor_ext_add_filter_shape() {
		return [
			'label' => esc_html__( 'Filter Shape', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'square' => esc_html__( 'Square', 'impeka-elementor-extension' ),
				'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
				'extra-round' => esc_html__( 'Extra Round', 'impeka-elementor-extension' ),
			],
			'default' => 'square',
			'condition' => [
				'filter_style' => [ 'button' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_color' ) ) {
	function impeka_elementor_ext_add_filter_color() {
		return [
			'label' => esc_html__( 'Filter Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'condition' => [
				'filter_style' => [ 'button' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_align' ) ) {
	function impeka_elementor_ext_add_filter_align( $std = 'left' ) {
		return [
			'label' => esc_html__( 'Filter Alignment', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
				'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),
				'center' => esc_html__( 'Center', 'impeka-elementor-extension' ),
			],
			'default' => $std,
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_filter_gototop' ) ) {
	function impeka_elementor_ext_add_filter_gototop( $std = 'yes' ) {
		return [
			'label' => esc_html__( 'Filter Go To Top', 'impeka-elementor-extension' ),
			'description' => esc_html__( 'Animate to the top of the filter after clicking ( Excludes Infinite Scroll and Load more ).', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'yes' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'no' => esc_html__( 'No', 'impeka-elementor-extension' ),
			],
			'default' => $std,
			'condition' => [
				'filter' => [ 'yes' ],
			],
		];
	}
}

//Navigation Parameters

if( !function_exists( 'impeka_elementor_ext_add_nav_visibility' ) ) {
	function impeka_elementor_ext_add_nav_visibility( $std = 'no' ) {
		return [
			'label' => esc_html__( 'Navigation Visibility', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_nav_icon' ) ) {
	function impeka_elementor_ext_add_nav_icon( $std = 'arrow-1' ) {
		return [
			'label' => esc_html__( 'Navigation Icon', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'arrow-1' => esc_html__( 'Icon 1', 'impeka-elementor-extension' ),
				'arrow-2' => esc_html__( 'Icon 2', 'impeka-elementor-extension' ),
				'arrow-3' => esc_html__( 'Icon 3', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( 'Select your Navigation icon.', 'impeka-elementor-extension' ),
			'default' => $std,
			'condition' => [
				'nav_visibility' => [ 'yes' ],
			],
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_nav_icon_color' ) ) {
	function impeka_elementor_ext_add_nav_icon_color( $std = 'black' ) {
		return [
			'label' => esc_html__( 'Navigation Icon Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'description' => esc_html__( 'Select your Navigation icon color.', 'impeka-elementor-extension' ),
			'default' => $std,
			'condition' => [
				'nav_visibility' => [ 'yes' ],
			],
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_nav_shape' ) ) {
	function impeka_elementor_ext_add_nav_shape() {
		return [
			'label' => esc_html__( 'Navigation Shape', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'None', 'impeka-elementor-extension' ),
				'square' => esc_html__( 'Square', 'impeka-elementor-extension' ),
				'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
				'circle' => esc_html__( 'Circle', 'impeka-elementor-extension' ),

			],
			'description' => esc_html__( 'Select your Navigation shape.', 'impeka-elementor-extension' ),
			'default' => 'circle',
			'condition' => [
				'nav_visibility' => [ 'yes' ],
			],
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_nav_shape_type' ) ) {
	function impeka_elementor_ext_add_nav_shape_type() {
		return [
			'label' => esc_html__( 'Navigation Shape type', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'simple' => esc_html__( 'Simple', 'impeka-elementor-extension' ),
				'outline' => esc_html__( 'Outline', 'impeka-elementor-extension' ),

			],
			'description' => esc_html__( 'Select your Navigation shape type.', 'impeka-elementor-extension' ),
			'default' => 'simple',
			'condition' => [
				'nav_visibility' => [ 'yes' ],
			],
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_nav_shape_color' ) ) {
	function impeka_elementor_ext_add_nav_shape_color() {
		return [
			'label' => esc_html__( 'Navigation Shape Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'description' => esc_html__( 'Select your Navigation shape color.', 'impeka-elementor-extension' ),
			'default' => 'white',
			'condition' => [
				'nav_visibility' => [ 'yes' ],
				'nav_shape' => [ 'square', 'round' ,'circle' ],
			],
		];
	}
}

//Pagination Parameters

if( !function_exists( 'impeka_elementor_ext_add_pagination' ) ) {
	function impeka_elementor_ext_add_pagination( $std = 'yes') {
		return [
			'label' => esc_html__( 'Pagination Visibility', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std ,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_pagination_speed' ) ) {
	function impeka_elementor_ext_add_pagination_speed() {
		return [
			'label' => esc_html__( 'Pagination Speed', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '400',
			'description' => esc_html__( 'Pagination Speed in ms ( Only available for Classic Carousel ).', 'impeka-elementor-extension' ),
			'condition' => [
				'pagination' => [ 'yes' ],
			],
		];
	}
}

//Carousel Parameters

if( !function_exists( 'impeka_elementor_ext_add_loop' ) ) {
	function impeka_elementor_ext_add_loop( $std = 'yes' ) {
		return [
			'label' => esc_html__( 'Loop', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std,
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_auto_play' ) ) {
	function impeka_elementor_ext_add_auto_play( $std = 'yes' ) {
		return [
			'label' => esc_html__( 'Autoplay', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_slideshow_speed' ) ) {
	function impeka_elementor_ext_add_slideshow_speed ( $std = '3000' ) {
		return [
			'label' => esc_html__( 'Slideshow Speed', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '3000',
			'description' => esc_html__( 'Slideshow Speed in ms.', 'impeka-elementor-extension' ),
			'condition' => [
				'type' => [ 'classic' ],
			],
		];
	}
}


if( !function_exists( 'impeka_elementor_ext_add_auto_height' ) ) {
	function impeka_elementor_ext_add_auto_height( $std = 'no' ) {
		return [
			'label' => esc_html__( 'Auto Height', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std,
			'description' => esc_html__( 'Select if you want smooth auto height.', 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_pause_hover' ) ) {
	function impeka_elementor_ext_add_pause_hover( $std = 'no' ) {
		return [
			'label' => esc_html__( 'Pause on Hover', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
			'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
			'return_value' => 'yes',
			'default' => $std,
			'description' => esc_html__( 'If selected, carousel will be paused on hover.', 'impeka-elementor-extension' ),
			'condition' => [
				'type' => [ 'classic' ],
			],
		];
	}
}


//Heading Parameters

if( !function_exists( 'impeka_elementor_ext_add_heading_tag' ) ) {
	function impeka_elementor_ext_add_heading_tag( $std = 'h3' ) {
		return [
			'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
				'div' => 'div',
			],
			'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
			'default' => $std,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_heading' ) ) {
	function impeka_elementor_ext_add_heading( $std = 'h3' ) {
		return [
			'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'auto' => esc_html__( 'Auto', 'impeka-elementor-extension' ),
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
				'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
				'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
				'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( 'Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			'default' => $std,
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_increase_heading' ) ) {
	function impeka_elementor_ext_add_increase_heading( $std = '100' ) {
		return [
			'label' => esc_html__( 'Increase Heading Size', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				'120' => esc_html__( '120%', 'impeka-elementor-extension' ),
				'140' => esc_html__( '140%', 'impeka-elementor-extension' ),
				'160' => esc_html__( '160%', 'impeka-elementor-extension' ),
				'180' => esc_html__( '180%', 'impeka-elementor-extension' ),
				'200' => esc_html__( '200%', 'impeka-elementor-extension' ),
				'250' => esc_html__( '250%', 'impeka-elementor-extension' ),
				'300' => esc_html__( '300%', 'impeka-elementor-extension' ),

			],
			'default' => $std,
			'description' => esc_html__( 'Set the percentage you want to increase your Headings size.', 'impeka-elementor-extension' ),
		];
	}
}
if( !function_exists( 'impeka_elementor_ext_add_increase_heading_reset' ) ) {
	function impeka_elementor_ext_add_increase_heading_reset() {
		return[
			'label' => esc_html__( 'Reset Heading Size', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'Never', 'impeka-elementor-extension' ),
				'desktop-sm' => esc_html__( 'on Small Desktop and below', 'impeka-elementor-extension' ),
				'tablet' => esc_html__( 'on Tablet Landscape and below', 'impeka-elementor-extension' ),
				'tablet-sm' => esc_html__( 'on Tablet Portrait and below', 'impeka-elementor-extension' ),
				'mobile' => esc_html__( 'on Mobile Ladscape and below', 'impeka-elementor-extension' ),

			],
			'default' => '',
			'description' => esc_html__( 'Select if you want to reset the header size in some devices in case size is too large.', 'impeka-elementor-extension' ),
		];
	}
}

if( !function_exists( 'impeka_elementor_ext_add_custom_font_family' ) ) {
	function impeka_elementor_ext_add_custom_font_family() {
		return [
			'label' => esc_html__( 'Custom Font Family', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'' => esc_html__( 'Same as Typography', 'impeka-elementor-extension' ),
				'custom-font-1' => esc_html__( 'Custom Font Family 1', 'impeka-elementor-extension' ),
				'custom-font-2' => esc_html__( 'Custom Font Family 2', 'impeka-elementor-extension' ),
				'custom-font-3' => esc_html__( 'Custom Font Family 3', 'impeka-elementor-extension' ),
				'custom-font-4' => esc_html__( 'Custom Font Family 4', 'impeka-elementor-extension' ),


			],
			'default' => '',
			'description' => esc_html__( 'Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family', 'impeka-elementor-extension' ),
		];
	}
}

function impeka_elementor_ext_get_social_links_params( $that ) {
	global $impeka_grve_social_list_extended;

	$social_params = array();
	if ( isset( $impeka_grve_social_list_extended ) ) {

		foreach ( $impeka_grve_social_list_extended as $social_item ) {

			$that->add_control(
				$social_item['url'],
				[
					'label' => $social_item['title'],
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => '' ,
				]
			);

		}
	}
}

//Button Parameters

function impeka_elementor_ext_get_button_params( $that, $index = '' ) {

	$that->add_control(
		'btn' . $index . '_text',
		[
			'label' => esc_html__( 'Button Text', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Button' ,
			'description' => esc_html__( "Text of the button.", 'impeka-elementor-extension' ),
		]
	);
	$that->add_control(
		'btn' . $index . '_sr_text',
		[
			'label' => esc_html__( 'Screen Reader Text', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '' ,
			'description' => esc_html__( "Additional informative text for screen readers.", 'impeka-elementor-extension' ),
		]
	);
	$that->add_control(
		'btn' . $index . '_type',
		[
			'label' => esc_html__( 'Button Type', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'simple',
			'options' => [
				'simple'  => esc_html__( 'Simple', 'impeka-elementor-extension' ),
				'outline'  => esc_html__( 'Outline', 'impeka-elementor-extension' ),
				'line' => esc_html__( 'Line', 'impeka-elementor-extension' ),
				'only-text' => esc_html__( 'Only Text', 'impeka-elementor-extension' ),
				'video' => esc_html__( 'Video', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button type.", 'impeka-elementor-extension' ),
		]
	);
	$that->add_control(
		'btn' . $index . '_line_position',
		[
			'label' => esc_html__( 'Button Line Position', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'left',
			'options' => [
				'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
				'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),
 				'bottom' => esc_html__( 'Bottom', 'impeka-elementor-extension' ),
				'bottom-advanced' => esc_html__( 'Bottom Advanced', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button line position.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'line' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_color',
		[
			'label' => esc_html__( 'Button Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the button.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'outline', 'line', 'only-text', 'video' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_color_gradient',
		[
			'label' => esc_html__( 'Button Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the button.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_line_color',
		[
			'label' => esc_html__( 'Button Line Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the button line.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'line' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_hover_color',
		[
			'label' => esc_html__( 'Button Hover Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'black',
			'description' => esc_html__( 'Hover color of the button.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'only-text' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_hover_color_gradient',
		[
			'label' => esc_html__( 'Button Hover Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'black',
			'description' => esc_html__( 'Hover color of the button.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple', 'outline' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_hover_action',
		[
			'label' => esc_html__( 'Button Hover Action', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'' => esc_html__( 'None', 'impeka-elementor-extension' ),
				'pulse' => esc_html__( 'Pulse', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button hover action.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple', 'outline' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_size',
		[
			'label' => esc_html__( 'Button Size', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'medium',
			'options' => [
				'extrasmall' => esc_html__( 'Extra Small', 'impeka-elementor-extension' ),
				'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
				'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
				'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
				'extralarge' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button size.", 'impeka-elementor-extension' ),
		]
	);
	$that->add_control(
		'btn' . $index . '_shape',
		[
			'label' => esc_html__( 'Button Shape', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'square',
			'options' => [
				'square' => esc_html__( 'Square', 'impeka-elementor-extension' ),
				'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
				'extra-round' => esc_html__( 'Extra Round', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button shape.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple', 'outline' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_shadow',
		[
			'label' => esc_html__( 'Button Shadow', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'' => esc_html__( 'None', 'impeka-elementor-extension' ),
				'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
				'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
				'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select button shadow.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_link',
		[
			'label' => esc_html__( 'Button Link', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::URL,
			'dynamic' => [
				'active' => false,
			],
			'placeholder' => 'https://your-link.com',
		]
	);
	$that->add_control(
		'btn' . $index . '_icon_type',
		[
			'label' => esc_html__( 'Button Icon Type', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'none',
			'options' => [
				'none' => esc_html__( 'None', 'impeka-elementor-extension' ),
				'icon-svg' => esc_html__( 'Theme SVG Icon', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select icon type.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'simple', 'outline', 'only-text' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_svg_icon',
		[
			'label' => esc_html__( 'SVG Icon', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'arrow-1',
			'options' => [
				'arrow-1' => esc_html__( 'Arrow 1', 'impeka-elementor-extension' ),
				'arrow-2' => esc_html__( 'Arrow 2', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select an svg icon.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_icon_type' => [ 'icon-svg' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_video_icon_shape',
		[
			'label' => esc_html__( 'Video Icon Shape', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'round',
			'options' => [
				'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
				'circle' => esc_html__( 'Circle', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select video icon shape.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'video' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_video_icon_shape_type',
		[
			'label' => esc_html__( 'Video Icon Shape Type', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'simple',
			'options' => [
				'simple' => esc_html__( 'Simple', 'impeka-elementor-extension' ),
				'outline' => esc_html__( 'Outline', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select video icon shape type.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'video' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_video_icon_shape_color',
		[
			'label' => esc_html__( 'Video Icon Shape Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the video icon shape color.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'video' ],
				'btn' . $index . '_video_icon_shape_type' => [ 'simple', 'outline' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_video_icon_shape_hover_color',
		[
			'label' => esc_html__( 'Video Icon Shape Hover Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'black',
			'description' => esc_html__( 'Hover color of the video icon shape.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_type' => [ 'video' ],
				'btn' . $index . '_video_icon_shape_type' => [ 'simple' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_svg_icon_shape',
		[
			'label' => esc_html__( 'SVG Icon Shape', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'' => esc_html__( 'None', 'impeka-elementor-extension' ),
				'circle' => esc_html__( 'Circle', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select svg icon shape.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_icon_type' => [ 'icon-svg' ],
				'btn' . $index . '_svg_icon' => [ 'arrow-1' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_svg_icon_shape_type',
		[
			'label' => esc_html__( 'SVG Icon Shape Type', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'simple',
			'options' => [
				'simple' => esc_html__( 'Simple', 'impeka-elementor-extension' ),
				'outline' => esc_html__( 'Outline', 'impeka-elementor-extension' ),
			],
			'description' => esc_html__( "Select svg icon shape type.", 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_icon_type' => [ 'icon-svg' ],
				'btn' . $index . '_svg_icon' => [ 'arrow-1' ],
				'btn' . $index . '_svg_icon_shape' => [ 'circle' ],
			],
		]
	);

	$that->add_control(
		'btn' . $index . '_svg_icon_color',
		[
			'label' => esc_html__( 'SVG Icon Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the svg icon.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_icon_type' => [ 'icon-svg' ],
				'btn' . $index . '_svg_icon' => [ 'arrow-1' ],
				'btn' . $index . '_svg_icon_shape' => [ 'circle' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_svg_icon_shape_color',
		[
			'label' => esc_html__( 'SVG Icon Shape Color', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => impeka_elementor_ext_get_color_array(),
			'default' => 'primary-1',
			'description' => esc_html__( 'Color of the svg icon shape.', 'impeka-elementor-extension' ),
			'condition' => [
				'btn' . $index . '_icon_type' => [ 'icon-svg' ],
				'btn' . $index . '_svg_icon' => [ 'arrow-1' ],
				'btn' . $index . '_svg_icon_shape' => [ 'circle' ],
			],
		]
	);
	$that->add_control(
		'btn' . $index . '_class',
		[
			'label' => esc_html__( 'Button class name', 'impeka-elementor-extension' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'impeka-elementor-extension' ),
			'default' => '',
		]
	);
}



//Omit closing PHP tag to avoid accidental whitespace output errors.
