<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */


add_action( 'elementor/editor/before_enqueue_styles', function() {
   wp_enqueue_style('impeka-elementor-admin-elements', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL .'assets/css/admin/style.css', array(), time(), 'all');
} );

add_action( 'elementor/element/section/section_layout/before_section_end', function( $element, $args ) {
	$element->start_injection( [
		'at' => 'before',
		'of' => 'html_tag',
	] );

	$element->add_control(
		'scroll_header_skin',
		[
			'label' => esc_html__( "Scroll Header Skin", "impeka-elementor-extension" ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'inherit' => esc_html__( "Inherit", "impeka-elementor-extension" ),
				'dark' => esc_html__( "Dark", "impeka-elementor-extension" ),
				'light' => esc_html__( "Light", "impeka-elementor-extension" ),
				'default' => esc_html__( "Default", "impeka-elementor-extension" ),
			],
			'default' => 'inherit',
		]
	);

	$element->add_control(
		'scroll_section_title',
		[
			'label' => esc_html__( "Scrolling Section Title", "impeka-elementor-extension" ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '',
			'description' => esc_html__( 'If you wish you can type a title for the side dot navigation.', 'impeka-elementor-extension' ),
		]
	);

	$element->end_injection();
}, 10, 2 );


add_action( 'elementor/frontend/section/before_render', function( $element ) {
	$section_id = $element->get_settings( '_element_id' );
	$scroll_section_title = $element->get_settings( 'scroll_section_title' );
	$scroll_header_skin = $element->get_settings( 'scroll_header_skin' );
	$heading_color = $element->get_settings( 'heading_color' );
	$color_text = $element->get_settings( 'color_text' );

	if ( 'inherit' !== $scroll_header_skin ) {
		$element->add_render_attribute( '_wrapper', 'data-header-color', $scroll_header_skin ) ;
	}
	if ( !empty( $scroll_section_title ) ) {
		$element->add_render_attribute( '_wrapper', 'data-anchor-tooltip', $scroll_section_title ) ;
	}
	if ( !empty( $heading_color ) ) {
		$element->add_render_attribute( '_wrapper', 'data-heading-color', $heading_color ) ;
	}
	if ( !empty( $color_text ) ) {
		$element->add_render_attribute( '_wrapper', 'data-text-color', $color_text ) ;
	}

	if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
		$scrolling_lock_anchors = impeka_elementor_ext_post_meta( '_impeka_grve_scrolling_lock_anchors', 'yes' );
		if( 'no' == $scrolling_lock_anchors ) {
			$section_uniqid = uniqid('grve-scrolling-section-');
			if ( !empty ( $section_id ) ) {
				$element->add_render_attribute( '_wrapper', 'data-anchor', $section_id ) ;
			} else {
				$element->add_render_attribute( '_wrapper', 'data-anchor', $section_uniqid ) ;
			}
		}
	}

} );

add_action( 'elementor/element/column/layout/before_section_end', function( $element, $args ) {
	$element->start_injection( [
		'at' => 'before',
		'of' => 'html_tag',
	] );

	$element->add_control(
		'skin_effect',
		[
			'label' => esc_html__( "Skin Effect", "impeka-elementor-extension" ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'inherit' => esc_html__( "Inherit", "impeka-elementor-extension" ),
				'disabled' => esc_html__( "Disabled", "impeka-elementor-extension" ),
			],
			'default' => 'inherit',
			'description' => esc_html__( 'If you wish you can disable skin effect for all elements of this column.', 'impeka-elementor-extension' ),
		]
	);

	$element->end_injection();
}, 10, 2 );

add_action( 'elementor/frontend/column/before_render', function( $element ) {

	$skin_effect = $element->get_settings( 'skin_effect' );
	if ( 'disabled' == $skin_effect ) {
		$element->add_render_attribute( '_wrapper', [
			'class' => 'grve-disable-color-change',
		] );
	}

} );

 /**
 * Add widget categories to elementor
 */

function impeka_elementor_add_widget_categories( $elements_manager ) {

	$categories = [];
	$categories['impeka'] = [
		'title' => esc_html__( 'Impeka', 'impeka-elementor-extension' ),
		'icon' => 'fa fa-server',
	];

	$old_categories = $elements_manager->get_categories();
	$categories = array_merge($categories, $old_categories);

	$set_categories = function ( $categories ) {
		$this->categories = $categories;
	};

	$set_categories->call( $elements_manager, $categories );

}
add_action( 'elementor/elements/categories_registered', 'impeka_elementor_add_widget_categories' );

function impeka_elementor_add_icons( $tabs ) {

        $tabs['etlineicons'] = [
            'name' => 'etlineicons',
            'label' => esc_html__( 'Elegant Line Icons', 'impeka-elementor-extension' ),
            'url' => IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . '/assets/css/et-line-icons.min.css',
            'enqueue' => [
                IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/css/et-line-icons.min.css',
            ],
            'prefix' => 'et-icon-',
            'displayPrefix' => '',
            'labelIcon' => 'fas fa-icons',
            'ver' => '1.0.0',
            'fetchJson' => IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/icon-lists/et-line.js',
            'native' => true,
        ];
        $tabs['simplelineicons'] = [
            'name' => 'simplelineicons',
            'label' => esc_html__( 'Simple Line Icons', 'impeka-elementor-extension' ),
            'url' => IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . '/assets/css/simple-line-icons.min.css',
            'enqueue' => [
                IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/css/simple-line-icons.min.css',
            ],
            'prefix' => 'smp-icon-',
            'displayPrefix' => '',
            'labelIcon' => 'fas fa-icons',
            'ver' => '1.0.0',
            'fetchJson' => IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/icon-lists/simple-line.js',
            'native' => true,
        ];
		return $tabs;

}
add_filter( 'elementor/icons_manager/additional_tabs', 'impeka_elementor_add_icons' );

 /**
 * Helper function to get switcher value
 */
if ( !function_exists( 'impeka_elementor_ext_get_switcher_value' ) ) {
	function impeka_elementor_ext_get_switcher_value( $value ) {
		$output = isset( $value ) && !empty( $value ) ? $value : 'no';
		return $output;
	}
}

 /**
 * Helper function to get array value with fallback
 */
if ( !function_exists( 'impeka_elementor_ext_array_value' ) ) {
	function impeka_elementor_ext_array_value( $input_array, $id, $fallback = false, $param = false ) {

		if ( $fallback == false ) $fallback = '';
		$output = ( isset($input_array[$id]) && $input_array[$id] !== '' ) ? $input_array[$id] : $fallback;
		if ( !empty($input_array[$id]) && $param ) {
			$output = ( isset($input_array[$id][$param]) && $input_array[$id][$param] !== '' ) ? $input_array[$id][$param] : $fallback;
		}
		return $output;
	}
}

 /**
 * Helper function to get array of colors
 */
if( !function_exists( 'impeka_elementor_ext_get_color_array' ) ) {
	function impeka_elementor_ext_get_color_array( $options = ['primary', 'standard'] ) {

		$colors = array();

		if( in_array('none', $options ) ) {
			$colors['none'] = esc_html__( 'None', 'impeka-elementor-extension' );
		}

		if( in_array('default', $options ) ) {
			$colors['default'] = esc_html__( 'Default', 'impeka-elementor-extension' );
		}

		if( in_array('inherit', $options ) ) {
			$colors['inherit'] = esc_html__( 'Inherit', 'impeka-elementor-extension' );
		}

		if( in_array('transparent', $options ) ) {
			$colors['transparent'] = esc_html__( 'Transparent', 'impeka-elementor-extension' );
		}


		if( in_array('primary', $options ) ) {
			$colors['primary-1'] = esc_html__( 'Primary 1', 'impeka-elementor-extension' );
			$colors['primary-2'] = esc_html__( 'Primary 2', 'impeka-elementor-extension' );
			$colors['primary-3'] = esc_html__( 'Primary 3', 'impeka-elementor-extension' );
			$colors['primary-4'] = esc_html__( 'Primary 4', 'impeka-elementor-extension' );
			$colors['primary-5'] = esc_html__( 'Primary 5', 'impeka-elementor-extension' );
			$colors['primary-6'] = esc_html__( 'Primary 6', 'impeka-elementor-extension' );
		}

		if( in_array('gradient', $options ) ) {
			$colors['gradient-1'] = esc_html__( 'Gradient 1', 'impeka-elementor-extension' );
			$colors['gradient-2'] = esc_html__( 'Gradient 2', 'impeka-elementor-extension' );
			$colors['gradient-3'] = esc_html__( 'Gradient 3', 'impeka-elementor-extension' );
		}

		if( in_array('single-gradient', $options ) ) {
			$colors['gradient'] = esc_html__( 'Gradient', 'impeka-elementor-extension' );
		}

		if( in_array('black-white', $options ) ) {
			$colors['black'] = esc_html__( 'Black', 'impeka-elementor-extension' );
			$colors['white'] = esc_html__( 'White', 'impeka-elementor-extension' );
		}

		if( in_array('standard', $options ) ) {
			$colors['green'] = esc_html__( 'Green', 'impeka-elementor-extension' );
			$colors['orange'] = esc_html__( 'Orange', 'impeka-elementor-extension' );
			$colors['red'] = esc_html__( 'Red', 'impeka-elementor-extension' );
			$colors['blue'] = esc_html__( 'Blue', 'impeka-elementor-extension' );
			$colors['aqua'] = esc_html__( 'Aqua', 'impeka-elementor-extension' );
			$colors['purple'] = esc_html__( 'Purple', 'impeka-elementor-extension' );
			$colors['black'] = esc_html__( 'Black', 'impeka-elementor-extension' );
			$colors['grey'] = esc_html__( 'Grey', 'impeka-elementor-extension' );
			$colors['dark-grey'] = esc_html__( 'Dark Grey', 'impeka-elementor-extension' );
			$colors['light-grey'] = esc_html__( 'Light Grey', 'impeka-elementor-extension' );
			$colors['white'] = esc_html__( 'White', 'impeka-elementor-extension' );
		}

		if( in_array('custom', $options ) ) {
			$colors['custom'] = esc_html__( 'Custom', 'impeka-elementor-extension' );
		}

		if( in_array('dominant', $options ) ) {
			$colors['dominant'] = esc_html__( 'Image Dominant', 'impeka-elementor-extension' );
		}

		return $colors;
	}
}

/**
 * Helper function to get custom fields with fallback
 */
 function impeka_elementor_ext_get_theme_icons() {
	return
	[
		'arrow-1' => esc_html__( 'Arrow 1', 'impeka-elementor-extension' ),
		'arrow-2' => esc_html__( 'Arrow 2', 'impeka-elementor-extension' ),
		'video-1' => esc_html__( 'Video', 'impeka-elementor-extension' ),
		'plus' => esc_html__( 'Plus', 'impeka-elementor-extension' ),
		'quote-1' => esc_html__( 'Quote', 'impeka-elementor-extension' ),
		'link' => esc_html__( 'Link', 'impeka-elementor-extension' ),
		'backlink' => esc_html__( 'Backlink', 'impeka-elementor-extension' ),
		'search' => esc_html__( 'Search', 'impeka-elementor-extension' ),
		'share' => esc_html__( 'Share', 'impeka-elementor-extension' ),
		'heart' => esc_html__( 'Heart', 'impeka-elementor-extension' ),
		'tooltip' => esc_html__( 'Tooltip', 'impeka-elementor-extension' ),
		'burger-2' => esc_html__( 'Burger', 'impeka-elementor-extension' ),
	];
}

/**
 * Helper function to get custom fields with fallback
 */
if ( !function_exists( 'impeka_elementor_ext_post_meta' ) ) {
	function impeka_elementor_ext_post_meta( $id, $fallback = false ) {
		global $post;
		$post_id = $post->ID;
		if ( $fallback == false ) $fallback = '';
		$post_meta = get_post_meta( $post_id, $id, true );
		$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
		return $output;
	}
}

 /**
 * Fetch Menus
 * Used in shortcodes to generate the list of menus ( back end )
 */
function impeka_elementor_ext_get_menus() {
	$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );

	$custom_menus = array( "" => esc_html__( "None", "impeka-elementor-extension" ) );
	if ( is_array( $menus ) && ! empty( $menus ) ) {
		foreach ( $menus as $single_menu ) {
			if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
				$custom_menus[ $single_menu->term_id] = $single_menu->name ;
			}
		}
	}
	return $custom_menus;
}

 /**
 * Fetch Area Items
 * Used in shortcodes to generate the list of area items ( back end )
 */
function impeka_elementor_ext_get_area_items() {
	$area_items = array( "" => esc_html__( "None", "impeka-elementor-extension" ) );
	$area_item_posts = get_posts( array(
		'posts_per_page' => '-1',
		'orderby' => 'post_title',
		'post_status'=>'publish',
		'post_type' => 'area-item',
	) );
	if ( !empty( $area_item_posts ) ) {
		foreach ( $area_item_posts as $post ) {
			$area_items[ $post->ID ] = esc_html( $post->post_title );
		}
		wp_reset_postdata();
	}
	return $area_items;
}

 /**
 * Fetch Post Categories
 * Used in widgets to generate the list of used categories ( back end )
 */
function impeka_elementor_ext_get_post_categories( $term_slug = 'category' ) {
	$category = array();

	$cats = get_terms( $term_slug );
	if ( is_array( $cats ) ) {
	  foreach ( $cats as $cat ) {
		$category[$cat->term_id] = $cat->name;
	  }
	}
	return $category;
}


function impeka_elementor_ext_get_blog_class( $mode = 'large'  ) {

	switch( $mode ) {

		case 'small':
			$class = 'grve-blog grve-blog-small grve-isotope';
			break;
		case 'masonry':
			$class = 'grve-blog grve-blog-columns grve-blog-masonry grve-isotope';
			break;
		case 'grid':
			$class = 'grve-blog grve-blog-columns grve-blog-grid grve-isotope';
			break;
		case 'large':
		default:
			$class = 'grve-blog grve-blog-large grve-non-isotope';
			break;

	}
	return $class;

}

function impeka_elementor_print_filters( $atts = array() ) {
	if ( function_exists( 'impeka_grve_print_filters' ) ) {
		impeka_grve_print_filters( $atts );
	}
}

function impeka_elementor_ext_locate_template( $path, $params = null ) {
	$located = locate_template( array(
		'impeka-elementor-extension' . DIRECTORY_SEPARATOR . $path,
	) );
	$plugin_path = IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'templates' . DIRECTORY_SEPARATOR . $path;
	if ( ! $located && file_exists( $plugin_path ) ) {
		$final_file = $plugin_path;
	} elseif ( $located ) {
		$final_file = $located;
	}
	if( is_array( $params ) && count( $params ) ) {
		extract( $params );
	}
	ob_start();
	$final_file = apply_filters( 'impeka_elementor_ext_locate_template', $final_file, $params, $path );
	include( $final_file );
	return ob_get_clean();
}

function impeka_elementor_ext_get_grid_layout_atts( $params = array() ) {
	if ( function_exists( 'impeka_grve_get_grid_layout_atts' ) ) {
		return impeka_grve_get_grid_layout_atts( $params );
	} else {
		return array();
	}
}

function impeka_elementor_print_pagination( $params = array() ) {
	if ( function_exists( 'impeka_grve_paginate_links' ) ) {
		impeka_grve_paginate_links( 'element', $params );
	}
}

function impeka_elementor_ext_get_video_icon( $color = 'white', $position = '' ) {
	if ( function_exists( 'impeka_grve_get_video_icon' ) ) {
		return impeka_grve_get_video_icon( $color, $position );
	}
}

function impeka_elementor_ext_print_image_filters( $atts = array()) {
	if ( function_exists( 'impeka_grve_print_image_filters' ) ) {
		impeka_grve_print_image_filters( $atts );
	}
}

function impeka_elementor_ext_increase_heading_reset( $increase_heading_reset, $title_classes = array() ) {
	switch( $increase_heading_reset ) {
		case 'desktop-sm':
			$title_classes[] = 'grve-desktop-sm-reset-increase-heading';
			$title_classes[] = 'grve-tablet-reset-increase-heading';
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'tablet':
			$title_classes[] = 'grve-tablet-reset-increase-heading';
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'tablet-sm':
			$title_classes[] = 'grve-tablet-sm-reset-increase-heading';
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		case 'mobile':
			$title_classes[] = 'grve-mobile-reset-increase-heading';
		break;
		default:
		break;
	}
	return $title_classes;
}

function impeka_elementor_ext_post_bg_image_container( $options = array() ) {
	if ( function_exists( 'impeka_grve_print_post_bg_image_container' ) ) {
		impeka_grve_print_post_bg_image_container( $options );
	}
}

function impeka_elementor_ext_get_image_html( $atts = array() ) {

	$image = impeka_elementor_ext_array_value( $atts, 'image' );
	$retina_image = impeka_elementor_ext_array_value( $atts, 'retina_image' );
	$image_mode_size = impeka_elementor_ext_array_value( $atts, 'image_mode_size' );
	$fallback_image_mode_size = impeka_elementor_ext_array_value( $atts, 'fallback_image_mode_size', $image_mode_size );
	$image_popup_size_mode = impeka_elementor_ext_array_value( $atts, 'image_popup_size_mode' );
	$image_load_mode = impeka_elementor_ext_array_value( $atts, 'image_load_mode' );
	$column_space = impeka_elementor_ext_array_value( $atts, 'column_space', 'auto' );
	$wrapper = impeka_elementor_ext_array_value( $atts, 'wrapper', 'no' );

	$image_html = '';
	if ( !empty( $image ) ) {
		$img_id = impeka_elementor_ext_array_value( $image, 'id' );
		$img_src = wp_get_attachment_image_src( $img_id, 'full' );
		if( $img_src !== false ) {
			$img_url = $img_src[0];
			if ( !empty( $retina_image ) ) {
				$img_retina_id = impeka_elementor_ext_array_value( $retina_image, 'id' );
				$img_retina_src = wp_get_attachment_image_src( $img_retina_id, 'full' );
				if( $img_retina_src !== false ) {
					$retina_url = $img_retina_src[0];
					$image_srcset = $img_url . ' 1x,' . $retina_url . ' 2x';
					if( 'yes' == $wrapper ) {
						$image_html = impeka_elementor_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'srcset'=> $image_srcset, 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					} else {
						$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'srcset'=> $image_srcset, 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					}
				} else {
					if( 'yes' == $wrapper ) {
						$image_html = impeka_elementor_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					} else {
						$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
					}
				}
			} else {
				if( 'yes' == $wrapper ) {
					$image_html = impeka_elementor_ext_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
				} else {
					$image_html = wp_get_attachment_image( $img_id, $image_mode_size , "", array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );
				}
			}
		}
	}

	if ( empty( $image_html ) ) {
		if( 'yes' == $wrapper ) {
			$image_html = impeka_elementor_ext_get_fallback_image_wrapper( $fallback_image_mode_size  );
		} else {
			$image_html = impeka_elementor_ext_get_fallback_image( $fallback_image_mode_size  );
		}
	}

	return $image_html;
}

function impeka_elementor_ext_get_image_popup_url( $atts = array() ) {
	$image = impeka_elementor_ext_array_value( $atts, 'image' );
	$retina_image = impeka_elementor_ext_array_value( $atts, 'retina_image' );
	$image_popup_size_mode = impeka_elementor_ext_array_value( $atts, 'image_popup_size_mode' );
	$img_url = '';
	if ( !empty( $image ) ) {
		$img_id = impeka_elementor_ext_array_value( $image, 'id' );
		$img_src = wp_get_attachment_image_src( $img_id, $image_popup_size_mode );
		if( $img_src !== false ) {
			$img_url = $img_src[0];
			if ( !empty( $retina_image ) ) {
				$img_retina_id = impeka_elementor_ext_array_value( $retina_image, 'id' );
				$img_retina_src = wp_get_attachment_image_src( $img_retina_id, $image_popup_size_mode );
				if( $img_retina_src !== false ) {
					$img_url = $img_retina_src[0];
				}
			}
		}
	}
	if ( empty( $img_url ) ) {
		$img_url = impeka_elementor_ext_get_fallback_image( $image_popup_size_mode, 'url'  );
	}
	return $img_url;
}

function impeka_elementor_ext_img_style( $bg_image = '' , $bg_image_size = 'full' ) {
	$style = '';
	if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, $bg_image_size )) !== false) {
		$image_url = $attachment_src[0];
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	} else {
		$image_url = impeka_elementor_ext_get_fallback_image( $bg_image_size ,'url' );
		$style .= "background-image: url(" . esc_url( $image_url ) . ");";
	}
	return ' style="' . $style . '"';
}

function impeka_elementor_ext_img_url( $bg_image = '' , $bg_image_size = 'full' ) {
	$image_url = "";
	if((int)$bg_image > 0 && ($attachment_src = wp_get_attachment_image_src( $bg_image, $bg_image_size )) !== false) {
		$image_url = $attachment_src[0];
	}
	return $image_url;
}

function impeka_elementor_ext_get_image_size( $image_mode = 'full', $index = 1 ) {
	if ( function_exists( 'impeka_grve_get_image_size' ) ) {
		return impeka_grve_get_image_size( $image_mode, $index );
	} else {
		return 'large';
	}
}

function impeka_elementor_ext_get_fallback_image_attr( $size = '' ) {
	$image_atts = array();
	if ( function_exists( 'impeka_grve_get_fallback_image_attr' ) ) {
		return impeka_grve_get_fallback_image_attr( $size );
	} else {
		return $image_atts;
	}
}

function impeka_elementor_ext_get_attachment_image( $id, $size = 'thumbnail', $icon = false, $attr = '' ) {
	if ( function_exists( 'impeka_grve_get_attachment_image' ) ) {
		return impeka_grve_get_attachment_image( $id, $size , $icon, $attr );
	} else {
		return wp_get_attachment_image( $id, $size , $icon, $attr );
	}
}

function impeka_elementor_ext_the_post_thumbnail( $size = 'thumbnail', $attr = '' ) {
	if ( function_exists( 'impeka_grve_the_post_thumbnail' ) ) {
		impeka_grve_the_post_thumbnail( $size , $attr );
	} else {
		the_post_thumbnail( $size, $attr );
	}
}

function impeka_elementor_ext_get_fallback_image( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image' ) ) {
		return impeka_grve_get_fallback_image( $size, $mode, $url );
	}
	return '';
}

function impeka_elementor_ext_get_fallback_image_wrapper( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image_wrapper' ) ) {
		return impeka_grve_get_fallback_image_wrapper( $size, $mode, $url );
	}
	return '';
}

function impeka_elementor_ext_get_all_image_sizes() {
    global $_wp_additional_image_sizes;
    $default_image_sizes = get_intermediate_image_sizes();
    foreach ( $default_image_sizes as $size ) {
        $image_sizes[ $size ][ 'width' ] = intval( get_option( "{$size}_size_w" ) );
        $image_sizes[ $size ][ 'height' ] = intval( get_option( "{$size}_size_h" ) );
        $image_sizes[ $size ][ 'crop' ] = get_option( "{$size}_crop" ) ? get_option( "{$size}_crop" ) : false;
    }
    if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) ) {
        $image_sizes = array_merge( $image_sizes, $_wp_additional_image_sizes );
    }
    return $image_sizes;
}

function impeka_elementor_ext_add_image_dimensions( $options ) {
    $image_sizes = impeka_elementor_ext_get_all_image_sizes();
	$new_options =  array();

	foreach ( $options as $image_mode => $desc ) {
		$size = impeka_elementor_ext_get_image_size( $image_mode );
		if ( isset( $image_sizes[$size] ) ) {
			$dim = ' - ' . $image_sizes[$size]['width'] . 'x' . $image_sizes[$size]['height'] ;
			$new_options[ $image_mode ] = $desc . $dim;
		} else {
			$new_options[ $image_mode ] = $desc ;
		}
    }
    return $new_options;
}
add_filter( 'impeka_elementor_ext_image_options', 'impeka_elementor_ext_add_image_dimensions' );

function impeka_elementor_ext_get_custom_masonry_data( $size = 'square' ) {
	if ( function_exists( 'impeka_grve_get_custom_masonry_data' ) ) {
		return impeka_grve_get_custom_masonry_data( $size );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}

function impeka_elementor_ext_get_masonry_data( $index, $columns ) {
	if ( function_exists( 'impeka_grve_get_masonry_data' ) ) {
		return impeka_grve_get_masonry_data( $index, $columns );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}

function impeka_elementor_ext_get_broken_grid_data( $index, $layout ) {
	if ( function_exists( 'impeka_grve_get_broken_grid_data' ) ) {
		return impeka_grve_get_broken_grid_data( $index, $layout );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}
 /**
 * Generates a button
 * Used in widgets to display a button
 */
function impeka_elementor_ext_get_button( $btn_options, $index = '' ) {

	//Extra Class
	$btn_fluid = impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_fluid' );
	$btn_fluid_height = impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_fluid_height' );
	$extra_class = '';
	if ( 'yes' == $btn_fluid ) {
		$extra_class = 'grve-fullwidth-btn grve-fluid-btn-' . $btn_fluid_height;
	}

	//Link
	$btn_link = impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_link' );
    $link_atts = impeka_elementor_ext_get_link_attributes( $btn_link );

    $button_params = array(
		'link_atts' => $link_atts,
		'text' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_text' ),
		'sr_text' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_sr_text' ),
		'type' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_type' ),
		'size' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_size' ),
		'color' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_color' ),
		'hover_color' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_hover_color' ),
		'color_gradient' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_color_gradient' ),
		'hover_color_gradient' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_hover_color_gradient' ),
		'line_color' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_line_color' ),
		'line_position' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_line_position' ),
		'shape' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_shape' ),
		'shadow' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_shadow' ),
		'hover_action' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_hover_action' ),
		'icon_type' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_icon_type' ),
		'svg_icon' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon' ),
		'svg_icon_shape' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape' ),
		'svg_icon_shape_type' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape_type' ),
		'svg_icon_color' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_color' ),
		'svg_icon_shape_color' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_svg_icon_shape_color' ),
		'video_icon_shape' =>  impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape' ),
		'video_icon_shape_type' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_type' ),
		'video_icon_shape_color' =>impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_color' ),
		'video_icon_shape_hover_color' =>impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_video_icon_shape_hover_color' ),
		'class' => impeka_elementor_ext_array_value( $btn_options, 'btn' . $index . '_class' ),
		'extra_class' => $extra_class,
	);

	ob_start();
	get_template_part( 'templates/general/button', '', $button_params );
	return ob_get_clean();
}

function impeka_elementor_ext_has_link( $link = ''  ) {

	$use_link = false;

	if ( !empty( $link ) ){
		if ( strlen( $link['url'] ) > 0 ) {
			$use_link = true;
		}
	}

	return $use_link;
}

function impeka_elementor_ext_get_link_attributes( $link = '', $class = '' ) {
	$attributes = array();
	$href = $is_external = $nofollow = '';
	$use_link = false;

	if ( !empty( $link ) ){
		if ( strlen( $link['url'] ) > 0 ) {
			$use_link = true;
			$href = $link['url'];
			$is_external = $link['is_external'];
			$nofollow = $link['nofollow'];
		}
	}
	if ( $use_link ) {
		$attributes[] = 'href="' . esc_url( $href ) . '"';
		if ( 'on' == $is_external ) {
			$attributes[] = 'target="_blank"';
		}
		if ( 'on' == $nofollow ) {
			$attributes[] = 'rel="nofollow"';
		}
	} else {
		$attributes[] = 'href="#"';
	}

	if ( !empty( $class ) ){
		$attributes[] = 'class="' . esc_attr( $class ) . '"';
	}

	return $attributes;
}


 /**
 * Generates dimension string to concat in attribute style
 */
function impeka_elementor_ext_build_dimension( $dimension, $value ) {
	$fixed_dimension = '';

	if( ! empty( $dimension ) &&  ! empty( $value )  ) {
		$fixed_dimension .= $dimension . ': '.(preg_match('/(px|em|\%|pt|cm)$/', $value) ? $value : $value.'px').';';
	}
	return $fixed_dimension;
}

 /**
 * Generates margin-bottom string to concat in attribute style
 */
function impeka_elementor_ext_build_margin_bottom_style( $margin_bottom ) {
	$style = '';
	if( $margin_bottom != '' ) {
		$style .= 'margin-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $margin_bottom) ? $margin_bottom : $margin_bottom .'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-top string to concat in attribute style
 */
function impeka_elementor_ext_build_padding_top_style( $padding_top ) {
	$style = '';
	if( $padding_top != '' ) {
		$style .= 'padding-top: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_top) ? $padding_top : $padding_top.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-bottom string to concat in attribute style
 */
function impeka_elementor_ext_build_padding_bottom_style( $padding_bottom ) {
	$style = '';
	if( $padding_bottom != '' ) {
		$style .= 'padding-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_bottom) ? $padding_bottom : $padding_bottom.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

function impeka_elementor_ext_build_svg_icon( $icon_options = array() ) {
	if ( function_exists( 'impeka_grve_build_svg_icon' ) ) {
		return impeka_grve_build_svg_icon( $icon_options );
	}
}

function impeka_elementor_ext_get_svg_icon( $icon = 'arrow-1' ) {
	if ( function_exists('impeka_grve_get_svg_icon') ) {
		return impeka_grve_get_svg_icon( $icon );
	}
}


function impeka_elementor_ext_text_to_bool( $value ) {
	if ( 'yes' == $value ) {
		return 'true';
	}
	return 'false';
}

function impeka_elementor_ext_unautop( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "\n\n", $s);
    return $s;
}

function impeka_elementor_ext_auto_br( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "<br>", $s);
    return $s;
}

/**
 * Returns excerpt
 */
function impeka_elementor_ext_excerpt( $excerpt_length = '15', $excerpt_more = "", $excerpt_more_text = "" ) {
	if ( function_exists('impeka_grve_excerpt') ) {
		return impeka_grve_excerpt( $excerpt_length, $excerpt_more, $excerpt_more_text );
	}
	return "";
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
