<?php
	namespace Impeka_Elementor_Extension;
	use Elementor\Plugin;
	use Elementor\TemplateLibrary\Source_Base;
	use Elementor\TemplateLibrary\Source_Local;
	use Elementor\Core\Common\Modules\Ajax\Module as Ajax;
	use Elementor\User;
	class Impeka_Elementor_Ext_Templates_Library{
		public static function init(){
			add_action('elementor/init',[__CLASS__,'register_source']);
			add_action('elementor/editor/after_enqueue_scripts',[__CLASS__,'enqueue_editor_scripts']);
			add_action('elementor/ajax/register_actions',[__CLASS__,'register_ajax_actions']);
			add_action('elementor/editor/footer',[__CLASS__,'render_template']);
		}
		public static function logo(){
			return IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/images/adminmenu/theme.svg';
		}
		public static function register_source(){
			Plugin::$instance->templates_manager->register_source( __NAMESPACE__ . '\Impeka_Elementor_Ext_Templates_Source');
		}
		public static function enqueue_editor_scripts(){
			wp_enqueue_script('impeka-elementor-ext-templates-lib', IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . 'assets/js/ext-elementor-templates-lib.min.js',['jquery','backbone-marionette','backbone-radio','elementor-common-modules','elementor-dialog',],IMPEKA_ELEMENTOR_EXT_VERSION,true);
			wp_localize_script('impeka-elementor-ext-templates-lib','impeka_ext_templates_lib',array('logoUrl'=>self::logo(),));
		}
		public static function register_ajax_actions(Ajax $ajax){
			$library_ajax_requests=['impeka_ext_get_library_data',];
			foreach($library_ajax_requests as $ajax_request){
				$ajax->register_ajax_action($ajax_request,function($data)use($ajax_request){
					return self::handle_ajax_request($ajax_request,$data);
				});
			}
		}
		private static function handle_ajax_request($ajax_request,array $data){
			if(!User::is_current_user_can_edit_post_type(Source_Local::CPT)){
				throw new \Exception('Access Denied');
			}
			if(!empty($data['editor_post_id'])){
				$editor_post_id=absint($data['editor_post_id']);
				if(!get_post($editor_post_id)){
					throw new \Exception(__('Post not found.','impeka-elementor-extension'));
				}
				Plugin::$instance->db->switch_to_post($editor_post_id);
			}
			$result=call_user_func([__CLASS__,$ajax_request],$data);
			if(is_wp_error($result)){
				throw new \Exception($result->get_error_message());
			}
			return $result;
		}
		public static function impeka_ext_get_library_data(array $args){
			$library_data=self::get_library_data(!empty($args['sync']));
			Plugin::$instance->documents->get_document_types();
			return[
				'templates'=>self::get_templates(),
				'config'=>$library_data['types_data'],
			];
		}
		public static function get_library_data($force_update=false){
			return self::get_templates_data($force_update);
		}
		private static function get_templates_data($force_update=false){
			$templates=[];

			$import_file = IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'template-library/templates.json' ;
			if ( file_exists( $import_file ) && self::is_theme_registered() ) {
				$raw_data = file_get_contents( $import_file );
				$info_data = json_decode( $raw_data, true );
				$templates = $info_data['library'];
			}
			return $templates;
		}
		public static function get_templates(){
			$source = Plugin::$instance->templates_manager->get_source('impeka_ext');
			return $source->get_items();

		}
		public static function get_template_content($template_id){
			$data = [];
			$import_file = IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_PATH . 'template-library/templates/' . $template_id . '.json' ;
			if ( file_exists( $import_file ) ) {
				$raw_data = file_get_contents( $import_file );
				$data = json_decode( $raw_data, true );
			}
			return $data;
		}
		public static function is_theme_registered() {
			if ( function_exists( 'impeka_grve_check_theme_status') ) {
				return impeka_grve_check_theme_status( 'import' );
			}
			return false;
		}
		public static function render_template(){
		?>
		<script type="text/template" id="tmpl-elementor-template-library-header-actions-impeka-ext">
			<div id="elementor-template-library-header-sync" class="elementor-templates-modal__header__item">
				<i class="eicon-sync" aria-hidden="true" title="<?php esc_attr_e('Sync Templates','impeka-elementor-extension'); ?>"></i>
				<span class="elementor-screen-only"><?php echo esc_html__('Sync Templates','impeka-elementor-extension'); ?></span>
			</div>
		</script>
		<script type="text/template" id="tmpl-elementor-templates-modal__header__logo-impeka-ext">
			<span class="elementor-templates-modal__header__logo__icon-wrapper">
				<img src="<?php echo esc_url(self::logo()); ?>" style="height: 30px;" />
			</span>
			<span class="elementor-templates-modal__header__logo__title">{{{ title }}}</span>
		</script>
		<script type="text/template" id="tmpl-elementor-template-library-header-preview-impeka-ext">
			<div id="elementor-template-library-header-preview-insert-wrapper" class="elementor-templates-modal__header__item">
				{{{ impeka_ext_templates_lib.templates.layout.getTemplateActionButton( obj ) }}}
			</div>
		</script>
		<script type="text/template" id="tmpl-elementor-template-library-templates-impeka-ext">
			<#
				var activeSource = impeka_ext_templates_lib.templates.getFilter('source');
			#>
			<div id="elementor-template-library-toolbar">
				<# if ( 'impeka_ext' === activeSource ) {
					var activeType = impeka_ext_templates_lib.templates.getFilter('type');
					#>
					<div id="elementor-template-library-filter-toolbar-remote" class="elementor-template-library-filter-toolbar">
						<# if ( 'new_page' === activeType ) { #>
							<div id="elementor-template-library-order">
								<input type="radio" id="elementor-template-library-order-new" class="elementor-template-library-order-input" name="elementor-template-library-order" value="date">
								<label for="elementor-template-library-order-new" class="elementor-template-library-order-label"><?php echo esc_html__('New','impeka-elementor-extension'); ?></label>
								<input type="radio" id="elementor-template-library-order-trend" class="elementor-template-library-order-input" name="elementor-template-library-order" value="trendIndex">
								<label for="elementor-template-library-order-trend" class="elementor-template-library-order-label"><?php echo esc_html__('Trend','impeka-elementor-extension'); ?></label>
								<input type="radio" id="elementor-template-library-order-popular" class="elementor-template-library-order-input" name="elementor-template-library-order" value="popularityIndex">
								<label for="elementor-template-library-order-popular" class="elementor-template-library-order-label"><?php echo esc_html__('Popular','impeka-elementor-extension'); ?></label>
							</div>
						<# } else {
							var config = impeka_ext_templates_lib.templates.getConfig( activeType );
							if ( config.categories ) { #>
								<div id="elementor-template-library-filter">
									<select id="elementor-template-library-filter-subtype" class="elementor-template-library-filter-select" data-elementor-filter="subtype">
										<option></option>
										<# config.categories.forEach( function( category ) {
											var selected = category === impeka_ext_templates_lib.templates.getFilter( 'subtype' ) ? ' selected' : '';
											#>
											<option value="{{ category }}"{{{ selected }}}>{{{ category }}}</option>
										<# } ); #>
									</select>
								</div>
							<# }
						} #>
						<div id="elementor-template-library-my-favorites">
							<# var checked = impeka_ext_templates_lib.templates.getFilter( 'favorite' ) ? ' checked' : ''; #>
							<input id="elementor-template-library-filter-my-favorites" type="checkbox"{{{ checked }}}>
							<label id="elementor-template-library-filter-my-favorites-label" for="elementor-template-library-filter-my-favorites">
								<i class="eicon" aria-hidden="true"></i>
								<?php echo esc_html__('My Favorites','impeka-elementor-extension'); ?>
							</label>
						</div>
					</div>
				<# } #>
				<div id="elementor-template-library-filter-text-wrapper">
					<label for="elementor-template-library-filter-text" class="elementor-screen-only"><?php echo esc_html__('Search Templates:','impeka-elementor-extension'); ?></label>
					<input id="elementor-template-library-filter-text" placeholder="<?php echo esc_attr__('Search','impeka-elementor-extension'); ?>">
					<i class="eicon-search"></i>
				</div>
			</div>
			<div id="elementor-template-library-templates-container"></div>
				<?php if ( ! self::is_theme_registered() ) { ?>
				<div id="elementor-template-library-theme-license-impeka-ext" style="margin-top: 100px;">
					<div class="elementor-template-library-theme-license-norice-impeka-ext">
						<strong><?php esc_html_e( 'Theme is not registered! ', 'impeka-elementor-extension' ); ?></strong>
						<br>
						<?php esc_html_e( "In order to import theme templates it is required to register your product.", 'impeka-elementor-extension' ); ?>
						<br><br>
					</div>
					<a class="elementor-template-library-template-action elementor-button" href="<?php echo admin_url('/admin.php?page=impeka'); ?>">
						<i class="eicon-lock"></i>
						<span class="elementor-button-title"><?php _e('Enter License Key','impeka-elementor-extension'); ?></span>
					</a>
				</div>
				<?php } else { ?>
				<# if ( 'impeka_ext' === activeSource ) { #>
					<div id="elementor-template-library-footer-banner">
						<img class="elementor-nerd-box-icon" src="<?php echo esc_url(ELEMENTOR_ASSETS_URL.'images/information.svg'); ?>" />
						<div class="elementor-excerpt"><?php echo esc_html__('Stay tuned! More awesome templates coming soon.','impeka-elementor-extension'); ?></div>
					</div>
				<# } #>
				<?php } ?>
		</script>
		<script type="text/template" id="tmpl-elementor-template-library-template-impeka-ext">
			<div class="elementor-template-library-template-body">
				<# if ( 'page' === type ) { #>
					<div class="elementor-template-library-template-screenshot" style="background-image: url({{ thumbnail }});"></div>
				<# } else { #>
					<img src="{{ thumbnail }}">
				<# } #>
				<# if ( '' !== url ) { #>
					<div class="elementor-template-library-template-preview">
						<i class="eicon-zoom-in-bold" aria-hidden="true"></i>
					</div>
				<# } #>
			</div>
			<div class="elementor-template-library-template-footer">
				{{{ impeka_ext_templates_lib.templates.layout.getTemplateActionButton( obj ) }}}
				<div class="elementor-template-library-template-name">{{{ title }}} - {{{ type }}}</div>
				<div class="elementor-template-library-favorite">
					<input id="elementor-template-library-template-{{ template_id }}-favorite-input" class="elementor-template-library-template-favorite-input" type="checkbox"{{ favorite ? " checked" : "" }}>
					<label for="elementor-template-library-template-{{ template_id }}-favorite-input" class="elementor-template-library-template-favorite-label">
						<i class="eicon-heart-o" aria-hidden="true"></i>
						<span class="elementor-screen-only"><?php echo esc_html__('Favorite','impeka-elementor-extension'); ?></span>
					</label>
				</div>
			</div>
		</script>
		<?php
		}
	}
	Impeka_Elementor_Ext_Templates_Library::init();

	if ( class_exists('Elementor\TemplateLibrary\Source_Base') ) {
		class Impeka_Elementor_Ext_Templates_Source extends Source_Base {
			public function get_id(){
				return 'impeka_ext';
			}
			public function get_title(){
				return esc_html__('Impeka Elementor Library','impeka-elementor-extension');
			}
			public function register_data(){}

			public function get_items($args=[]){
				$library_data = Impeka_Elementor_Ext_Templates_Library::get_library_data();
				$templates=[];
				$pro_status='inactive';
				if(!empty($library_data['templates'])){
					foreach( $library_data['templates'] as $template_data ){
						$data = $this->prepare_template($template_data);
						$data['proStatus']=$pro_status;

						if ( empty( $data['thumbnail'] ) ) {
							$data['thumbnail'] = IMPEKA_ELEMENTOR_EXT_PLUGIN_DIR_URL . '/template-library/templates/' . $template_data['id'] . '.jpeg';
						}

						$templates[]=$data;
					}
				}
				return $templates;
			}
			public function get_item($template_id){
				$templates=$this->get_items();
				return $templates[$template_id];
			}
			public function save_item($template_data){
				return new \WP_Error('invalid_request','Cannot save template to a remote source');
			}
			public function update_item($new_data){
				return new \WP_Error('invalid_request','Cannot update template to a remote source');
			}
			public function delete_template($template_id){
				return new \WP_Error('invalid_request','Cannot delete template from a remote source');
			}
			public function export_template($template_id){
				return new \WP_Error('invalid_request','Cannot export template from a remote source');
			}
			public function get_data(array $args,$context='display'){
				$data=Impeka_Elementor_Ext_Templates_Library::get_template_content($args['template_id']);
				$data=(array) $data;
				$data['content']=$this->replace_elements_ids($data['content']);
				$data['content']=$this->process_export_import_content($data['content'],'on_import');
				$post_id=$args['editor_post_id'];
				$document=Plugin::$instance->documents->get($post_id);
				if($document){
					$data['content']=$document->get_elements_raw_data($data['content'],true);
				}
				return $data;
			}
			private function prepare_template(array $template_data){
				$favorite_templates=$this->get_user_meta('favorites');
				return[
					'template_id'=>$template_data['id'],
					'source'=>$this->get_id(),
					'type'=>$template_data['type'],
					'subtype'=>$template_data['subtype'],
					'title'=>$template_data['title'],
					'thumbnail'=>$template_data['thumbnail'],
					'date'=>$template_data['tmpl_created'],
					'author'=>$template_data['author'],
					'tags'=>json_decode($template_data['tags']),
					'isPro'=>$template_data['is_pro'],
					'url'=>$template_data['url'],
					'favorite'=>!empty($favorite_templates[$template_data['id']]),
				];
			}
		}
	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
