<?php
/**
 * Blog Leader Template
 */

extract( $atts );

$image_size = impeka_elementor_ext_get_image_size( $image_mode );

$blog_params = array(
	'mode' => 'leader',
	'meta_color' => 'white',
	'author_visibility' => $show_author,
	'date_visibility' => $show_date,
	'comments_visibility' => $show_comments,
	'like_visibility' => $show_like,
	'excerpt_length' => $excerpt_length,
	'excerpt_more' => $excerpt_more,
	'excerpt_more_text' => $excerpt_more_text,
	'image_size' => $image_size,
	'animation' => $grve_animation,
	'animation_delay' => $grve_animation_delay,
	'animation_duration' => $grve_animation_duration,
	'heading_tag' => $heading_tag,
	'heading' => $heading,
	'small_post_heading' => $small_post_heading,
	'overlay_color' => $overlay_color,
	'overlay_opacity' => $overlay_opacity,
);

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-blog-leader', 'grve-layout-1' );
if( !empty ( $leader_style ) ) {
	$element_classes[] = 'grve-' . $leader_style;
}
$element_classes[] = 'grve-blog-items-' . $posts_per_page;
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Query args
$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__in' => $include_ids,
		'paged' => 1,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__not_in' => $exclude_ids,
		'cat' => $categories,
		'paged' => 1,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
$index = 0;

$total = $query->post_count;

while ( $query->have_posts() ) : $query->the_post();
	$index++;
	if( 2 == $index ) {
		echo '<div class="grve-post-list">';
	}

	if( 1 == $index  ) {
		echo '<div class="grve-post-leader">';
		get_template_part( 'templates/post/leader/loop-post', 'leader', $blog_params );
		echo '</div>';
	} else {
		get_template_part( 'templates/post/leader/loop-post', 'list', $blog_params );
	}
endwhile;

if( $index > 1 ){
	echo '</div>';
}
?>
</div>
<?php
else :
	get_template_part( 'templates/post/post', 'none' );
endif;

wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
