<?php
/**
 * Counter Shortcode Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-counter' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Counter Number
$counter_number = array( 'grve-counter-item', 'grve-' . $counter_heading, 'grve-text-' . $counter_color );
if ( !empty( $counter_custom_font_family ) ) {
	$counter_number[] = 'grve-' . $counter_custom_font_family;
}
if( '100' != $increase_counter_heading ){
	$counter_number[] = 'grve-increase-heading';
	$counter_number[] = 'grve-heading-' . $increase_counter_heading;
}
$counter_number_class_string = implode( ' ', $counter_number );

//Title
$title_classes = array( 'grve-counter-title', 'grve-' . $heading );
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if ( 'inherit' != $title_color ) {
	$title_classes[]  = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );

if( 'yes' == $counter_prefix_space && !empty( $counter_prefix )  ) {
	$counter_prefix = $counter_prefix . ' ';
}

if( 'yes' == $counter_suffix_space && !empty( $counter_suffix ) ) {
	$counter_suffix = ' ' . $counter_suffix;
}

$counter_attributes = array();
$counter_attributes[] = 'data-thousands-separator-vis="' . esc_attr( $counter_thousands_separator_vis ) . '"';
$counter_attributes[] = 'data-thousands-separator="' . esc_attr( $counter_thousands_separator ) . '"';
$counter_attributes[] = 'data-prefix="' . esc_attr( $counter_prefix ) . '"';
$counter_attributes[] = 'data-suffix="' . esc_attr( $counter_suffix ) . '"';
$counter_attributes[] = 'data-start-val="' . esc_attr( $counter_start_val ) . '"';
$counter_attributes[] = 'data-end-val="' . esc_attr( $counter_end_val ) . '"';
$counter_attributes[] = 'data-decimal-points="' . esc_attr( $counter_decimal_points ) . '"';
$counter_attributes[] = 'data-decimal-separator="' . esc_attr( $counter_decimal_separator ) . '"';
$counter_attributes[] = '';

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

echo '<div class="grve-counter-content">';
echo '<div class="' . esc_attr( $counter_number_class_string ) . '">';
echo '<span ' . implode( ' ', $counter_attributes ) . '>' . esc_html( $counter_start_val ) . '</span>';
echo '</div>';
echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
echo '</div>';

echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
