<?php
/**
 * Events Template
 */

extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'default-event-id';
}
$el_id = 'el-' . $el_id;

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => $display_style,
	'animation' => $grve_animation,
);
$wrapper_attributes = impeka_elementor_ext_get_grid_layout_atts( $wrapper_params );

//Element Classes
$element_classes = array( 'grve-element', 'grve-event', 'grve-event-grid', 'grve-isotope'  );
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$element_classes[] = 'grve-with-gap';
}
if ( !empty ( $el_class ) ) {
	$element_classes[] =  $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Inner Classes
$isotope_inner_item_classes = array( 'grve-event-item-inner', 'grve-isotope-item-inner', 'grve-hover-item' );
if ( !empty( $animation ) ) {
	$isotope_inner_item_classes[] = $animation;
}
$isotope_inner_item_class_string = implode( ' ', $isotope_inner_item_classes );

$event_cat = "";
$category_ids = array();
$event_category_slugs = array();

if( ! empty( $categories ) ) {
	if( is_array( $categories ) ) {
		$category_ids = $categories;
	} else {
		$category_ids = explode( ",", $categories );
	}
	foreach ( $category_ids as $category_id ) {
		$category_term = get_term( $category_id, 'tribe_events_cat' );
		if ( isset( $category_term) ) {
			$event_category_slugs[] = $category_term->slug;
		}
	}
}

$paged = 1;

if ( ! empty( $display_style ) ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'tribe_events',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $items_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
	$filter = 'no';
} else {
	if( !empty( $event_category_slugs ) ) {
		$args = array(
			'post_type' => 'tribe_events',
			'post_status'=>'publish',
			'paged' => $paged,
			'tax_query' => array(
			  array(
				  'taxonomy' => 'tribe_events_cat',
				  'field' => 'slug',
				  'terms' => $event_category_slugs,
				  'operator' => 'IN'
			  ),
			),
			'post__not_in' => $exclude_ids,
			'posts_per_page' => $items_per_page,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'tribe_events',
			'post_status'=>'publish',
			'paged' => $paged,
			'post__not_in' => $exclude_ids,
			'posts_per_page' => $items_per_page,
			'orderby' => $order_by,
			'order' => $order,
		);
	}
}

if ( 'date' == $order_by ) {
	$args['orderby'] = 'meta_value';
	$args['meta_key'] = '_EventStartDate';
}

if ( 'yes' == $exclude_past_events ) {
	$args['meta_query'] = array(
		array(
			'key' => '_EventStartDate',
			'value' => date('Y-m-d H:i:s'),
			'compare' => '>=',
			'type' => 'DATE'
		)
	);
}

$query = new WP_Query( $args );

if ( $query->have_posts() ) :

//OUTPUT
?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php

if ( 'yes' == $filter ) {

	$filter_atts = array(
		'query' => $query,
		'category_name' => 'tribe_events_cat',
		'category_prefix_class' => 'tribe-events-category',
		'category_ids' => $category_ids,
		'filter_all_text' => $filter_all_text,
		'filter_style' => $filter_style,
		'filter_shape' => $filter_shape,
		'filter_color' => $filter_color,
		'filter_align' => $filter_align,
		'filter_order_by' => $filter_order_by,
		'filter_order' => $filter_order,
		'filter_gototop' => $filter_gototop,
	);
	impeka_elementor_print_filters( $filter_atts );

}
?>
	<div class="grve-isotope-container">
		<div class="grve-grid-sizer"></div>
<?php

//Image Size
if ( 'masonry' == $mode ) {
	$image_size = impeka_elementor_ext_get_image_size( $masonry_image_mode );
} else {
	$image_size = impeka_elementor_ext_get_image_size( $grid_image_mode );
}

$item_params = array(
	'type' => 'event',
	'overlay_color' => $overlay_color,
	'overlay_opacity' => $overlay_opacity,
	'image_size' => $image_size,
	'title_heading_tag' => $title_heading_tag,
	'title_heading' => $title_heading,
);

while ( $query->have_posts() ) : $query->the_post();
?>

	<div class="<?php tribe_events_event_classes(); ?> grve-entry-item grve-event-item">
		<div class="<?php echo esc_attr( $isotope_inner_item_class_string ); ?>">
			<?php get_template_part( 'templates/events/loop-event-content', '', $item_params ); ?>
		</div>
	</div>
<?php

endwhile;
?>
		</div>
<?php
	if ( ! empty( $display_style ) ) {
		impeka_elementor_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
			'load_more_title' => $load_more_title,
		));
	}
?>
	</div>

<?php

else :
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
