<?php
/**
 * Portfolio Carousel Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel', 'grve-portfolio-carousel' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$auto_play = impeka_elementor_ext_get_switcher_value( $auto_play );
$pagination = impeka_elementor_ext_get_switcher_value( $pagination );
$loop = impeka_elementor_ext_get_switcher_value( $loop );
$pause_hover = impeka_elementor_ext_get_switcher_value( $pause_hover );

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}

$carousel_classes = array( 'grve-carousel-element' );
if ( 'popup' == $link_type ) {
	$carousel_classes[] = 'grve-gallery-popup';
}
if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';

//Image Size
$image_size = impeka_elementor_ext_get_image_size( $image_mode );

//Image Popup Size
$image_popup_size_mode = 'extra-extra-large';
if ( 'popup' == $link_type ) {
	$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );
}

$portfolio_cat = "";
$category_ids = array();

if( ! empty( $categories ) ) {
	if( is_array( $categories ) ) {
		$category_ids = $categories;
	} else {
		$category_ids = explode( ",", $categories );
	}
	foreach ( $category_ids as $category_id ) {
		$category_term = get_term( $category_id, 'portfolio_category' );
		if ( isset( $category_term) ) {
			$portfolio_cat = $portfolio_cat.$category_term->slug . ', ';
		}
	}
}

$paged = 1;

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'portfolio',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'portfolio',
		'post_status'=>'publish',
		'paged' => $paged,
		'portfolio_category' => $portfolio_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
<?php

while ( $query->have_posts() ) : $query->the_post();

	//Link Attributes
	if ( function_exists('impeka_grve_get_portfolio_link_atts') ) {
		$link_atts = impeka_grve_get_portfolio_link_atts( $link_type, $image_popup_size_mode );
	} else {
		$link_atts = array();
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( get_permalink() ) . '"';
	}

	//Title and Caption
	$caption = $title = '';
	if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
		$title = get_the_title();
	}
	if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
		$caption = get_post_meta( get_the_ID(), '_impeka_grve_description', true );
	}

	//Portfolio Custom Overview
	$current_title_color = $title_color;
	$current_overlay_color = $overlay_color;
	$current_overlay_opacity = $overlay_opacity;
	$current_title_heading = $title_heading;
	if ( 'custom-overview' == $overview_type ) {
		$overview_mode = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_mode', true );
		if ( 'color' == $overview_mode ) {
			$overview_text = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text', true );
			$overview_text_heading = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text_heading', true );

			$overview_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_color', true );
			$overview_overlay_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_color', true );
			$overview_overlay_opacity = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_opacity', true );

			$current_title_color = !empty( $overview_color ) ? $overview_color : 'black';
			$current_overlay_color = !empty( $overview_overlay_color ) ? $overview_overlay_color : 'primary-1';
			$current_overlay_opacity = !empty( $overview_overlay_opacity ) ? $overview_overlay_opacity : '90';
			$current_title_heading = !empty( $overview_text_heading ) ? $overview_text_heading  : $title_heading;

			$title = !empty( $overview_text ) ? $overview_text : $title;
			if ( !empty( $overview_text ) ) {
				$caption = '';
			}
		}
	}
	$current_overlay_opacity = ( '0' == $current_overlay_opacity ) ? 'none' : $current_overlay_opacity;

	$portfolio_params = array(
		'element' => 'portfolio',
		'link_atts' => $link_atts,
		'style' => $style,
		'overlay_color' => $current_overlay_color,
		'overlay_opacity' => $current_overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $current_title_heading,
		'title_color' => $current_title_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
	);
?>
			<div <?php post_class( "grve-carousel-item" ); ?>>
				<?php get_template_part( 'templates/hover-item/hover-' . $style, '', $portfolio_params ); ?>
			</div>
<?php
endwhile;
?>
		</div>
	</div>
</div>
<?php

else :
	get_template_part( 'templates/portfolio/portfolio', 'none' );
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
