<?php
/**
 * Pricing Table Shortcode Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-pricing-table' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
$element_classes[] = 'grve-' . $layout;
$element_classes[] = 'grve-text-' . $color;
if ( 'none' != $radius ) {
	$element_classes[] = 'grve-radius-' . $radius;
}
if ( !empty( $shadow ) && 'none' != $shadow ) {
	$element_classes[] = 'grve-' . $shadow;
}
if( 'none' != $content_bg ){
	$element_classes[] = 'grve-bg-' . $content_bg;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Title
if ( !empty( $price ) ) {
	//Title Classes
	$price_classes = array( 'grve-price', 'grve-' . $heading  );
	if ( !empty( $custom_font_family ) ) {
		$price_classes[] = 'grve-' . $custom_font_family;
	}
	if( '100' != $increase_heading ){
		if( !empty( $increase_heading_reset ) ) {
			$price_classes = impeka_elementor_ext_increase_heading_reset( $increase_heading_reset, $price_classes );
		}
		$price_classes[] = 'grve-increase-heading';
		$price_classes[] = 'grve-heading-' . $increase_heading;
	}
	$price_class_string = implode( ' ', $price_classes );
}

// Border Classes
if ( 'layout-2' == $layout && !empty( $border ) ) {
	$border_classes = array( 'grve-price-border' );
	$border_classes[] = 'grve-' . $border;
	$border_classes[] = 'grve-bg-' . $border_color;
	$border_class_string = implode( ' ', $border_classes );
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
if ( 'layout-1' == $layout ) {
	if ( !empty( $title ) ) {
		echo '<div class="grve-pricing-title grve-' . esc_attr( $title_heading ) . '">' . wp_kses_post( $title ) . '</div>';
	}
	if ( !empty( $description ) ) {
		echo '<div class="grve-pricing-description">' . wp_kses_post( $description ) . '</div>';
	}
	echo '<div class="grve-pricing-content">';
		echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $price_class_string ) . '">';
		echo '<span class="grve-text-' . esc_attr( $price_color ) . '">' . wp_kses_post( $price ) . '</span>';
		if ( !empty( $interval ) ) {
			echo '<div class="grve-interval grve-text-' . esc_attr( $color ) . '">' . wp_kses_post( $interval ) . '</div>';
		}
		echo '</' . tag_escape( $heading_tag ) . '>';
	echo '</div>';

	echo '<ul>';
	if( !empty( $pricing_lines_data ) ) {
		foreach($pricing_lines_data as $line) {
			echo '<li>' .  wp_kses_post( $line['value1'] ) . ' ' .  wp_kses_post( $line['value2'] ) . '</li>';
		}
	}
	echo '</ul>';
} else {
	echo '<div class="grve-pricing-content">';
		echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $price_class_string ) . '">';
		echo '<span class="grve-text-' . esc_attr( $price_color ) . '">' . wp_kses_post( $price ) . '</span>';
		echo '</' . tag_escape( $heading_tag ) . '>';
	echo '</div>';
	if ( !empty( $title ) || !empty( $interval ) ) {
		echo '<div class="grve-pricing-title grve-' . esc_attr( $title_heading ) . '">';
		echo wp_kses_post( $title );
		if ( !empty( $interval ) ) {
			echo '<span class="grve-interval">' . wp_kses_post( $interval ) . '</span>';
		}
		echo '</div>';
	}
	if ( !empty( $description ) ) {
		echo '<div class="grve-pricing-description">' . wp_kses_post( $description ) . '</div>';
	}
}
	echo '<div class="grve-btn-wrapper">';
	echo impeka_elementor_ext_get_button( $atts );
	echo '</div>';
if ( 'layout-2' == $layout && !empty( $border ) ) {
	echo '<div class="' . esc_attr( $border_class_string ) . '"></div>';
}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
