<?php
/**
 * Typed Text Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-typed-text', 'grve-' . $heading );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $custom_font_family ) ) {
	$element_classes[] = 'grve-' . $custom_font_family;
}
if( '100' != $increase_heading ){
	if( !empty( $increase_heading_reset ) ) {
		$element_classes = impeka_elementor_ext_increase_heading_reset( $increase_heading_reset, $element_classes );
	}
	$element_classes[] = 'grve-increase-heading';
	$element_classes[] = 'grve-heading-' . $increase_heading;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Typed Colors
$typed_colors = array( 'grve-animated-text' );
if ( 'none' != $text_bg_color ) {
	$typed_colors[] = 'grve-with-bg grve-bg-' . $text_bg_color;
}
$typed_colors_string = implode( ' ', $typed_colors );

$typed_id = uniqid('grve-typed-item-');

$typed_string_values = '';

if( !empty( $typed_values ) ) {

	$typed_values_array = explode(";", $typed_values);
	$typed_values_count= count( $typed_values_array );

	$typed_string_values = '[';

	foreach( $typed_values_array as $key => $value ) {
		$typed_string_values .= '"'. trim( htmlspecialchars_decode( strip_tags( $value ) ) ) . '"';
		if( $key != ( $typed_values_count-1 ) ) {
			$typed_string_values .= ',';
		}
	}
	$typed_string_values .= ']';
}

$loop = impeka_elementor_ext_text_to_bool( $loop );
$show_cursor = impeka_elementor_ext_text_to_bool( $show_cursor );

$script_code = '
jQuery(function($){
	$("#' . esc_attr( $typed_id ) . '").appear(function() {
		if ( typeof typed == "undefined" && !$().typed ) {
			console.log("Typed not Defined.");
			return true;
		}
		$("#' . esc_attr( $typed_id ) . '").typed({
			strings: ' . $typed_string_values . ',
			typeSpeed: ' . esc_attr( $textspeed ) . ',
			backSpeed: ' . esc_attr( $backspeed ) . ',
			startDelay: ' . esc_attr( $startdelay ) . ',
			backDelay: ' . esc_attr( $backdelay ) . ',
			loop: ' . esc_attr( $loop ) . ',
			loopCount: false,
			showCursor: ' . esc_attr( $show_cursor ) . ',
			cursorChar: "' . esc_attr( $cursor_text ) . '",
			contentType: null,
			attr: null
		});
	});
});
';

if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
	echo '<script>' . $script_code . '</script>';
} else {
	wp_add_inline_script( 'impeka-main', $script_code );
}

//OUTPUT

echo '<' . tag_escape( $heading_tag ) . ' ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<span class="grve-typed-text-prefix">' . wp_kses_post( $typed_prefix ) . ' </span>';
	echo '<span class="' . esc_attr( $typed_colors_string ) . '">';
		echo '<span id="' . esc_attr( $typed_id ) . '" class="grve-text-' . esc_attr( $text_color ) . '"><span class="grve-hidden">' . wp_kses_post( $typed_values ) . '</span></span>';
	echo '</span>';
	echo '<span class="grve-typed-text-suffix"> ' . wp_kses_post( $typed_suffix ) . '</span>';
echo '</' . tag_escape( $heading_tag ) . '>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
