<?php
/**
 * Impeka Elementor Blog Leader Widget.
 *
 * Elementor widget that inserts a blog grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Blog_Leader_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_blog_leader';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Blog Leader', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-blog-leader';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Number of Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1'  => esc_html__( 'Leader Only', 'impeka-elementor-extension' ),
					'3'  => esc_html__( 'Leader + 2 columns', 'impeka-elementor-extension' ),
					'4'  => esc_html__( 'Leader + 3 columns', 'impeka-elementor-extension' ),
					'5'  => esc_html__( 'Leader + 4 columns', 'impeka-elementor-extension' ),
				],
				'default' => '4',
				'description' => esc_html__( "Enter how many posts you want to display.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_area' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'square' => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape' => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'portrait' => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => 'landscape',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label' => esc_html__( 'Excerpt Length', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '30',
			]
		);
		$this->add_control(
			'excerpt_more',
			[
				'label' => esc_html__( 'Read More', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-elementor-extension" ),

			]
		);
		$this->add_control(
			'excerpt_more_text',
			[
				'label' => esc_html__( 'Read More Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'read more',
				'condition' => [
					'excerpt_more' => [ 'yes' ],
				],
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'leader_style',
			[
				'label' => esc_html__( 'Leader Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Horizontal' , 'impeka-elementor-extension' ),
					'vertical' => esc_html__( 'Vertical' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your Post Leader Style.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Leader Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'gradient', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'This affects the Background of the item.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Leader Background  Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the overlay opacity ( only if Featured Image is set )', 'impeka-elementor-extension' ),
				'default' => '30',
			]
		);
		$this->end_controls_section();

		//Titles Section
		$this->start_controls_section(
			'titles_section',
			[
				'label' => esc_html__( 'Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'heading_tag',
			[
				'label' => esc_html__( 'Post Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Post Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);
		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Leader Post Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Leader Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'default' => 'h2',
			]
		);
		$this->add_control(
			'small_post_heading',
			[
				'label' => esc_html__( 'Small Post Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Small Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'default' => 'h5',
			]
		);
		$this->end_controls_section();

		//Extras
		$this->start_controls_section(
			'extras_section',
			[
				'label' => esc_html__( 'Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_author',
			[
				'label' => esc_html__( 'Author Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the author field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_date',
			[
				'label' => esc_html__( 'Date Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the date field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_comments',
			[
				'label' => esc_html__( 'Comments Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the comments field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_like',
			[
				'label' => esc_html__( 'Like Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the like field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->end_controls_section();

		//Filters
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories(),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'blog-leader.php', array( 'atts' => $atts ) );
	}

}